package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherClientWrapper implements QetcherClient {
	private final QetcherClient delegate;

	public QetcherClientWrapper(final QetcherClient delegate) {
		this.delegate = delegate;
	}

	@Override
	public CompletableFuture<ConversionFile> uploadFile(final InputConversionFile inputFile) {
		return delegate.uploadFile(inputFile);
	}

	@Override
	public CompletableFuture<ConversionFile> getFile(final String fileId) {
		return delegate.getFile(fileId);
	}

	@Override
	public CompletableFuture<List<ConversionFile>> getFiles() {
		return delegate.getFiles();
	}

	@Override
	public CompletableFuture<Void> deleteFile(final String fileId) {
		return delegate.deleteFile(fileId);
	}

	@Override
	public CompletableFuture<Path> downloadAsFile(final String fileId, final Path file, final OpenOption... openOptions) {
		return delegate.downloadAsFile(fileId, file, openOptions);
	}

	@Override
	public CompletableFuture<Job> createJob(final InputJob inputJob) {
		return delegate.createJob(inputJob);
	}

	@Override
	public CompletableFuture<Job> getJob(final String jobId) {
		return delegate.getJob(jobId);
	}

	@Override
	public CompletableFuture<List<Job>> getJobs() {
		return delegate.getJobs();
	}

	@Override
	public CompletableFuture<Void> deleteJob(final String jobId) {
		return delegate.deleteJob(jobId);
	}

	@Override
	public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
		return delegate.getAvailableConversions();
	}

	@Override
	public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
		return delegate.getAvailableNodes();
	}

	@Override
	public CompletableFuture<ConversionFile> getFile(final ConversionFile file) {
		return delegate.getFile(file);
	}

	@Override
	public CompletableFuture<Void> deleteFile(final ConversionFile file) {
		return delegate.deleteFile(file);
	}

	@Override
	public CompletableFuture<Path> downloadAsFile(final String fileId, final Path file) {
		return delegate.downloadAsFile(fileId, file);
	}

	@Override
	public CompletableFuture<File> downloadAsFile(final String fileId, final File file) {
		return delegate.downloadAsFile(fileId, file);
	}

	@Override
	public CompletableFuture<Path> downloadAsTempFile(final String fileId) {
		return delegate.downloadAsTempFile(fileId);
	}

	@Override
	public CompletableFuture<Path> downloadAsTempFile(final String fileId, final Path dir) {
		return delegate.downloadAsTempFile(fileId, dir);
	}

	@Override
	public CompletableFuture<Job> getJob(final Job job) {
		return delegate.getJob(job);
	}

	@Override
	public CompletableFuture<Void> deleteJob(final Job job) {
		return delegate.deleteJob(job);
	}

	@Override
	public CompletableFuture<Job> getJobDone(final Job job) {
		return delegate.getJobDone(job);
	}

	@Override
	public CompletableFuture<Job> getJobDone(final String jobId) {
		return delegate.getJobDone(jobId);
	}

	@Override
	public void close() {
		delegate.close();
	}
}
