/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.micro.streamcopy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopy {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private StreamCopy() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return StreamCopy.copy(input, output, 4096);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return StreamCopy.copy(input, output, new byte[bufferSize]);
    }

    private static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

