/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.mklinger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.jgroups.PhysicalAddress;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.protocols.mklinger.HostAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialPingAddressesConverter
implements PropertyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(InitialPingAddressesConverter.class);

    public Object convert(Object obj, Class<?> propertyFieldType, String propertyName, String propertyValue, boolean check_scope) throws Exception {
        return InitialPingAddressesConverter.toResolveableInitialPingAddresses(propertyValue);
    }

    private static List<PhysicalAddress> toResolveableInitialPingAddresses(String initialPingAddresses) {
        ArrayList<PhysicalAddress> physicalAddresses = new ArrayList<PhysicalAddress>();
        StringTokenizer st = new StringTokenizer(initialPingAddresses, ",");
        while (st.hasMoreTokens()) {
            String inetSocketAddress = st.nextToken().trim();
            try {
                physicalAddresses.add((PhysicalAddress)new HostAddress(inetSocketAddress));
            }
            catch (Exception e) {
                LOG.warn("Ignoring initial ping address '{}': {}", (Object)inetSocketAddress, (Object)e.toString());
            }
        }
        LOG.info("Using resolveable initial ping addresses: '{}'", physicalAddresses);
        return physicalAddresses;
    }

    public String toString(Object value) {
        return ((Collection)value).stream().map(PhysicalAddress.class::cast).map(PhysicalAddress::printIpAddress).collect(Collectors.joining(","));
    }
}

