/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.mklinger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.protocols.mklinger.InetAddresses;
import org.jgroups.stack.IpAddress;

public class HostAddress
extends IpAddress {
    public HostAddress() {
    }

    public HostAddress(IpAddress ipAddress) {
        super(ipAddress.getIpAddress(), ipAddress.getPort());
    }

    public HostAddress(InetAddress i, int p) {
        super(i, p);
    }

    public HostAddress(InetSocketAddress sock_addr) {
        super(sock_addr);
    }

    public HostAddress(String addr_port) throws Exception {
        String ip;
        String hostName;
        String withoutPort;
        int lastColonIdx = addr_port.lastIndexOf(58);
        if (lastColonIdx == -1) {
            withoutPort = addr_port;
        } else {
            withoutPort = addr_port.substring(0, lastColonIdx);
            this.port = Integer.valueOf(addr_port.substring(lastColonIdx + 1));
        }
        int firstSlashIdx = withoutPort.indexOf(47);
        if (firstSlashIdx == -1) {
            hostName = null;
            ip = withoutPort;
        } else {
            hostName = withoutPort.substring(0, firstSlashIdx);
            if (hostName.isEmpty()) {
                hostName = null;
            }
            ip = withoutPort.substring(firstSlashIdx + 1);
        }
        byte[] ipBytes = InetAddresses.ipStringToBytes(ip);
        this.ip_addr = ipBytes == null ? InetAddress.getByName(ip) : InetAddress.getByAddress(hostName, ipBytes);
    }

    public Supplier<? extends IpAddress> create() {
        return HostAddress::new;
    }

    public HostAddress copy() {
        return new HostAddress(this.ip_addr, this.port);
    }

    public String printIpAddress() {
        return Objects.toString(this.ip_addr, "<null>") + ":" + this.port;
    }

    public String toString() {
        return this.printIpAddress();
    }

    public void writeTo(DataOutput out) throws Exception {
        this.writeHostName(out);
        this.writeIp(out);
        this.writePort(out);
    }

    private void writeHostName(DataOutput out) throws IOException {
        String hostName = this.getHostName();
        if (hostName == null) {
            out.writeInt(0);
        } else {
            out.writeInt(hostName.length());
            out.writeChars(hostName);
        }
    }

    public String getHostName() {
        String s = this.ip_addr.toString();
        int idx = s.indexOf(47);
        if (idx > 0) {
            return s.substring(0, idx);
        }
        return null;
    }

    private void writeIp(DataOutput out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
            if (this.ip_addr instanceof Inet6Address) {
                out.writeInt(((Inet6Address)this.ip_addr).getScopeId());
            }
        } else {
            out.writeByte(0);
        }
    }

    private void writePort(DataOutput out) throws IOException {
        out.writeShort(this.port);
    }

    public void readFrom(DataInput in) throws Exception {
        this.readHostNameAndIp(in);
        this.readPort(in);
    }

    private void readHostNameAndIp(DataInput in) throws IOException {
        String hostName = this.doReadHostName(in);
        byte len = in.readByte();
        if (len > 0 && len != 4 && len != 16) {
            throw new IOException("length has to be 4 or 16 bytes (was " + len + " bytes)");
        }
        byte[] a = new byte[len];
        in.readFully(a);
        if (len == 16) {
            int scope_id = in.readInt();
            this.ip_addr = Inet6Address.getByAddress(hostName, a, scope_id);
        } else {
            this.ip_addr = InetAddress.getByAddress(hostName, a);
        }
    }

    private String doReadHostName(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        char[] buf = new char[len];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = in.readChar();
        }
        return new String(buf);
    }

    private void readPort(DataInput in) throws IOException {
        this.port = in.readUnsignedShort();
    }

    public int serializedSize() {
        int tmp_size = 3;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr instanceof Inet4Address ? 4 : 20;
        }
        return tmp_size;
    }
}

