/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.mklinger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.mklinger.InitialPingAddressesConverter;
import org.jgroups.util.BoundedList;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPING
extends Discovery {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPPING.class);
    @Property(name="initial_ping_addresses", description="Comma delimited list of host:port pairs to be contacted for initial membership. Ideally, all members should be listed. If this is not possible, send_cache_on_join and / or return_entire_cache can be set to true", converter=InitialPingAddressesConverter.class)
    protected List<PhysicalAddress> initial_ping_addresses = Collections.emptyList();
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 2000;
    protected BoundedList<PhysicalAddress> dynamic_hosts;

    public void start() throws Exception {
        LOG.info("Using initial_ping_addresses: {}", this.initial_ping_addresses);
        super.start();
    }

    public boolean isDynamic() {
        return false;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedOperation
    public void clearDynamicHostList() {
        this.dynamic_hosts.clear();
    }

    public void init() throws Exception {
        super.init();
        this.dynamic_hosts = new BoundedList(this.max_dynamic_hosts);
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.view.getMembersRaw()) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, (Object)logical_addr));
                    if (physical_addr == null || this.initial_ping_addresses.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent((Object)physical_addr);
                }
                break;
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr == null || this.initial_ping_addresses.contains(physical_addr)) break;
                this.dynamic_hosts.addIfAbsent((Object)physical_addr);
            }
        }
        return retval;
    }

    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        if (physical_addr != null && !this.initial_ping_addresses.contains(physical_addr)) {
            this.dynamic_hosts.addIfAbsent((Object)physical_addr);
        }
    }

    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        Collection list;
        PingData data = null;
        PhysicalAddress physical_addr = null;
        if (!this.use_ip_addrs || !initial_discovery) {
            physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
            data = new PingData(this.local_addr, false, NameCache.get((Address)this.local_addr), physical_addr);
            if (members != null && members.size() <= this.max_members_in_discovery_request) {
                data.mbrs(members);
            }
        }
        ArrayList cluster_members = new ArrayList(this.initial_ping_addresses.size() + (this.dynamic_hosts != null ? this.dynamic_hosts.size() : 0) + 5);
        this.initial_ping_addresses.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        if (this.dynamic_hosts != null) {
            this.dynamic_hosts.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        }
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            list.stream().filter(phys_addr -> !cluster_members.contains(phys_addr)).forEach(cluster_members::add);
        }
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name).initialDiscovery(initial_discovery);
        for (PhysicalAddress addr : cluster_members) {
            if (addr.equals(physical_addr)) continue;
            Message msg = new Message((Address)addr).setFlag(new Message.Flag[]{Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB}).putHeader(this.id, (Header)hdr);
            if (data != null) {
                msg.setBuffer(HTTPPING.marshal((PingData)data));
            }
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> this.sendDiscoveryRequest(msg), this.sends_can_block);
                continue;
            }
            this.sendDiscoveryRequest(msg);
        }
    }

    protected void sendDiscoveryRequest(Message req) {
        try {
            this.log.trace("%s: sending discovery request to %s", new Object[]{this.local_addr, req.getDest()});
            this.down_prot.down(req);
        }
        catch (Throwable t) {
            this.log.trace("sending discovery request to %s failed: %s", new Object[]{req.dest(), t});
        }
    }

    static {
        ClassConfigurator.addProtocol((short)2001, HTTPPING.class);
    }
}

