/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.mklinger;

import de.mklinger.commons.httpclient.BodyHandlers;
import de.mklinger.commons.httpclient.BodyProviders;
import de.mklinger.commons.httpclient.HttpClient;
import de.mklinger.commons.httpclient.HttpRequest;
import de.mklinger.jgroups.http.client.ClientFactory;
import de.mklinger.jgroups.http.client.DefaultClientFactory;
import de.mklinger.jgroups.http.common.Closeables;
import de.mklinger.jgroups.http.common.PropertiesString;
import de.mklinger.jgroups.http.server.HttpReceiver;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.mklinger.HostAddress;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP
extends TP
implements HttpReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP.class);
    @Property(description="Http client properties.", systemProperty={"jgroups.http.client_props"}, writable=false)
    protected String client_props;
    @Property(description="Http client properties separator.", systemProperty={"jgroups.http.client_props_sep"}, writable=false)
    protected String client_props_sep = ",";
    @Property(description="Http service path.", systemProperty={"jgroups.http.external_path"}, writable=false)
    protected String external_path = "/jgroups";
    private ClientFactory clientFactory;
    private HttpClient client;

    public void start() throws Exception {
        this.requireValidServicePath();
        try {
            this.client = this.newClient();
            super.start();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw new RuntimeException("Error starting HTTP", e);
        }
    }

    private HttpClient newClient() {
        Properties clientProperties = this.client_props != null && !this.client_props.isEmpty() ? PropertiesString.fromString(this.client_props, this.client_props_sep) : new Properties();
        ClientFactory clientFactory = this.clientFactory != null ? this.clientFactory : this.newClientFactory(clientProperties);
        return clientFactory.newClient(clientProperties);
    }

    public void setClientFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    private ClientFactory newClientFactory(Properties httpClientProperties) {
        String clientFactoryClassName = httpClientProperties.getProperty("client-factory");
        if (clientFactoryClassName != null) {
            LOG.info("Using client factory {}", (Object)clientFactoryClassName);
            try {
                return (ClientFactory)Class.forName(clientFactoryClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error instantiating client factory " + clientFactoryClassName);
            }
        }
        LOG.info("Using default client factory");
        return new DefaultClientFactory();
    }

    private void requireValidServicePath() {
        if (this.external_path == null) {
            throw new IllegalArgumentException("external_path is null");
        }
        if (!this.external_path.isEmpty() && !this.external_path.startsWith("/")) {
            throw new IllegalArgumentException("external_path must be empty or start with '/'. Given: '" + this.external_path + "'");
        }
        LOG.info("Using external path '{}'", (Object)this.external_path);
    }

    public void destroy() {
        super.destroy();
        this.close();
    }

    private void close() {
        try {
            Closeables.closeUnchecked(new AutoCloseable[]{this.client});
        }
        finally {
            this.client = null;
        }
    }

    public boolean supportsMulticasting() {
        return false;
    }

    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToMembers(this.members, data, offset, length);
    }

    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this.send((IpAddress)dest, data, offset, length);
    }

    private void send(IpAddress destIpAddress, byte[] _data, int offset, int length) {
        byte[] data = new byte[length];
        System.arraycopy(_data, offset, data, 0, length);
        LOG.debug("Sending message to {}...", (Object)destIpAddress);
        HttpRequest request = HttpRequest.newBuilder((URI)this.getServiceUrl(destIpAddress)).header("X-Sender", this.getLocalPhysicalAddress()).POST(BodyProviders.fromByteArray((String)"application/x-jgroups-message", (byte[])data)).build();
        ((CompletableFuture)this.client.sendAsync(request, BodyHandlers.discard()).thenAccept(response -> LOG.debug("Send to {}: Complete: {}", (Object)destIpAddress, (Object)response.statusCode()))).exceptionally(failure -> {
            Throwable ex = failure;
            if (ex instanceof CompletionException) {
                ex = ex.getCause();
            }
            if (ex instanceof ConnectException || ex instanceof SocketTimeoutException) {
                LOG.info("Send to {}: Failed: {}", (Object)destIpAddress, (Object)ex.toString());
            } else {
                LOG.warn("Send to {}: Failed:", (Object)destIpAddress, (Object)ex);
            }
            return null;
        });
    }

    private URI getServiceUrl(IpAddress destIpAddress) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        String hostName = this.getHostName(destIpAddress);
        if (hostName != null) {
            LOG.debug("Using host name for service URL: {}", (Object)hostName);
            sb.append(hostName);
        } else {
            String hostAddress = destIpAddress.getIpAddress().getHostAddress();
            LOG.debug("Using ip address for service URL: {}", (Object)hostAddress);
            if (hostAddress.indexOf(58) != -1) {
                sb.append('[');
                sb.append(hostAddress);
                sb.append(']');
            } else {
                sb.append(hostAddress);
            }
        }
        sb.append(':');
        sb.append(destIpAddress.getPort());
        sb.append(this.external_path);
        return URI.create(sb.toString());
    }

    private String getHostName(IpAddress ipAddress) {
        if (ipAddress instanceof HostAddress) {
            return ((HostAddress)ipAddress).getHostName();
        }
        return null;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public String getInfo() {
        return "HTTP@" + this.getLocalPhysicalAddress();
    }

    protected PhysicalAddress getPhysicalAddress() {
        return this.createLocalAddress();
    }

    protected IpAddress createLocalAddress() {
        if (this.external_addr == null || this.external_port == 0) {
            throw new IllegalStateException("External address is not set");
        }
        return new HostAddress(this.external_addr, this.external_port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicalAddress getPhysicalAddress(Address dest) {
        if (dest instanceof PhysicalAddress) {
            return (PhysicalAddress)dest;
        }
        PhysicalAddress physical_dest = this.getPhysicalAddressFromCache(dest);
        if (physical_dest != null) {
            return physical_dest;
        }
        if (this.who_has_cache.addIfAbsentOrExpired((Object)dest)) {
            Responses responses = this.fetchResponsesFromDiscoveryProtocol(Collections.singletonList(dest));
            try {
                for (PingData data : responses) {
                    if (data.getAddress() == null || !data.getAddress().equals(dest) || (physical_dest = data.getPhysicalAddr()) == null) continue;
                    PhysicalAddress physicalAddress = physical_dest;
                    return physicalAddress;
                }
                this.log.warn(Util.getMessage((String)"PhysicalAddrMissing"), new Object[]{this.local_addr, dest});
            }
            finally {
                responses.done();
            }
        }
        return null;
    }

    static {
        ClassConfigurator.add((short)2000, HostAddress.class);
    }
}

