/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.server;

import de.mklinger.jgroups.http.common.Closeables;
import de.mklinger.jgroups.http.common.SizeValue;
import de.mklinger.jgroups.http.server.BadRequestException;
import de.mklinger.jgroups.http.server.HttpReceiver;
import de.mklinger.jgroups.http.server.JGroupsReadListener;
import de.mklinger.micro.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.protocols.mklinger.HTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JGroupsServlet
extends HttpServlet {
    private static final String PROPS_PREFIX = "de.mklinger.jgroups.http.";
    public static final String CHANNEL_ATTRIBUTE = "de.mklinger.jgroups.http.channel";
    private static final String RECEIVER_ATTRIBUTE = "de.mklinger.jgroups.http.receiver";
    private static final String MAX_CONTENT_LENGTH_ATTRIBUTE = "de.mklinger.jgroups.http.maxContentLength";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsServlet.class);

    public void init() throws ServletException {
        this.initMaxContentSize();
        ProtocolStackConfigurator protocolStackConfigurator = this.initProtocolStack();
        String channelName = this.getSetting("channelName", () -> null);
        JChannel channel = this.createChannel(protocolStackConfigurator, channelName);
        boolean connect = "true".equals(this.getSetting("connect", () -> "true"));
        if (connect) {
            String clusterName = this.getSetting("clusterName", () -> this.getSetting("cluster.name", () -> "jgroupscluster"));
            this.connectChannel(clusterName, channel);
        }
    }

    private void initMaxContentSize() throws ServletException {
        SizeValue maxContentSize = SizeValue.parseSizeValue(this.getSetting("maxContentSize", () -> "500k"));
        if (maxContentSize.singles() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max content size too large: " + maxContentSize);
        }
        this.getServletContext().setAttribute(MAX_CONTENT_LENGTH_ATTRIBUTE, (Object)((int)maxContentSize.singles()));
    }

    private ProtocolStackConfigurator initProtocolStack() throws ServletException {
        Map<String, String> protocolParameters = this.getProtocolParameters();
        String baseConfigLocation = this.getSetting("baseConfigLocation", () -> "classpath:http.xml");
        ProtocolStackConfigurator protocolStackConfigurator = this.getProtocolStackConfigurator(baseConfigLocation, protocolParameters);
        return protocolStackConfigurator;
    }

    private Map<String, String> getProtocolParameters() {
        String prefix = "protocol.";
        HashMap<String, String> protocolParameters = new HashMap<String, String>();
        Enumeration initParameterNames = this.getServletConfig().getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String parameterName = (String)initParameterNames.nextElement();
            if (!parameterName.startsWith("protocol.")) continue;
            String key = parameterName.substring("protocol.".length());
            String value = this.getServletConfig().getInitParameter(parameterName);
            protocolParameters.put(key, value);
        }
        return protocolParameters;
    }

    public ProtocolStackConfigurator getProtocolStackConfigurator(String baseConfigLocation, Map<String, String> protocolParameters) {
        Document doc = this.loadBaseConfig(baseConfigLocation);
        NodeList protocolElements = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < protocolElements.getLength(); ++i) {
            Node n = protocolElements.item(i);
            if (n.getNodeType() != 1) continue;
            Element element = (Element)n;
            this.applyProtocolParameters(element, protocolParameters);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Protocol stack configuration:\n\n{}", this.toString(doc));
        }
        try {
            return XmlConfigurator.getInstance((Element)doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JGroups xml", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document loadBaseConfig(String baseConfigLocation) {
        if (baseConfigLocation == null) throw new IllegalArgumentException();
        if (baseConfigLocation.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try (InputStream in = this.newInputStream(baseConfigLocation);){
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Error loading configuration: " + baseConfigLocation, e);
        }
    }

    private void applyProtocolParameters(Element element, Map<String, String> protocolParameters) {
        String protocolName = element.getNodeName();
        String prefix = protocolName + ".";
        for (Map.Entry<String, String> e : protocolParameters.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(prefix)) continue;
            String property = key.substring(prefix.length());
            element.setAttribute(property, e.getValue());
        }
    }

    private InputStream newInputStream(String configLocation) throws IOException {
        if (configLocation.startsWith("classpath:")) {
            String classpathLocation = configLocation.substring("classpath:".length());
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classpathLocation);
            if (in == null) {
                throw new IllegalArgumentException("Configuration not found on classpath: " + classpathLocation);
            }
            return in;
        }
        try {
            return new URI(configLocation).toURL().openStream();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Illegal configuration location: " + configLocation, e);
        }
    }

    private Object toString(Document doc) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JChannel createChannel(ProtocolStackConfigurator configurator, @Nullable String channelName) throws ServletException {
        JChannel channel;
        try {
            channel = new JChannel(configurator);
        }
        catch (Exception e) {
            throw new ServletException("Error creating channel", (Throwable)e);
        }
        if (channelName != null) {
            channel.setName(channelName);
        }
        this.getServletContext().setAttribute(CHANNEL_ATTRIBUTE, (Object)channel);
        HTTP httpProtocol = (HTTP)channel.getProtocolStack().getTransport();
        if (httpProtocol == null) {
            throw new IllegalStateException("HTTP protocol not found in channel protocol stack");
        }
        this.getServletContext().setAttribute(RECEIVER_ATTRIBUTE, (Object)httpProtocol);
        this.onChannelCreated(channel);
        return channel;
    }

    private void connectChannel(String clusterName, JChannel channel) {
        Thread connectThread = new Thread(() -> {
            try {
                channel.connect(clusterName);
                this.onChannelConnected(channel, clusterName);
            }
            catch (Throwable e) {
                this.onChannelConnectError(channel, clusterName, e);
            }
        });
        connectThread.setName("jgroups-channel-connect");
        connectThread.start();
    }

    private String getSetting(String name, Supplier<String> def) {
        String systemPropertyName = PROPS_PREFIX + name;
        String value = System.getProperty(systemPropertyName);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using system property '{}': '{}'", (Object)systemPropertyName, (Object)value);
            return value;
        }
        LOG.debug("System property not set: '{}'", (Object)systemPropertyName);
        value = this.getServletConfig().getInitParameter(name);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using init parameter '{}': '{}'", (Object)name, (Object)value);
            return value;
        }
        LOG.debug("Init parameter not set: '{}'", (Object)name);
        if (def == null) {
            throw new IllegalArgumentException("Missing required setting system property '" + systemPropertyName + "' or init parameter '" + name + "'");
        }
        value = def.get();
        LOG.debug("Using fallback value for setting '{}': '{}'", (Object)name, (Object)value);
        return value;
    }

    public void destroy() {
        JChannel channel = (JChannel)this.getServletContext().getAttribute(CHANNEL_ATTRIBUTE);
        if (channel != null) {
            this.getServletContext().removeAttribute(CHANNEL_ATTRIBUTE);
            try {
                this.onChannelClose(channel);
            }
            catch (Exception e) {
                LOG.warn("Error in onChannelClose callback", (Throwable)e);
            }
            Closeables.closeUnchecked(new AutoCloseable[]{channel});
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug("Service: {}", (Object)request.getMethod(), (Object)request.getRequestURL());
        HttpReceiver receiver = (HttpReceiver)this.getServletContext().getAttribute(RECEIVER_ATTRIBUTE);
        if (receiver == null) {
            throw new IllegalStateException("No receiver");
        }
        int maxContentLength = (Integer)this.getServletContext().getAttribute(MAX_CONTENT_LENGTH_ATTRIBUTE);
        AsyncContext asyncContext = request.startAsync();
        ServletInputStream inputStream = request.getInputStream();
        try {
            inputStream.setReadListener((ReadListener)new JGroupsReadListener(asyncContext, receiver, maxContentLength));
        }
        catch (BadRequestException e) {
            response.sendError(400, e.toString());
            asyncContext.complete();
        }
        catch (Exception e) {
            response.sendError(500);
            asyncContext.complete();
        }
    }

    protected void onChannelCreated(JChannel channel) {
    }

    protected void onChannelConnected(JChannel channel, String clusterName) {
    }

    protected void onChannelConnectError(JChannel channel, String clusterName, Throwable e) {
        LOG.error("Error connecting to cluster '{}'", (Object)clusterName, (Object)e);
    }

    protected void onChannelClose(JChannel channel) {
    }
}

