/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.server;

import de.mklinger.jgroups.http.common.SizeValue;
import de.mklinger.jgroups.http.server.BadRequestException;
import de.mklinger.jgroups.http.server.DirectAccessByteArrayOutputStream;
import de.mklinger.jgroups.http.server.HttpReceiver;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jgroups.Address;
import org.jgroups.protocols.mklinger.HostAddress;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsReadListener
implements ReadListener {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsReadListener.class);
    private final AsyncContext asyncContext;
    private final IpAddress sender;
    private final HttpReceiver receiver;
    private final int maxContentLength;
    private DirectAccessByteArrayOutputStream data;
    private byte[] buf;

    public JGroupsReadListener(AsyncContext asyncContext, HttpReceiver receiver, int maxContentLength) throws BadRequestException {
        this.asyncContext = asyncContext;
        this.receiver = receiver;
        this.maxContentLength = maxContentLength;
        HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
        this.sender = this.getSender(request);
        int dataSize = this.getDataSize(request);
        this.buf = new byte[Math.min(4096, dataSize)];
        this.data = new DirectAccessByteArrayOutputStream(dataSize);
    }

    private IpAddress getSender(HttpServletRequest request) throws BadRequestException {
        try {
            String senderAddress = Objects.requireNonNull(request.getHeader("X-Sender"), "Missing header 'X-Sender'");
            LOG.debug("Sender: {}", (Object)senderAddress);
            return new HostAddress(senderAddress);
        }
        catch (Exception e) {
            throw new BadRequestException(e);
        }
    }

    private int getDataSize(HttpServletRequest request) {
        long contentLengthLong = request.getContentLengthLong();
        if (contentLengthLong == -1L) {
            LOG.warn("No Content-Length header available");
            return 4096;
        }
        if (contentLengthLong > (long)this.maxContentLength) {
            throw new IllegalArgumentException("Content too large: " + new SizeValue(contentLengthLong));
        }
        return (int)contentLengthLong;
    }

    public void onDataAvailable() throws IOException {
        ServletInputStream inputStream = this.asyncContext.getRequest().getInputStream();
        try {
            while (inputStream.isReady()) {
                int len = inputStream.read(this.buf);
                if (len == -1) {
                    return;
                }
                LOG.debug("Read {} bytes async", (Object)len);
                if (this.data.size() + len > this.maxContentLength) {
                    throw new IllegalArgumentException("Content too large");
                }
                this.data.write(this.buf, 0, len);
            }
        }
        catch (Exception e) {
            LOG.error("Error in onDataAvailable()", (Throwable)e);
            throw e;
        }
    }

    public void onAllDataRead() throws IOException {
        try {
            byte[] messageData = this.data.getBuffer();
            int messageLen = this.data.size();
            this.data = null;
            this.buf = null;
            LOG.debug("Message read with {} bytes, calling receive()", (Object)messageData.length);
            this.receiver.receive((Address)this.sender, messageData, 0, messageLen);
            this.asyncContext.complete();
        }
        catch (Exception e) {
            LOG.error("Error in onAllDataRead()", (Throwable)e);
            throw e;
        }
    }

    public void onError(Throwable t) {
        LOG.error("Error", t);
        try {
            HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
            response.reset();
            response.sendError(500, t.toString());
        }
        catch (IOException e) {
            LOG.error("Error trying to send error response", (Throwable)e);
        }
        finally {
            this.asyncContext.complete();
        }
    }
}

