/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.common;

public class Closeables {
    public static void closeUnchecked(AutoCloseable ... closeables) {
        try {
            Closeables.close(closeables);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error on close", e);
        }
    }

    public static void close(AutoCloseable ... closeables) throws Exception {
        Exception error = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

