/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.client;

import de.mklinger.commons.httpclient.HttpClient;
import de.mklinger.jgroups.http.client.ClientFactory;
import de.mklinger.micro.keystores.KeyStores;
import java.security.KeyStore;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientFactory
implements ClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientFactory.class);

    @Override
    public HttpClient newClient(Properties clientProperties) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        this.configureClient(clientBuilder, clientProperties);
        return clientBuilder.build();
    }

    protected void configureClient(HttpClient.Builder clientBuilder, Properties clientProperties) {
        this.applyKeyStore(clientBuilder, clientProperties);
        this.applyTrustStore(clientBuilder, clientProperties);
        this.applyConnectTimeout(clientBuilder, clientProperties);
    }

    protected void applyKeyStore(HttpClient.Builder clientBuilder, Properties clientProperties) {
        String keystoreLocation = clientProperties.getProperty("ssl.key-store");
        if (keystoreLocation != null) {
            LOG.info("Using HTTP client keystore from '{}'", (Object)keystoreLocation);
            String keystorePassword = clientProperties.getProperty("ssl.key-store-password");
            KeyStore keyStore = KeyStores.load((String)keystoreLocation, (String)keystorePassword);
            String keyPassword = clientProperties.getProperty("ssl.key-password", keystorePassword);
            clientBuilder.keyStore(keyStore, keyPassword);
        }
    }

    protected void applyTrustStore(HttpClient.Builder clientBuilder, Properties clientProperties) {
        String truststoreLocation = clientProperties.getProperty("ssl.trust-store");
        if (truststoreLocation != null) {
            LOG.info("Using HTTP client truststore from '{}'", (Object)truststoreLocation);
            String truststorePassword = clientProperties.getProperty("ssl.trust-store-password");
            KeyStore trustStore = KeyStores.load((String)truststoreLocation, (String)truststorePassword);
            clientBuilder.trustStore(trustStore);
        }
    }

    protected void applyConnectTimeout(HttpClient.Builder clientBuilder, Properties clientProperties) {
        String connectTimeout = clientProperties.getProperty("connect-timeout");
        if (connectTimeout != null) {
            Duration d = this.toDuration(connectTimeout);
            LOG.info("Using HTTP client connect timeout {}", (Object)d);
            clientBuilder.connectTimeout(d);
        }
    }

    private Duration toDuration(String connectTimeout) {
        try {
            return Duration.parse(connectTimeout);
        }
        catch (DateTimeParseException e) {
            try {
                return Duration.ofMillis(Long.parseLong(connectTimeout));
            }
            catch (NumberFormatException e2) {
                e.addSuppressed(e2);
                throw e;
            }
        }
    }
}

