/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.mklinger;

import de.mklinger.jgroups.http.client.BytesContentProvider;
import de.mklinger.jgroups.http.client.CompleteListener;
import de.mklinger.jgroups.http.client.HttpClient;
import de.mklinger.jgroups.http.client.Result;
import de.mklinger.jgroups.http.common.Closeables;
import de.mklinger.jgroups.http.common.PropertiesString;
import de.mklinger.jgroups.http.server.HttpReceiver;
import java.net.ConnectException;
import java.util.Collections;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.mklinger.ClassConverter;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP
extends TP
implements HttpReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP.class);
    @Property(description="Http client implementation class. Must implement de.mklinger.jgroups.http.client.HttpClient", systemProperty={"de.mklinger.jgroups.http.clientImpl"}, converter=ClassConverter.class, writable=false)
    protected Class<? extends HttpClient> httpClientClass;
    @Property(description="Http client properties.", systemProperty={"de.mklinger.jgroups.http.clientProperties"}, writable=false)
    protected String httpClientPropertiesString;
    @Property(description="Http client properties separator.", systemProperty={"de.mklinger.jgroups.http.clientPropertiesSeparator"}, writable=false)
    protected String httpClientPropertiesStringSeparator = ",";
    private HttpClient client;
    private String servicePath = "/jgroups";
    private Properties httpClientProperties;

    public void setExternalAddress(IpAddress externalAddress) {
        this.external_addr = externalAddress.getIpAddress();
        this.external_port = externalAddress.getPort();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public void setHttpClientProperties(Properties httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public void start() throws Exception {
        this.requireValidServicePath();
        try {
            if (this.httpClientProperties == null && this.httpClientPropertiesString != null && !this.httpClientPropertiesString.isEmpty()) {
                this.httpClientProperties = PropertiesString.fromString(this.httpClientPropertiesString, this.httpClientPropertiesStringSeparator);
            }
            this.client = this.httpClientClass.newInstance();
            if (this.httpClientProperties != null) {
                this.client.configure(this.httpClientProperties);
            }
            this.client.start();
            super.start();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw new RuntimeException("Error instantiating http client class " + this.httpClientClass, e);
        }
    }

    private void requireValidServicePath() {
        if (this.servicePath == null) {
            throw new IllegalArgumentException("servicePath is null");
        }
        if (!this.servicePath.isEmpty() && !this.servicePath.startsWith("/")) {
            throw new IllegalArgumentException("servicePath must be empty or start with '/'. Given: '" + this.servicePath + "'");
        }
        LOG.info("Using service path '{}'", (Object)this.servicePath);
    }

    public void destroy() {
        super.destroy();
        this.close();
    }

    private void close() {
        try {
            Closeables.closeUnchecked(this.client);
        }
        finally {
            this.client = null;
        }
    }

    public boolean supportsMulticasting() {
        return false;
    }

    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToMembers(this.members, data, offset, length);
    }

    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this.send((IpAddress)dest, data, offset, length);
    }

    private void send(final IpAddress destIpAddress, byte[] _data, int offset, int length) {
        byte[] data = new byte[length];
        System.arraycopy(_data, offset, data, 0, length);
        this.client.newRequest(this.getServiceUrl(destIpAddress)).header("X-Sender", this.getLocalPhysicalAddress()).content(new BytesContentProvider("application/x-jgroups-message", data, 0, length)).send(new CompleteListener(){

            @Override
            public void onComplete(Result result) {
                if (result.isFailed()) {
                    if (result.getFailure() instanceof ConnectException) {
                        LOG.info("Send to {}: Failed: {}", (Object)destIpAddress, (Object)result.getFailure().toString());
                    } else {
                        LOG.warn("Send to {}: Failed:", (Object)destIpAddress, (Object)result.getFailure());
                    }
                } else {
                    LOG.debug("Send to {}: Complete: {}", (Object)destIpAddress, (Object)result.getResponse().getStatus());
                }
            }
        });
    }

    private String getServiceUrl(IpAddress destIpAddress) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        String hostAddress = destIpAddress.getIpAddress().getHostAddress();
        if (hostAddress.indexOf(58) != -1) {
            sb.append('[');
            sb.append(hostAddress);
            sb.append(']');
        } else {
            sb.append(hostAddress);
        }
        sb.append(':');
        sb.append(destIpAddress.getPort());
        sb.append(this.servicePath);
        return sb.toString();
    }

    public HttpClient getClient() {
        return this.client;
    }

    public String getInfo() {
        return "HTTP@" + this.getLocalPhysicalAddress();
    }

    protected PhysicalAddress getPhysicalAddress() {
        return this.createLocalAddress();
    }

    protected IpAddress createLocalAddress() {
        if (this.external_addr == null || this.external_port == 0) {
            throw new IllegalStateException("External address is not set");
        }
        return new IpAddress(this.external_addr, this.external_port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicalAddress getPhysicalAddress(Address dest) {
        if (dest instanceof PhysicalAddress) {
            return (PhysicalAddress)dest;
        }
        PhysicalAddress physical_dest = this.getPhysicalAddressFromCache(dest);
        if (physical_dest != null) {
            return physical_dest;
        }
        if (this.who_has_cache.addIfAbsentOrExpired((Object)dest)) {
            Responses responses = this.fetchResponsesFromDiscoveryProtocol(Collections.singletonList(dest));
            try {
                for (PingData data : responses) {
                    if (data.getAddress() == null || !data.getAddress().equals(dest) || (physical_dest = data.getPhysicalAddr()) == null) continue;
                    PhysicalAddress physicalAddress = physical_dest;
                    return physicalAddress;
                }
                this.log.warn(Util.getMessage((String)"PhysicalAddrMissing"), new Object[]{this.local_addr, dest});
            }
            finally {
                responses.done();
            }
        }
        return null;
    }
}

