/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.server;

import de.mklinger.jgroups.http.common.Closeables;
import de.mklinger.jgroups.http.common.SizeValue;
import de.mklinger.jgroups.http.server.BadRequestException;
import de.mklinger.jgroups.http.server.HttpReceiver;
import de.mklinger.jgroups.http.server.JGroupsReadListener;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jgroups.JChannel;
import org.jgroups.protocols.mklinger.HTTP;
import org.jgroups.stack.IpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsServlet
extends HttpServlet {
    private static final String PROPS_PREFIX = "de.mklinger.jgroups.http.";
    public static final String CHANNEL_ATTRIBUTE = "de.mklinger.jgroups.http.channel";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsServlet.class);
    private int maxContentLength;
    private HttpReceiver receiver;
    private JChannel channel;
    private String jchannelProps;

    public void init() throws ServletException {
        IpAddress externalAddress;
        String clusterName = this.getSetting("clusterName", Optional.of(() -> "jgroupscluster"));
        try {
            externalAddress = new IpAddress(this.getSetting("externalAddress", Optional.empty()));
        }
        catch (Exception e) {
            throw new ServletException("Invalid externalAddress", (Throwable)e);
        }
        String servicePath = this.getSetting("servicePath", Optional.of(() -> this.getServletContext().getContextPath() + "/jgroups"));
        SizeValue maxContentSize = SizeValue.parseSizeValue(this.getSetting("maxContentSize", Optional.of(() -> "500k")));
        if (maxContentSize.singles() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max content size too large: " + maxContentSize);
        }
        this.maxContentLength = (int)maxContentSize.singles();
        this.jchannelProps = this.getSetting("jchannelProps", Optional.of(() -> "http.xml"));
        Optional<Supplier<String>> nullDefault = Optional.of(() -> null);
        Properties httpClientProperties = new Properties();
        this.setNullableProperty(httpClientProperties, "ssl.key-store", this.getSetting("client.ssl.key-store", nullDefault));
        this.setNullableProperty(httpClientProperties, "ssl.key-store-password", this.getSetting("client.ssl.key-store-password", nullDefault));
        this.setNullableProperty(httpClientProperties, "ssl.key-password", this.getSetting("client.ssl.key-password", nullDefault));
        this.setNullableProperty(httpClientProperties, "ssl.trust-store", this.getSetting("client.ssl.trust-store", nullDefault));
        this.setNullableProperty(httpClientProperties, "ssl.trust-store-password", this.getSetting("client.ssl.trust-store-password", nullDefault));
        this.initChannel(clusterName, externalAddress, servicePath, httpClientProperties);
    }

    private void setNullableProperty(Properties properties, String key, String value) {
        if (key != null && value != null) {
            properties.setProperty(key, value);
        }
    }

    private void initChannel(String clusterName, IpAddress externalAddress, String servicePath, Properties httpClientProperties) throws ServletException {
        try {
            this.channel = new JChannel(this.jchannelProps);
        }
        catch (Exception e) {
            throw new ServletException("Error creating channel using '" + this.jchannelProps + "'", (Throwable)e);
        }
        this.getServletContext().setAttribute(CHANNEL_ATTRIBUTE, (Object)this.channel);
        this.onChannelCreated(this.channel);
        HTTP httpProtocol = (HTTP)this.channel.getProtocolStack().getTransport();
        httpProtocol.setExternalAddress(externalAddress);
        httpProtocol.setServicePath(servicePath);
        httpProtocol.setHttpClientProperties(httpClientProperties);
        this.receiver = httpProtocol;
        ForkJoinPool.commonPool().execute(() -> {
            try {
                this.channel.connect(clusterName);
                this.onChannelConnected(this.channel, clusterName);
            }
            catch (Exception e) {
                this.onChannelConnectError(this.channel, clusterName, e);
            }
        });
    }

    private String getSetting(String name, Optional<Supplier<String>> def) throws ServletException {
        String systemPropertyName = PROPS_PREFIX + name;
        String value = System.getProperty(systemPropertyName);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using system property '{}': '{}'", (Object)systemPropertyName, (Object)value);
            return value;
        }
        LOG.debug("System property not set: '{}'", (Object)systemPropertyName);
        value = this.getServletConfig().getInitParameter(name);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using init parameter '{}': '{}'", (Object)name, (Object)value);
            return value;
        }
        LOG.debug("Init parameter not set: '{}'", (Object)name);
        value = def.orElseThrow(() -> new ServletException("Missing required setting system property '" + systemPropertyName + "' or init parameter '" + name + "'")).get();
        LOG.debug("Using fallback value for setting '{}': '{}'", (Object)name, (Object)value);
        return value;
    }

    public void destroy() {
        Closeables.closeUnchecked(new AutoCloseable[]{this.channel});
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug("SERVICE: {} {}", (Object)request.getMethod(), (Object)request.getPathInfo());
        AsyncContext asyncContext = request.startAsync();
        ServletInputStream inputStream = request.getInputStream();
        try {
            inputStream.setReadListener((ReadListener)new JGroupsReadListener(asyncContext, this.receiver, this.maxContentLength));
        }
        catch (BadRequestException e) {
            response.sendError(400, e.toString());
        }
    }

    protected void onChannelCreated(JChannel channel) {
    }

    protected void onChannelConnected(JChannel channel, String clusterName) {
    }

    protected void onChannelConnectError(JChannel channel, String clusterName, Exception e) {
        LOG.error("Error connecting to cluster '{}'", (Object)clusterName, (Object)e);
    }
}

