/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.client.jetty;

import de.mklinger.jgroups.http.client.HttpClient;
import de.mklinger.jgroups.http.client.Request;
import de.mklinger.jgroups.http.client.jetty.JettyRequest;
import de.mklinger.jgroups.http.common.Keystores;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpClientImpl
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpClientImpl.class);
    private org.eclipse.jetty.client.HttpClient client;
    private KeyStore keystore;
    private String keystorePassword;
    private String keyPassword;
    private KeyStore truststore;
    private String truststorePassword;

    @Override
    public void configure(Properties clientProperties) {
        String truststoreLocation;
        if (this.client != null) {
            throw new IllegalStateException("Client already started");
        }
        String keystoreLocation = clientProperties.getProperty("ssl.key-store");
        if (keystoreLocation != null) {
            LOG.info("Using HTTP client keystore from '{}'", (Object)keystoreLocation);
            this.keystorePassword = clientProperties.getProperty("ssl.key-store-password");
            this.keystore = Keystores.load(keystoreLocation, Optional.ofNullable(this.keystorePassword));
            this.keyPassword = clientProperties.getProperty("ssl.key-password", this.keystorePassword);
        }
        if ((truststoreLocation = clientProperties.getProperty("ssl.trust-store")) != null) {
            LOG.info("Using HTTP client truststore from '{}'", (Object)truststoreLocation);
            this.truststorePassword = clientProperties.getProperty("ssl.trust-store-password");
            this.truststore = Keystores.load(truststoreLocation, Optional.ofNullable(this.truststorePassword));
        }
    }

    @Override
    public void start() {
        try {
            HttpClientTransportOverHTTP2 clientTransport = new HttpClientTransportOverHTTP2(new HTTP2Client());
            SslContextFactory sslContextFactory = new SslContextFactory(false);
            if (this.keystore != null) {
                sslContextFactory.setKeyStore(this.keystore);
                sslContextFactory.setKeyStorePassword(this.keyPassword);
            }
            if (this.truststore != null) {
                sslContextFactory.setTrustStore(this.truststore);
                sslContextFactory.setTrustStorePassword(this.truststorePassword);
            }
            this.client = new org.eclipse.jetty.client.HttpClient((HttpClientTransport)clientTransport, sslContextFactory);
            this.client.start();
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException("Error starting jetty http client", e);
            try {
                this.close();
            }
            catch (Exception e2) {
                rte.addSuppressed(e2);
            }
            throw rte;
        }
    }

    @Override
    public void close() {
        try {
            if (this.client != null) {
                this.client.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error stopping jetty http client", e);
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public Request newRequest(String url) {
        Objects.requireNonNull(this.client, "Client not started");
        return new JettyRequest(this.client.newRequest(url));
    }
}

