/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.client;

import de.mklinger.jgroups.http.client.ContentProvider;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BytesContentProvider
implements ContentProvider {
    private final String contentType;
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public BytesContentProvider(String contentType, byte[] bytes, int offset, int length) {
        this.contentType = contentType;
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private boolean empty;

            @Override
            public boolean hasNext() {
                return !this.empty;
            }

            @Override
            public ByteBuffer next() {
                this.empty = true;
                return ByteBuffer.wrap(BytesContentProvider.this.bytes, BytesContentProvider.this.offset, BytesContentProvider.this.length);
            }
        };
    }
}

