/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.server;

import de.mklinger.jgroups.http.common.Closeables;
import de.mklinger.jgroups.http.common.SizeValue;
import de.mklinger.jgroups.http.server.BadRequestException;
import de.mklinger.jgroups.http.server.HttpReceiver;
import de.mklinger.jgroups.http.server.JGroupsReadListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.protocols.mklinger.HTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JGroupsServlet
extends HttpServlet {
    private static final String PROPS_PREFIX = "de.mklinger.jgroups.http.";
    public static final String CHANNEL_ATTRIBUTE = "de.mklinger.jgroups.http.channel";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsServlet.class);
    private int maxContentLength;
    private HttpReceiver receiver;
    private JChannel channel;

    public void init() throws ServletException {
        String clusterName = this.getSetting("cluster.name", Optional.of(() -> "jgroupscluster"));
        String prefix = "protocol.";
        HashMap<String, String> protocolParameters = new HashMap<String, String>();
        Enumeration initParameterNames = this.getServletConfig().getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String parameterName = (String)initParameterNames.nextElement();
            if (!parameterName.startsWith("protocol.")) continue;
            String key = parameterName.substring("protocol.".length());
            String value = this.getServletConfig().getInitParameter(parameterName);
            protocolParameters.put(key, value);
        }
        SizeValue maxContentSize = SizeValue.parseSizeValue(this.getSetting("maxContentSize", Optional.of(() -> "500k")));
        if (maxContentSize.singles() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max content size too large: " + maxContentSize);
        }
        this.maxContentLength = (int)maxContentSize.singles();
        String baseConfigLocation = this.getSetting("baseConfigLocation", Optional.of(() -> "classpath:http.xml"));
        ProtocolStackConfigurator protocolStackConfigurator = this.getProtocolStackConfigurator(baseConfigLocation, protocolParameters);
        this.initChannel(clusterName, protocolStackConfigurator);
    }

    public ProtocolStackConfigurator getProtocolStackConfigurator(String baseConfigLocation, Map<String, String> protocolParameters) {
        Document doc;
        if (baseConfigLocation == null || baseConfigLocation.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try (InputStream in = this.newInputStream(baseConfigLocation);){
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Error loading configuration: " + baseConfigLocation, e);
        }
        NodeList protocolElements = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < protocolElements.getLength(); ++i) {
            Node n = protocolElements.item(i);
            if (n.getNodeType() != 1) continue;
            Element element = (Element)n;
            String protocolName = element.getNodeName();
            String prefix = protocolName + ".";
            for (Map.Entry<String, String> e : protocolParameters.entrySet()) {
                String key = e.getKey();
                if (!key.startsWith(prefix)) continue;
                String property = key.substring(prefix.length());
                element.setAttribute(property, e.getValue());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Protocol stack configuration:\n\n{}", this.toString(doc));
        }
        try {
            return XmlConfigurator.getInstance((Element)doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JGroups xml", e);
        }
    }

    private InputStream newInputStream(String configLocation) throws IOException {
        if (configLocation.startsWith("classpath:")) {
            String classpathLocation = configLocation.substring("classpath:".length());
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classpathLocation);
            if (in == null) {
                throw new IllegalArgumentException("Configuration not found on classpath: " + classpathLocation);
            }
            return in;
        }
        try {
            return new URI(configLocation).toURL().openStream();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Illegal configuration location: " + configLocation, e);
        }
    }

    private Object toString(Document doc) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initChannel(String clusterName, ProtocolStackConfigurator configurator) throws ServletException {
        try {
            this.channel = new JChannel(configurator);
        }
        catch (Exception e) {
            throw new ServletException("Error creating channel", (Throwable)e);
        }
        this.getServletContext().setAttribute(CHANNEL_ATTRIBUTE, (Object)this.channel);
        this.onChannelCreated(this.channel);
        HTTP httpProtocol = (HTTP)this.channel.getProtocolStack().getTransport();
        this.receiver = httpProtocol;
        Thread connectThread = new Thread(() -> {
            try {
                this.channel.connect(clusterName);
                this.onChannelConnected(this.channel, clusterName);
            }
            catch (Throwable e) {
                this.onChannelConnectError(this.channel, clusterName, e);
            }
        });
        connectThread.setName("jgroups-channel-connect");
        connectThread.start();
    }

    private String getSetting(String name, Optional<Supplier<String>> def) throws ServletException {
        String systemPropertyName = PROPS_PREFIX + name;
        String value = System.getProperty(systemPropertyName);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using system property '{}': '{}'", (Object)systemPropertyName, (Object)value);
            return value;
        }
        LOG.debug("System property not set: '{}'", (Object)systemPropertyName);
        value = this.getServletConfig().getInitParameter(name);
        if (value != null && !value.isEmpty()) {
            LOG.debug("Using init parameter '{}': '{}'", (Object)name, (Object)value);
            return value;
        }
        LOG.debug("Init parameter not set: '{}'", (Object)name);
        value = def.orElseThrow(() -> new ServletException("Missing required setting system property '" + systemPropertyName + "' or init parameter '" + name + "'")).get();
        LOG.debug("Using fallback value for setting '{}': '{}'", (Object)name, (Object)value);
        return value;
    }

    public void destroy() {
        if (this.channel != null) {
            try {
                this.onChannelClose(this.channel);
            }
            catch (Exception e) {
                LOG.warn("Error in onChannelClose callback", (Throwable)e);
            }
            Closeables.closeUnchecked(new AutoCloseable[]{this.channel});
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug("Service: {}", (Object)request.getMethod(), (Object)request.getRequestURL());
        AsyncContext asyncContext = request.startAsync();
        ServletInputStream inputStream = request.getInputStream();
        try {
            inputStream.setReadListener((ReadListener)new JGroupsReadListener(asyncContext, this.receiver, this.maxContentLength));
        }
        catch (BadRequestException e) {
            response.sendError(400, e.toString());
            asyncContext.complete();
        }
        catch (Exception e) {
            response.sendError(500);
            asyncContext.complete();
        }
    }

    protected void onChannelCreated(JChannel channel) {
    }

    protected void onChannelConnected(JChannel channel, String clusterName) {
    }

    protected void onChannelConnectError(JChannel channel, String clusterName, Throwable e) {
        LOG.error("Error connecting to cluster '{}'", (Object)clusterName, (Object)e);
    }

    protected void onChannelClose(JChannel channel) {
    }
}

