/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;

public class Keystores {
    private static final String CLASSPATH_PREFIX = "classpath:";

    public static KeyStore load(String location, Optional<String> password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream in = Keystores.newInputStream(location);){
                keyStore.load(in, Keystores.toCharArray(password));
            }
            return keyStore;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error loading keystore from location: " + location, e);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Error loading keystore from location: " + location, e);
        }
    }

    private static InputStream newInputStream(String location) throws IOException {
        if (location.startsWith(CLASSPATH_PREFIX)) {
            String classpathLocation = location.substring(CLASSPATH_PREFIX.length());
            InputStream in = Keystores.class.getClassLoader().getResourceAsStream(classpathLocation);
            if (in == null) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathLocation);
            }
            if (in == null) {
                throw new FileNotFoundException("Classpath resource not found: " + classpathLocation);
            }
            return in;
        }
        if (location.startsWith("/") || location.startsWith("./")) {
            return new FileInputStream(location);
        }
        return URI.create(location).toURL().openStream();
    }

    private static char[] toCharArray(Optional<String> password) {
        char[] pwd = password.isPresent() ? password.get().toCharArray() : null;
        return pwd;
    }
}

