/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.jgroups.http.client;

import de.mklinger.commons.httpclient.HttpClient;
import de.mklinger.jgroups.http.common.Keystores;
import java.security.KeyStore;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClientFactory.class);

    public static HttpClient newClient(Properties clientProperties) {
        HttpClient.Builder clientBuilder = HttpClient.newBuilder();
        ClientFactory.configureClient(clientBuilder, clientProperties);
        return clientBuilder.build();
    }

    private static void configureClient(HttpClient.Builder clientBuilder, Properties clientProperties) {
        String connectTimeout;
        String truststoreLocation;
        String keystoreLocation = clientProperties.getProperty("ssl.key-store");
        if (keystoreLocation != null) {
            LOG.info("Using HTTP client keystore from '{}'", (Object)keystoreLocation);
            String keystorePassword = clientProperties.getProperty("ssl.key-store-password");
            KeyStore keyStore = Keystores.load(keystoreLocation, Optional.ofNullable(keystorePassword));
            String keyPassword = clientProperties.getProperty("ssl.key-password", keystorePassword);
            clientBuilder.keyStore(keyStore, keyPassword);
        }
        if ((truststoreLocation = clientProperties.getProperty("ssl.trust-store")) != null) {
            LOG.info("Using HTTP client truststore from '{}'", (Object)truststoreLocation);
            String truststorePassword = clientProperties.getProperty("ssl.trust-store-password");
            KeyStore trustStore = Keystores.load(truststoreLocation, Optional.ofNullable(truststorePassword));
            clientBuilder.trustStore(trustStore);
        }
        if ((connectTimeout = clientProperties.getProperty("connect-timeout")) != null) {
            Duration d;
            try {
                d = Duration.parse(connectTimeout);
            }
            catch (DateTimeParseException e) {
                try {
                    d = Duration.ofMillis(Long.parseLong(connectTimeout));
                }
                catch (NumberFormatException e2) {
                    e.addSuppressed(e2);
                    throw e;
                }
            }
            LOG.info("Using HTTP client connect timeout {}", (Object)d);
            clientBuilder.connectTimeout(d);
        }
    }
}

