/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec.docker;

import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.docker.DockerCmdBuilderBase;
import de.mklinger.commons.exec.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class DockerCpCmdBuilder
extends DockerCmdBuilderBase<DockerCpCmdBuilder> {
    private String srcContainer;
    private String srcPath;
    private InputStream src;
    private String destContainer;
    private String destPath;
    private OutputStream dest;

    public DockerCpCmdBuilder() {
        super("cp");
    }

    public DockerCpCmdBuilder from(String srcContainer, String srcPath) {
        this.destContainer = null;
        this.srcContainer = Objects.requireNonNull(srcContainer);
        this.srcPath = Objects.requireNonNull(srcPath);
        this.src = null;
        return this;
    }

    public DockerCpCmdBuilder from(String srcPath) {
        this.srcContainer = null;
        this.srcPath = Objects.requireNonNull(srcPath);
        this.src = null;
        return this;
    }

    public DockerCpCmdBuilder from(Path srcPath) {
        return this.from(srcPath.toString());
    }

    public DockerCpCmdBuilder from(InputStream src) {
        this.srcContainer = null;
        this.srcPath = "-";
        this.src = src;
        return this;
    }

    public DockerCpCmdBuilder to(String destContainer, String destPath) {
        this.srcContainer = null;
        this.destContainer = Objects.requireNonNull(destContainer);
        this.destPath = Objects.requireNonNull(destPath);
        this.dest = null;
        return this;
    }

    public DockerCpCmdBuilder to(String destPath) {
        this.destContainer = null;
        this.destPath = Objects.requireNonNull(destPath);
        this.dest = null;
        return this;
    }

    public DockerCpCmdBuilder to(Path destPath) {
        return this.from(destPath.toString());
    }

    public DockerCpCmdBuilder to(OutputStream dest) {
        this.destContainer = null;
        this.destPath = "-";
        this.dest = Objects.requireNonNull(dest);
        return this;
    }

    public DockerCpCmdBuilder archive() {
        this.arg("-a");
        return this;
    }

    @Override
    public CmdSettings toCmdSettings() {
        CmdSettings cmdSettings = super.toCmdSettings();
        List command = cmdSettings.getCommand();
        if (this.srcContainer != null && this.destContainer != null || this.srcContainer == null && this.destContainer == null) {
            throw new IllegalStateException("Either from or to must be a container");
        }
        if (this.srcContainer != null) {
            command.add(this.srcContainer + ":" + this.srcPath);
        } else {
            command.add(this.srcPath);
        }
        if (this.destContainer != null) {
            command.add(this.destContainer + ":" + this.destPath);
        } else {
            command.add(this.destPath);
        }
        if (this.src != null && this.dest != null) {
            throw new IllegalStateException();
        }
        if (this.src != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)this.src, (OutputStream)bout);
                this.src.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            cmdSettings.setStdinBytes(bout.toByteArray());
        }
        if (this.dest != null) {
            cmdSettings.setStdout(this.dest);
        }
        return cmdSettings;
    }
}

