/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.test.certs;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.test.certs.BouncyCastleImpl;
import de.mklinger.test.certs.CertificateAndKeyPair;
import de.mklinger.test.certs.CertificateBuildException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;

public class CertificateBuilder {
    private static final int DEFAULT_VALID_DAYS = 1;
    private static final int DEFAULT_KEY_SIZE = 4096;
    private X500Name subject;
    private X500NameBuilder subjectBuilder;
    private int validDays = 1;
    private int keySize = 4096;
    private final Supplier<BigInteger> serialFactory = new DefaultSerialSupplier();
    private CertificateAndKeyPair issuer;
    private boolean ca;
    private boolean serverAuth;
    private boolean clientAuth;
    private List<String> ipSans;
    private List<String> dnsSans;

    public CertificateBuilder() {
        BouncyCastleImpl.installBouncyCastle();
    }

    public CertificateBuilder subject(String subject) {
        this.subjectBuilder = null;
        this.subject = new X500Name(subject);
        return this;
    }

    public CertificateBuilder subject(String oid, String value) {
        this.subject = null;
        this.addSubjectRdn(new ASN1ObjectIdentifier(oid), value);
        return this;
    }

    public CertificateBuilder subjectCn(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.CN, value);
        return this;
    }

    public CertificateBuilder subjectC(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.C, value);
        return this;
    }

    public CertificateBuilder subjectO(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.O, value);
        return this;
    }

    public CertificateBuilder subjectOu(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.OU, value);
        return this;
    }

    public CertificateBuilder subjectT(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.T, value);
        return this;
    }

    public CertificateBuilder subjectStreet(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.STREET, value);
        return this;
    }

    public CertificateBuilder subjectL(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.L, value);
        return this;
    }

    public CertificateBuilder subjectSt(String value) {
        this.subject = null;
        this.addSubjectRdn(BCStyle.ST, value);
        return this;
    }

    private void addSubjectRdn(ASN1ObjectIdentifier oid, String value) {
        if (this.subjectBuilder == null) {
            this.subjectBuilder = new X500NameBuilder();
        }
        this.subjectBuilder.addRDN(oid, value);
    }

    @VisibleForTesting
    protected X500Name getSubject() {
        if (this.subject != null) {
            return this.subject;
        }
        if (this.subjectBuilder != null) {
            return this.subjectBuilder.build();
        }
        throw new CertificateBuildException("Missing subject");
    }

    public CertificateBuilder ca() {
        return this.ca(true);
    }

    public CertificateBuilder ca(boolean ca) {
        this.ca = ca;
        return this;
    }

    public CertificateBuilder validDays(int validDays) {
        this.validDays = validDays;
        return this;
    }

    public CertificateBuilder keySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    public CertificateBuilder issuer(CertificateAndKeyPair issuer) {
        this.issuer = issuer;
        return this;
    }

    public CertificateBuilder serverAuth() {
        return this.serverAuth(true);
    }

    public CertificateBuilder serverAuth(boolean serverAuth) {
        this.serverAuth = serverAuth;
        return this;
    }

    public CertificateBuilder clientAuth() {
        return this.clientAuth(true);
    }

    public CertificateBuilder clientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public CertificateBuilder ipSan(String ipSan) {
        if (this.ipSans == null) {
            this.ipSans = new ArrayList<String>();
        }
        this.ipSans.add(ipSan);
        return this;
    }

    public CertificateBuilder dnsSan(String dnsSan) {
        if (this.dnsSans == null) {
            this.dnsSans = new ArrayList<String>();
        }
        this.dnsSans.add(dnsSan);
        return this;
    }

    public CertificateAndKeyPair build() {
        KeyPair keyPair = BouncyCastleImpl.generateRSAKeyPair(this.keySize);
        X509CertificateHolder issuerCertificateHolder = this.issuer == null ? null : this.issuer.getBcCertificateHolder();
        X509v3CertificateBuilder certBuilder = BouncyCastleImpl.baseCertBuilder(issuerCertificateHolder, keyPair, this.getSubject(), this.serialFactory.get(), this.validDays, this.ca);
        BouncyCastleImpl.addAuthExtension(certBuilder, this.serverAuth, this.clientAuth);
        BouncyCastleImpl.addSanExtension(certBuilder, this.ipSans, this.dnsSans);
        ContentSigner contentSigner = this.issuer == null ? BouncyCastleImpl.contentSigner(keyPair.getPrivate()) : BouncyCastleImpl.contentSigner(this.issuer.getKeyPair().getPrivate());
        X509CertificateHolder certificateHolder = certBuilder.build(contentSigner);
        X509Certificate certificate = BouncyCastleImpl.toJcaCertificate(certificateHolder);
        return new CertificateAndKeyPair(certificateHolder, certificate, keyPair);
    }

    private static class DefaultSerialSupplier
    implements Supplier<BigInteger> {
        private static final AtomicLong next = new AtomicLong();

        private DefaultSerialSupplier() {
        }

        @Override
        public BigInteger get() {
            long current = next.getAndIncrement();
            return BigInteger.valueOf(current);
        }
    }
}

