/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.test.certs;

import de.mklinger.micro.annotations.Nullable;
import de.mklinger.test.certs.CertificateBuildException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNamesBuilder;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

class BouncyCastleImpl {
    private static final AtomicReference<SecureRandom> secureRandom = new AtomicReference();

    private static SecureRandom secureRandom() {
        return secureRandom.updateAndGet(current -> {
            if (current == null) {
                return new SecureRandom();
            }
            return current;
        });
    }

    private BouncyCastleImpl() {
    }

    private static boolean isBcInstalled() {
        return Security.getProvider("BC") != null;
    }

    static void installBouncyCastle() {
        if (!BouncyCastleImpl.isBcInstalled()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (!BouncyCastleImpl.isBcInstalled()) {
            throw new CertificateBuildException("Installing BouncyCastle security provider failed");
        }
    }

    static void addSanExtension(X509v3CertificateBuilder certBuilder, List<String> ipSans, List<String> dnsSans) {
        BouncyCastleImpl.wrapExceptions(() -> {
            BouncyCastleImpl.doAddSanExtension(certBuilder, ipSans, dnsSans);
            return null;
        });
    }

    private static void doAddSanExtension(X509v3CertificateBuilder certBuilder, List<String> ipSans, List<String> dnsSans) throws IOException {
        boolean haveSans;
        boolean haveIpSans = ipSans != null && !ipSans.isEmpty();
        boolean haveDnsSans = dnsSans != null && !dnsSans.isEmpty();
        boolean bl = haveSans = haveIpSans || haveDnsSans;
        if (haveSans) {
            GeneralNamesBuilder generalNamesBuilder = new GeneralNamesBuilder();
            if (haveIpSans) {
                for (String ipSan : ipSans) {
                    generalNamesBuilder.addName(new GeneralName(7, ipSan));
                }
            }
            if (haveDnsSans) {
                for (String dnsSan : dnsSans) {
                    generalNamesBuilder.addName(new GeneralName(2, dnsSan));
                }
            }
            Extension extension = new Extension(Extension.subjectAlternativeName, false, generalNamesBuilder.build().getEncoded());
            certBuilder.addExtension(extension);
        }
    }

    static void addAuthExtension(X509v3CertificateBuilder certBuilder, boolean serverAuth, boolean clientAuth) {
        BouncyCastleImpl.wrapExceptions(() -> {
            BouncyCastleImpl.doAddAuthExtension(certBuilder, serverAuth, clientAuth);
            return null;
        });
    }

    private static void doAddAuthExtension(X509v3CertificateBuilder certBuilder, boolean serverAuth, boolean clientAuth) throws IOException {
        if (serverAuth || clientAuth) {
            ArrayList<KeyPurposeId> keyPurposeIds = new ArrayList<KeyPurposeId>(2);
            if (serverAuth) {
                keyPurposeIds.add(KeyPurposeId.id_kp_serverAuth);
            }
            if (clientAuth) {
                keyPurposeIds.add(KeyPurposeId.id_kp_clientAuth);
            }
            Extension extension = new Extension(Extension.extendedKeyUsage, false, new ExtendedKeyUsage((KeyPurposeId[])keyPurposeIds.toArray(KeyPurposeId[]::new)).getEncoded());
            certBuilder.addExtension(extension);
        }
    }

    static KeyPair generateRSAKeyPair(int keySize) {
        return BouncyCastleImpl.wrapExceptions(() -> BouncyCastleImpl.doGenerateRSAKeyPair(keySize));
    }

    private static KeyPair doGenerateRSAKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(keySize, BouncyCastleImpl.secureRandom());
        return kpGen.generateKeyPair();
    }

    private static SubjectPublicKeyInfo subjectPublicKeyInfo(PublicKey publicKey) {
        byte[] pk = publicKey.getEncoded();
        return SubjectPublicKeyInfo.getInstance((Object)pk);
    }

    static ContentSigner contentSigner(PrivateKey privateKey) {
        return BouncyCastleImpl.wrapExceptions(() -> BouncyCastleImpl.contentSigner(privateKey, "SHA256"));
    }

    private static ContentSigner contentSigner(PrivateKey signatureKey, String hashAlgorithm) throws OperatorCreationException {
        String keyAlgo = signatureKey.getAlgorithm();
        String signatureAlgorithm = "EC".equalsIgnoreCase(keyAlgo) ? hashAlgorithm + "WITHECDSA" : hashAlgorithm + "WITH" + keyAlgo;
        return new JcaContentSignerBuilder(signatureAlgorithm).build(signatureKey);
    }

    static X509Certificate toJcaCertificate(X509CertificateHolder cert) {
        return BouncyCastleImpl.wrapExceptions(() -> new JcaX509CertificateConverter().getCertificate(cert));
    }

    static X509v3CertificateBuilder baseCertBuilder(@Nullable X509CertificateHolder rootCert, KeyPair keyPair, X500Name subject, BigInteger serial, int days, boolean ca) {
        return BouncyCastleImpl.wrapExceptions(() -> BouncyCastleImpl.doBaseCertBuilder(rootCert, keyPair, subject, serial, days, ca));
    }

    private static X509v3CertificateBuilder doBaseCertBuilder(@Nullable X509CertificateHolder rootCert, KeyPair keyPair, X500Name subject, BigInteger serial, int days, boolean ca) throws NoSuchAlgorithmException, CertIOException {
        Date notBefore = new Date();
        Date notAfter = Date.from(ZonedDateTime.now().plusDays(days).toInstant());
        X500Name issuer = rootCert == null ? subject : rootCert.getSubject();
        SubjectPublicKeyInfo subjectPublicKeyInfo = BouncyCastleImpl.subjectPublicKeyInfo(keyPair.getPublic());
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, subjectPublicKeyInfo);
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        if (rootCert != null) {
            certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(rootCert));
        }
        certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(subjectPublicKeyInfo)).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(ca));
        if (ca) {
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
        } else {
            certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(168));
        }
        return certBuilder;
    }

    private static <V> V wrapExceptions(Callable<V> c) {
        try {
            return c.call();
        }
        catch (Exception e) {
            throw new CertificateBuildException(e);
        }
    }
}

