/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.maven;

import de.mirkosertic.bytecoder.allocator.Allocator;
import de.mirkosertic.bytecoder.api.Logger;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.CompileTarget;
import de.mirkosertic.bytecoder.backend.LLVMOptimizationLevel;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.optimizer.KnownOptimizer;
import de.mirkosertic.bytecoder.optimizer.Optimizer;
import de.mirkosertic.bytecoder.unittest.Slf4JLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BytecoderMavenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classFiles;
    @Parameter(required=true)
    protected String mainClass;
    @Parameter(required=true, defaultValue="js")
    protected String backend;
    @Parameter(defaultValue="${project.build.directory}")
    protected String buildDirectory;
    @Parameter(required=false, defaultValue="false")
    protected boolean debugOutput;
    @Parameter(required=false, defaultValue="false")
    protected boolean enableExceptionHandling;
    @Parameter(required=false, defaultValue="ALL")
    protected String optimizationLevel;
    @Parameter(required=false, defaultValue="bytecoder")
    protected String filenamePrefix;
    @Parameter(required=false, defaultValue="512")
    protected int wasmInitialPages;
    @Parameter(required=false, defaultValue="1024")
    protected int wasmMaximumPages;
    @Parameter(required=false, defaultValue="true")
    protected boolean minifyCompileResult;
    @Parameter(required=false, defaultValue="false")
    protected boolean preferStackifier;
    @Parameter(required=false, defaultValue="linear")
    protected String registerAllocator;
    @Parameter(required=false)
    protected String[] additionalClassesToLink = new String[0];
    @Parameter(required=false)
    protected String[] additionalResources = new String[0];
    @Parameter(required=false, defaultValue="O2")
    protected String llvmOptimizationLevel = LLVMOptimizationLevel.defaultValue().name();
    @Parameter(required=false, defaultValue="false")
    protected boolean escapeAnalysisEnabled = false;

    public void execute() throws MojoExecutionException {
        File theBaseDirectory = new File(this.buildDirectory);
        File theBytecoderDirectory = new File(theBaseDirectory, "bytecoder");
        theBytecoderDirectory.mkdirs();
        try {
            ClassLoader theLoader = this.prepareClassLoader();
            Class<?> theTargetClass = theLoader.loadClass(this.mainClass);
            CompileTarget theCompileTarget = new CompileTarget(theLoader, CompileTarget.BackendType.valueOf((String)this.backend));
            BytecodeMethodSignature theSignature = new BytecodeMethodSignature((BytecodeTypeRef)BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{new BytecodeArrayTypeRef((BytecodeTypeRef)BytecodeObjectTypeRef.fromRuntimeClass(String.class), 1)});
            CompileOptions theOptions = new CompileOptions((Logger)new Slf4JLogger(), this.debugOutput, (Optimizer)KnownOptimizer.valueOf((String)this.optimizationLevel), this.enableExceptionHandling, this.filenamePrefix, this.wasmInitialPages, this.wasmMaximumPages, this.minifyCompileResult, this.preferStackifier, Allocator.valueOf((String)this.registerAllocator), this.additionalClassesToLink, this.additionalResources, LLVMOptimizationLevel.valueOf((String)this.llvmOptimizationLevel), this.escapeAnalysisEnabled);
            CompileResult theCode = theCompileTarget.compile(theOptions, theTargetClass, "main", theSignature);
            for (CompileResult.Content content : theCode.getContent()) {
                File theBytecoderFileName = new File(theBytecoderDirectory, content.getFileName());
                try (FileOutputStream theFos = new FileOutputStream(theBytecoderFileName);){
                    content.writeTo((OutputStream)theFos);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running bytecoder", e);
        }
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    protected final ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> theURLs = new ArrayList<URL>();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!this.isSupportedScope(artifact.getScope())) continue;
                File file = artifact.getFile();
                theURLs.add(file.toURI().toURL());
            }
            theURLs.add(this.classFiles.toURI().toURL());
            return new URLClassLoader(theURLs.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Cannot create classloader", (Exception)e);
        }
    }
}

