/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.unittest;

import de.mirkosertic.bytecoder.backend.CompileTarget;

public class TestOption {
    private final CompileTarget.BackendType backendType;
    private final boolean preferStackifier;
    private final boolean exceptionsEnabled;
    private final boolean minify;

    public TestOption(CompileTarget.BackendType backendType, boolean preferStackifier, boolean exceptionsEnabled, boolean minify) {
        this.backendType = backendType;
        this.preferStackifier = preferStackifier;
        this.exceptionsEnabled = exceptionsEnabled;
        this.minify = minify;
    }

    public String toDescription() {
        return "backend=" + this.backendType.toString() + " preferStackifier=" + this.preferStackifier + " minify=" + this.minify + " exceptionsEnabled=" + this.exceptionsEnabled;
    }

    public String toFilePrefix() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.backendType.toString());
        if (this.preferStackifier) {
            builder.append("_stackifier");
        }
        if (this.minify) {
            builder.append("_minify");
        }
        if (this.exceptionsEnabled) {
            builder.append("_exceptionsEnabled");
        }
        return builder.toString();
    }

    public CompileTarget.BackendType getBackendType() {
        return this.backendType;
    }

    public boolean isPreferStackifier() {
        return this.preferStackifier;
    }

    public boolean isExceptionsEnabled() {
        return this.exceptionsEnabled;
    }

    public boolean isMinify() {
        return this.minify;
    }
}

