/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.unittest;

import com.sun.net.httpserver.HttpServer;
import de.mirkosertic.bytecoder.allocator.Allocator;
import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.CompileResult;
import de.mirkosertic.bytecoder.backend.CompileTarget;
import de.mirkosertic.bytecoder.backend.LLVMOptimizationLevel;
import de.mirkosertic.bytecoder.backend.js.JSCompileResult;
import de.mirkosertic.bytecoder.backend.llvm.LLVMCompileResult;
import de.mirkosertic.bytecoder.backend.llvm.LLVMWriterUtils;
import de.mirkosertic.bytecoder.backend.wasm.WASMCompileResult;
import de.mirkosertic.bytecoder.backend.wasm.WASMWriterUtils;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.optimizer.KnownOptimizer;
import de.mirkosertic.bytecoder.unittest.BytecoderTestOption;
import de.mirkosertic.bytecoder.unittest.BytecoderTestOptions;
import de.mirkosertic.bytecoder.unittest.FrameworkMethodWithTestOption;
import de.mirkosertic.bytecoder.unittest.Slf4JLogger;
import de.mirkosertic.bytecoder.unittest.TestOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.BrowserWebDriverContainer;

public class BytecoderUnitTestRunner
extends ParentRunner<FrameworkMethodWithTestOption> {
    private static final Slf4JLogger LOGGER = new Slf4JLogger();
    private final List<TestOption> testOptions = new ArrayList<TestOption>();
    private final String[] additionalClassesToLink;
    private final String[] additionalResources;
    private static HttpServer TESTSERVER;
    private static BrowserWebDriverContainer SELENIUMCONTAINER;
    private static final AtomicReference<File> HTTPFILESDIR;

    public BytecoderUnitTestRunner(Class aClass) throws InitializationError {
        super(aClass);
        BytecoderTestOptions declaredOptions = this.getTestClass().getJavaClass().getAnnotation(BytecoderTestOptions.class);
        if (declaredOptions != null) {
            if (declaredOptions.includeJVM()) {
                this.testOptions.add(new TestOption(null, false, false, false));
            }
            if (declaredOptions.value().length == 0 && declaredOptions.includeTestPermutations()) {
                this.testOptions.add(new TestOption(CompileTarget.BackendType.js, false, false, false));
                this.testOptions.add(new TestOption(CompileTarget.BackendType.js, false, false, true));
                this.testOptions.add(new TestOption(CompileTarget.BackendType.js, true, false, false));
                this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm, false, false, false));
                this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm, true, false, false));
                this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm_llvm, false, false, false));
            } else {
                for (BytecoderTestOption o : declaredOptions.value()) {
                    this.testOptions.add(new TestOption(o.backend(), o.preferStackifier(), o.exceptionsEnabled(), o.minify()));
                }
            }
            this.additionalClassesToLink = declaredOptions.additionalClassesToLink();
            this.additionalResources = declaredOptions.additionalResources();
        } else {
            this.testOptions.add(new TestOption(null, false, false, false));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.js, false, false, false));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.js, false, false, true));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.js, true, false, false));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm, false, false, false));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm, true, false, false));
            this.testOptions.add(new TestOption(CompileTarget.BackendType.wasm_llvm, false, false, false));
            this.additionalClassesToLink = new String[0];
            this.additionalResources = new String[0];
        }
    }

    public Description getDescription() {
        TestClass testClass = this.getTestClass();
        return Description.createSuiteDescription((String)testClass.getName(), (Annotation[])testClass.getJavaClass().getAnnotations());
    }

    protected List<FrameworkMethodWithTestOption> getChildren() {
        Method[] classMethods;
        ArrayList<FrameworkMethodWithTestOption> testMethods = new ArrayList<FrameworkMethodWithTestOption>();
        TestClass testClass = this.getTestClass();
        for (Method classMethod : classMethods = testClass.getJavaClass().getDeclaredMethods()) {
            String methodName;
            Class<?> retClass = classMethod.getReturnType();
            int length = classMethod.getParameterTypes().length;
            int modifiers = classMethod.getModifiers();
            if (null == retClass || 0 != length || Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers) || !(methodName = classMethod.getName()).toUpperCase().startsWith("TEST") && null == classMethod.getAnnotation(Test.class)) continue;
            if (classMethod.isAnnotationPresent(Ignore.class)) {
                testMethods.add(new FrameworkMethodWithTestOption(classMethod, this.testOptions.get(0)));
                continue;
            }
            for (TestOption o : this.testOptions) {
                testMethods.add(new FrameworkMethodWithTestOption(classMethod, o));
            }
        }
        return testMethods;
    }

    protected Description describeChild(FrameworkMethodWithTestOption frameworkMethod) {
        TestClass testClass = this.getTestClass();
        return Description.createTestDescription((Class)testClass.getJavaClass(), (String)frameworkMethod.getName());
    }

    private void testJVMBackendFrameworkMethod(FrameworkMethod aFrameworkMethod, RunNotifier aRunNotifier) {
        if ("".equals(System.getProperty("BYTECODER_DISABLE_JVMTESTS", ""))) {
            TestClass testClass = this.getTestClass();
            Description theDescription = Description.createTestDescription((Class)testClass.getJavaClass(), (String)(aFrameworkMethod.getName() + " JVM Target"));
            aRunNotifier.fireTestStarted(theDescription);
            try {
                Object theInstance = testClass.getJavaClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method theMethod = aFrameworkMethod.getMethod();
                theMethod.invoke(theInstance, new Object[0]);
                aRunNotifier.fireTestFinished(theDescription);
            }
            catch (Exception e) {
                aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)e));
            }
        }
    }

    private static int getTestWebServerPort() {
        return Integer.parseInt(System.getProperty("BYTECODER_TESTSERVERPORT", "10000"));
    }

    private static synchronized BrowserWebDriverContainer initializeSeleniumContainer() {
        if (SELENIUMCONTAINER == null) {
            Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
            ChromeOptions theOptions = new ChromeOptions().setHeadless(true);
            theOptions.addArguments(new String[]{"--js-flags=experimental-wasm-eh"});
            theOptions.addArguments(new String[]{"--enable-experimental-wasm-eh"});
            theOptions.addArguments(new String[]{"disable-infobars"});
            theOptions.addArguments(new String[]{"--disable-dev-shm-usage"});
            theOptions.addArguments(new String[]{"--no-sandbox"});
            theOptions.setExperimentalOption("useAutomationExtension", (Object)false);
            LoggingPreferences theLoggingPreferences = new LoggingPreferences();
            theLoggingPreferences.enable("browser", Level.ALL);
            theOptions.setCapability("loggingPrefs", (Object)theLoggingPreferences);
            theOptions.setCapability("goog:loggingPrefs", (Object)theLoggingPreferences);
            Testcontainers.exposeHostPorts((int[])new int[]{BytecoderUnitTestRunner.getTestWebServerPort()});
            SELENIUMCONTAINER = new BrowserWebDriverContainer().withCapabilities((Capabilities)theOptions).withRecordingMode(BrowserWebDriverContainer.VncRecordingMode.SKIP, new File("."));
            SELENIUMCONTAINER.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> SELENIUMCONTAINER.stop()));
        }
        return SELENIUMCONTAINER;
    }

    private static void initializeTestWebServer() throws IOException {
        if (TESTSERVER == null) {
            Logger.getLogger("sun.net.httpserver.ExchangeImpl").setLevel(Level.OFF);
            TESTSERVER = HttpServer.create();
            int port = BytecoderUnitTestRunner.getTestWebServerPort();
            TESTSERVER.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), 20);
            TESTSERVER.createContext("/", httpExchange -> {
                int lastSlash;
                String fileName;
                String requestedFileName;
                File filesDir = HTTPFILESDIR.get();
                File requestedFile = new File(filesDir, requestedFileName = (fileName = httpExchange.getRequestURI().getPath()).substring((lastSlash = fileName.lastIndexOf(47)) + 1));
                if (requestedFile.exists()) {
                    if (requestedFileName.endsWith(".html")) {
                        httpExchange.getResponseHeaders().add("Content-Type", "text/html");
                    } else if (requestedFileName.endsWith(".js")) {
                        httpExchange.getResponseHeaders().add("Content-Type", "text/javascript");
                    } else if (requestedFileName.endsWith(".wasm")) {
                        httpExchange.getResponseHeaders().add("Content-Type", "application/wasm");
                    } else {
                        httpExchange.getResponseHeaders().add("Content-Type", "application/octet-stream");
                    }
                    httpExchange.sendResponseHeaders(200, requestedFile.length());
                    FileUtils.copyFile((File)requestedFile, (OutputStream)httpExchange.getResponseBody());
                } else {
                    httpExchange.sendResponseHeaders(404, 0L);
                }
                httpExchange.close();
            });
            TESTSERVER.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> TESTSERVER.stop(0)));
        }
    }

    private static void initializeWebRoot(File aFile) {
        HTTPFILESDIR.set(aFile);
    }

    private static URL getTestFileUrl(File aFile) throws MalformedURLException {
        String theFileName = aFile.getName();
        InetSocketAddress theServerAddress = TESTSERVER.getAddress();
        return new URL(String.format("http://%s:%d/%s", "host.testcontainers.internal", theServerAddress.getPort(), theFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testJSBackendFrameworkMethod(FrameworkMethod aFrameworkMethod, RunNotifier aRunNotifier, TestOption aTestOption) {
        if ("".equals(System.getProperty("BYTECODER_DISABLE_JSTESTS", ""))) {
            TestClass testClass = this.getTestClass();
            Description theDescription = Description.createTestDescription((Class)testClass.getJavaClass(), (String)(aFrameworkMethod.getName() + " " + aTestOption.toDescription()));
            aRunNotifier.fireTestStarted(theDescription);
            try {
                CompileTarget theCompileTarget = new CompileTarget(testClass.getJavaClass().getClassLoader(), CompileTarget.BackendType.js);
                BytecodeMethodSignature theSignature = theCompileTarget.toMethodSignature(aFrameworkMethod.getMethod());
                BytecodeObjectTypeRef theTestClass = new BytecodeObjectTypeRef(testClass.getName());
                BytecodeMethodSignature theTestClassConstructorSignature = new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0]);
                StringWriter theStrWriter = new StringWriter();
                PrintWriter theCodeWriter = new PrintWriter(theStrWriter);
                CompileOptions theOptions = new CompileOptions(LOGGER, true, KnownOptimizer.ALL, aTestOption.isExceptionsEnabled(), "bytecoder", 512, 512, aTestOption.isMinify(), aTestOption.isPreferStackifier(), Allocator.linear, this.additionalClassesToLink, this.additionalResources, null);
                JSCompileResult result = (JSCompileResult)theCompileTarget.compile(theOptions, testClass.getJavaClass(), aFrameworkMethod.getName(), theSignature);
                CompileResult.StringContent content = (CompileResult.StringContent)result.getContent()[0];
                theCodeWriter.println(content.asString());
                String theFilename = result.getMinifier().toClassName(theTestClass) + "." + result.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".html";
                theCodeWriter.println();
                theCodeWriter.println("console.log(\"Starting test\");");
                theCodeWriter.println("bytecoder.bootstrap();");
                theCodeWriter.println("var theTestInstance = " + result.getMinifier().toClassName(theTestClass) + "." + result.getMinifier().toSymbol("__runtimeclass") + "." + result.getMinifier().toMethodName("$newInstance", theTestClassConstructorSignature) + "();");
                theCodeWriter.println("try {");
                theCodeWriter.println("     theTestInstance." + result.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "();");
                theCodeWriter.println("     console.log(\"Test finished OK\");");
                theCodeWriter.println("} catch (e) {");
                theCodeWriter.println("     if (e.exception) {");
                theCodeWriter.println("         console.log(\"Test finished with exception. Message = \" + bytecoder.toJSString(e.exception.message));");
                theCodeWriter.println("     } else {");
                theCodeWriter.println("         console.log(\"Test finished with exception.\");");
                theCodeWriter.println("     }");
                theCodeWriter.println("     console.log(e.stack);");
                theCodeWriter.println("}");
                theCodeWriter.flush();
                File theWorkingDirectory = new File(".");
                BytecoderUnitTestRunner.initializeTestWebServer();
                BrowserWebDriverContainer theContainer = BytecoderUnitTestRunner.initializeSeleniumContainer();
                File theMavenTargetDir = new File(theWorkingDirectory, "target");
                File theGeneratedFilesDir = new File(theMavenTargetDir, "bytecoderjs");
                theGeneratedFilesDir.mkdirs();
                for (CompileResult.Content c : result.getContent()) {
                    if (!(c instanceof CompileResult.URLContent)) continue;
                    FileOutputStream fos = new FileOutputStream(new File(theGeneratedFilesDir, c.getFileName()));
                    Object object = null;
                    try {
                        c.writeTo(fos);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fos != null) {
                            if (object != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                }
                File theGeneratedFile = new File(theGeneratedFilesDir, theFilename);
                PrintWriter theWriter = new PrintWriter(theGeneratedFile);
                theWriter.println("<html><body><script>");
                theWriter.println(theStrWriter.toString());
                theWriter.println("</script></body></html>");
                theWriter.flush();
                theWriter.close();
                BytecoderUnitTestRunner.initializeWebRoot(theGeneratedFile.getParentFile());
                URL theTestURL = BytecoderUnitTestRunner.getTestFileUrl(theGeneratedFile);
                RemoteWebDriver theDriver = theContainer.getWebDriver();
                theDriver.get(theTestURL.toString());
                List theAll = theDriver.manage().logs().get("browser").getAll();
                if (1 > theAll.size()) {
                    aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)new RuntimeException("No console output from browser")));
                }
                for (LogEntry theEntry : theAll) {
                    LOGGER.info(theEntry.getMessage(), new Object[0]);
                }
                LogEntry theLast = (LogEntry)theAll.get(theAll.size() - 1);
                if (!theLast.getMessage().contains("Test finished OK")) {
                    aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)new RuntimeException("Test did not succeed! Got : " + theLast.getMessage())));
                }
            }
            catch (Exception e) {
                aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)e));
            }
            finally {
                aRunNotifier.fireTestFinished(theDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWASMASTBackendFrameworkMethod(FrameworkMethod aFrameworkMethod, RunNotifier aRunNotifier, TestOption aTestOption) {
        if (!"".equals(System.getProperty("BYTECODER_DISABLE_WASMTESTS_STACKIFY", "")) && aTestOption.isPreferStackifier()) {
            return;
        }
        if (!"".equals(System.getProperty("BYTECODER_DISABLE_WASMTESTS_RELOOP", "")) && !aTestOption.isPreferStackifier()) {
            return;
        }
        if ("".equals(System.getProperty("BYTECODER_DISABLE_WASMTESTS", ""))) {
            TestClass testClass = this.getTestClass();
            Description theDescription = Description.createTestDescription((Class)testClass.getJavaClass(), (String)(aFrameworkMethod.getName() + " " + aTestOption.toDescription()));
            aRunNotifier.fireTestStarted(theDescription);
            try {
                CompileTarget theCompileTarget = new CompileTarget(testClass.getJavaClass().getClassLoader(), CompileTarget.BackendType.wasm);
                BytecodeMethodSignature theSignature = theCompileTarget.toMethodSignature(aFrameworkMethod.getMethod());
                BytecodeObjectTypeRef theTestClassType = new BytecodeObjectTypeRef(testClass.getName());
                CompileOptions theOptions = new CompileOptions(LOGGER, true, KnownOptimizer.ALL, false, "bytecoder", 512, 512, aTestOption.isMinify(), aTestOption.isPreferStackifier(), Allocator.linear, this.additionalClassesToLink, this.additionalResources, null);
                WASMCompileResult theResult = (WASMCompileResult)theCompileTarget.compile(theOptions, testClass.getJavaClass(), aFrameworkMethod.getName(), theSignature);
                WASMCompileResult.WASMCompileContent textualContent = (WASMCompileResult.WASMCompileContent)theResult.getContent()[0];
                WASMCompileResult.WASMCompileContent binaryContent = (WASMCompileResult.WASMCompileContent)theResult.getContent()[1];
                WASMCompileResult.WASMCompileContent jsContent = (WASMCompileResult.WASMCompileContent)theResult.getContent()[2];
                WASMCompileResult.WASMCompileContent sourceMapContent = (WASMCompileResult.WASMCompileContent)theResult.getContent()[3];
                String theFileName = theResult.getMinifier().toClassName(theTestClassType) + "." + theResult.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".html";
                File theWorkingDirectory = new File(".");
                BytecoderUnitTestRunner.initializeTestWebServer();
                BrowserWebDriverContainer theContainer = BytecoderUnitTestRunner.initializeSeleniumContainer();
                File theMavenTargetDir = new File(theWorkingDirectory, "target");
                File theGeneratedFilesDir = new File(theMavenTargetDir, "bytecoderwasm");
                theGeneratedFilesDir.mkdirs();
                File theGeneratedFile = new File(theGeneratedFilesDir, theFileName);
                PrintWriter theWriter = new PrintWriter(theGeneratedFile);
                theWriter.println("<html>");
                theWriter.println("    <body>");
                theWriter.println("        <h1>Module code</h1>");
                theWriter.println("        <h1>Compilation result</h1>");
                theWriter.println("        <pre id=\"compileresult\">");
                theWriter.println("        </pre>");
                theWriter.println("        <script>");
                theWriter.println(jsContent.asString());
                theWriter.println("            function compile() {");
                theWriter.println("                console.log('Test started');");
                theWriter.println("                try {");
                theWriter.println();
                theWriter.print("                    var binaryBuffer = new Uint8Array([");
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    binaryContent.writeTo(bos);
                    bos.flush();
                    byte[] theData = bos.toByteArray();
                    for (int i = 0; i < theData.length; ++i) {
                        if (i > 0) {
                            theWriter.print(",");
                        }
                        theWriter.print(theData[i] & 0xFF);
                    }
                }
                theWriter.println("]);");
                theWriter.println("                    console.log('Size of compiled WASM binary is ' + binaryBuffer.length);");
                theWriter.println();
                theWriter.println("                    var theInstantiatePromise = WebAssembly.instantiate(binaryBuffer, bytecoder.imports);");
                theWriter.println("                    theInstantiatePromise.then(");
                theWriter.println("                         function (resolved) {");
                theWriter.println("                             var wasmModule = resolved.module;");
                theWriter.println("                             bytecoder.init(resolved.instance);");
                theWriter.println("                             bytecoder.exports.initMemory(0);");
                theWriter.println("                             console.log(\"Memory initialized\")");
                theWriter.println("                             console.log(\"Used memory in bytes \" + bytecoder.exports.usedMem());");
                theWriter.println("                             console.log(\"Free memory in bytes \" + bytecoder.exports.freeMem());");
                theWriter.println("                             bytecoder.exports.bootstrap(0);");
                theWriter.println("                             bytecoder.initializeFileIO();");
                theWriter.println("                             console.log(\"Used memory after bootstrap in bytes \" + bytecoder.exports.usedMem());");
                theWriter.println("                             console.log(\"Free memory after bootstrap in bytes \" + bytecoder.exports.freeMem());");
                theWriter.println("                             console.log(\"Creating test instance\")");
                theWriter.print("                             var theTest = bytecoder.exports.");
                theWriter.print(WASMWriterUtils.toMethodName(theTestClassType, "$newInstance", new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[0])));
                theWriter.println("(0);");
                theWriter.println("                             console.log(\"Bootstrapped\")");
                theWriter.println("                             try {");
                theWriter.println("                                 console.log(\"Starting main method\")");
                theWriter.println("                                 bytecoder.exports.main(theTest);");
                theWriter.println("                                 console.log(\"Main finished\")");
                theWriter.println("                                 console.log(\"Test finished OK\")");
                theWriter.println("                             } catch (e) {");
                theWriter.println("                                 console.log(\"Test threw error\")");
                theWriter.println("                                 throw e;");
                theWriter.println("                             }");
                theWriter.println("                         },");
                theWriter.println("                         function (rejected) {");
                theWriter.println("                             console.log(\"Error instantiating webassembly\");");
                theWriter.println("                             console.log(rejected);");
                theWriter.println("                         }");
                theWriter.println("                    );");
                theWriter.println("                } catch (e) {");
                theWriter.println("                    document.getElementById(\"compileresult\").innerText = e.toString();");
                theWriter.println("                    console.log(e.toString());");
                theWriter.println("                    console.log(e.stack);");
                theWriter.println("                    if (bytecoder.runningInstance) {");
                theWriter.println("                    }");
                theWriter.println("                }");
                theWriter.println("            }");
                theWriter.println();
                theWriter.println("            compile();");
                theWriter.println("        </script>");
                theWriter.println("    </body>");
                theWriter.println("</html>");
                theWriter.flush();
                theWriter.close();
                var23_24 = null;
                try (CompileResult.Content[] fos = new FileOutputStream(new File(theGeneratedFilesDir, theResult.getMinifier().toClassName(theTestClassType) + "." + theResult.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".wat"));){
                    textualContent.writeTo((OutputStream)fos);
                }
                catch (Throwable theData) {
                    var23_24 = theData;
                    throw theData;
                }
                fos = new FileOutputStream(new File(theGeneratedFilesDir, theResult.getMinifier().toClassName(theTestClassType) + "." + theResult.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".js"));
                var23_24 = null;
                try {
                    jsContent.writeTo((OutputStream)fos);
                }
                catch (Throwable theData) {
                    var23_24 = theData;
                    throw theData;
                }
                finally {
                    if (fos != null) {
                        if (var23_24 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable theData) {
                                var23_24.addSuppressed(theData);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
                fos = new FileOutputStream(new File(theGeneratedFilesDir, theResult.getMinifier().toClassName(theTestClassType) + "." + theResult.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".wasm"));
                var23_24 = null;
                try {
                    binaryContent.writeTo((OutputStream)fos);
                }
                catch (Throwable theData) {
                    var23_24 = theData;
                    throw theData;
                }
                finally {
                    if (fos != null) {
                        if (var23_24 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable theData) {
                                var23_24.addSuppressed(theData);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
                fos = new FileOutputStream(new File(theGeneratedFilesDir, theResult.getMinifier().toClassName(theTestClassType) + "." + theResult.getMinifier().toMethodName(aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".wasm.map"));
                var23_24 = null;
                try {
                    sourceMapContent.writeTo((OutputStream)fos);
                }
                catch (Throwable theData) {
                    var23_24 = theData;
                    throw theData;
                }
                finally {
                    if (fos != null) {
                        if (var23_24 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable theData) {
                                var23_24.addSuppressed(theData);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
                for (CompileResult.Content c : theResult.getContent()) {
                    if (!(c instanceof CompileResult.URLContent)) continue;
                    try (FileOutputStream fos = new FileOutputStream(new File(theGeneratedFilesDir, c.getFileName()));){
                        c.writeTo(fos);
                    }
                }
                BytecoderUnitTestRunner.initializeWebRoot(theGeneratedFile.getParentFile());
                RemoteWebDriver theDriver = theContainer.getWebDriver();
                URL theTestURL = BytecoderUnitTestRunner.getTestFileUrl(theGeneratedFile);
                theDriver.get(theTestURL.toString());
                long theStart = System.currentTimeMillis();
                boolean theTestSuccedded = false;
                while (!theTestSuccedded && 10000L > System.currentTimeMillis() - theStart) {
                    List theAll = theDriver.manage().logs().get("browser").getAll();
                    for (LogEntry theEntry : theAll) {
                        String theMessage = theEntry.getMessage();
                        System.out.println(theMessage);
                        if (!theMessage.contains("Test finished OK")) continue;
                        theTestSuccedded = true;
                    }
                    if (theTestSuccedded) continue;
                    Thread.sleep(100L);
                }
                if (!theTestSuccedded) {
                    aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)new RuntimeException("Test did not succeed!")));
                }
            }
            catch (Exception e) {
                aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)e));
            }
            finally {
                aRunNotifier.fireTestFinished(theDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLLVMWASMASTBackendFrameworkMethod(FrameworkMethod aFrameworkMethod, RunNotifier aRunNotifier, TestOption aTestOption) {
        if ("".equals(System.getProperty("BYTECODER_DISABLE_LLVMWASMTESTS", ""))) {
            TestClass testClass = this.getTestClass();
            Description theDescription = Description.createTestDescription((Class)testClass.getJavaClass(), (String)(aFrameworkMethod.getName() + " " + aTestOption.toDescription()));
            aRunNotifier.fireTestStarted(theDescription);
            try {
                CompileTarget theCompileTarget = new CompileTarget(testClass.getJavaClass().getClassLoader(), CompileTarget.BackendType.wasm_llvm);
                BytecodeMethodSignature theSignature = theCompileTarget.toMethodSignature(aFrameworkMethod.getMethod());
                BytecodeObjectTypeRef theTypeRef = new BytecodeObjectTypeRef(testClass.getName());
                CompileOptions theOptions = new CompileOptions(LOGGER, true, KnownOptimizer.ALL, false, "bytecoder", 512, 512, aTestOption.isMinify(), aTestOption.isPreferStackifier(), Allocator.linear, this.additionalClassesToLink, this.additionalResources, LLVMOptimizationLevel.defaultValue());
                LLVMCompileResult theResult = (LLVMCompileResult)theCompileTarget.compile(theOptions, testClass.getJavaClass(), aFrameworkMethod.getName(), theSignature);
                CompileResult.StringContent textualContent = (CompileResult.StringContent)theResult.getContent()[0];
                CompileResult.StringContent jsContent = (CompileResult.StringContent)theResult.getContent()[1];
                CompileResult.BinaryContent binaryContent = (CompileResult.BinaryContent)theResult.getContent()[3];
                String theFileName = LLVMWriterUtils.toMethodName(theTypeRef, aFrameworkMethod.getName(), theSignature) + "_" + aTestOption.toFilePrefix() + ".html";
                File theWorkingDirectory = new File(".");
                BytecoderUnitTestRunner.initializeTestWebServer();
                BrowserWebDriverContainer theContainer = BytecoderUnitTestRunner.initializeSeleniumContainer();
                File theMavenTargetDir = new File(theWorkingDirectory, "target");
                File theGeneratedFilesDir = new File(theMavenTargetDir, "bytecoderllvmwasm");
                theGeneratedFilesDir.mkdirs();
                File theGeneratedFile = new File(theGeneratedFilesDir, theFileName);
                PrintWriter theWriter = new PrintWriter(theGeneratedFile);
                theWriter.println("<html>");
                theWriter.println("    <body>");
                theWriter.println("        <h1>Module code</h1>");
                theWriter.println("        <h1>Compilation result</h1>");
                theWriter.println("        <pre id=\"compileresult\">");
                theWriter.println("        </pre>");
                theWriter.println("        <script>");
                theWriter.println(jsContent.asString());
                theWriter.println("            function compile() {");
                theWriter.println("                console.log('Test started');");
                theWriter.println("                try {");
                theWriter.println();
                theWriter.print("                    var binaryBuffer = new Uint8Array([");
                try (CompileResult.Content[] bos = new ByteArrayOutputStream();){
                    binaryContent.writeTo((OutputStream)bos);
                    bos.flush();
                    byte[] theData = bos.toByteArray();
                    for (int i = 0; i < theData.length; ++i) {
                        if (i > 0) {
                            theWriter.print(",");
                        }
                        theWriter.print(theData[i] & 0xFF);
                    }
                }
                theWriter.println("]);");
                theWriter.println("                    console.log('Size of compiled WASM binary is ' + binaryBuffer.length);");
                theWriter.println();
                theWriter.println("                    var theInstantiatePromise = WebAssembly.instantiate(binaryBuffer, bytecoder.imports);");
                theWriter.println("                    theInstantiatePromise.then(");
                theWriter.println("                         function (resolved) {");
                theWriter.println("                             var wasmModule = resolved.module;");
                theWriter.println("                             bytecoder.init(resolved.instance);");
                theWriter.println("                             bytecoder.exports.initMemory(0);");
                theWriter.println("                             console.log(\"Memory initialized\")");
                theWriter.println("                             console.log(\"Used memory in bytes \" + bytecoder.exports.usedMem());");
                theWriter.println("                             console.log(\"Free memory in bytes \" + bytecoder.exports.freeMem());");
                theWriter.println("                             bytecoder.exports.bootstrap(0);");
                theWriter.println("                             bytecoder.initializeFileIO();");
                theWriter.println("                             console.log(\"Used memory after bootstrap in bytes \" + bytecoder.exports.usedMem());");
                theWriter.println("                             console.log(\"Free memory after bootstrap in bytes \" + bytecoder.exports.freeMem());");
                theWriter.println("                             console.log(\"Creating test instance\")");
                theWriter.print("                             var theClass = bytecoder.exports.");
                theWriter.print(LLVMWriterUtils.toClassName(theTypeRef));
                theWriter.println("__init();");
                theWriter.print("                             var theTest = bytecoder.exports.");
                theWriter.print(LLVMWriterUtils.toClassName(theTypeRef));
                theWriter.println("_VOID$newInstance(theClass);");
                theWriter.println("                             console.log(\"Bootstrapped\")");
                theWriter.println("                             try {");
                theWriter.println("                                 console.log(\"Starting main method\");");
                theWriter.println("                                 bytecoder.exports.main(theTest);");
                theWriter.println("                                 console.log(\"Main finished\");");
                theWriter.println("                                 console.log(\"Test finished OK\");");
                theWriter.println("                             } catch (e) {");
                theWriter.println("                                 console.log(\"Test threw error\");");
                theWriter.println("                                 throw e;");
                theWriter.println("                             }");
                theWriter.println("                         },");
                theWriter.println("                         function (rejected) {");
                theWriter.println("                             console.log(\"Error instantiating webassembly\");");
                theWriter.println("                             console.log(rejected);");
                theWriter.println("                         }");
                theWriter.println("                    );");
                theWriter.println("                } catch (e) {");
                theWriter.println("                    document.getElementById(\"compileresult\").innerText = e.toString();");
                theWriter.println("                    console.log(e.toString());");
                theWriter.println("                    console.log(e.stack);");
                theWriter.println("                    if (bytecoder.runningInstance) {");
                theWriter.println("                    }");
                theWriter.println("                }");
                theWriter.println("            }");
                theWriter.println();
                theWriter.println("            compile();");
                theWriter.println("        </script>");
                theWriter.println("    </body>");
                theWriter.println("</html>");
                theWriter.flush();
                theWriter.close();
                for (CompileResult.Content theContent : theResult.getContent()) {
                    if (theContent instanceof CompileResult.URLContent) {
                        try (FileOutputStream fos = new FileOutputStream(new File(theGeneratedFilesDir, theContent.getFileName()));){
                            theContent.writeTo(fos);
                            continue;
                        }
                    }
                    File targetFile = new File(theGeneratedFilesDir, LLVMWriterUtils.toMethodName(theTypeRef, aFrameworkMethod.getName(), theSignature) + "_" + theContent.getFileName());
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    Object object = null;
                    try {
                        theContent.writeTo(fos);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fos != null) {
                            if (object != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                }
                BytecoderUnitTestRunner.initializeWebRoot(theGeneratedFile.getParentFile());
                RemoteWebDriver theDriver = theContainer.getWebDriver();
                URL theTestURL = BytecoderUnitTestRunner.getTestFileUrl(theGeneratedFile);
                long theStart = System.currentTimeMillis();
                boolean theTestSuccedded = false;
                theDriver.get(theTestURL.toString());
                while (!theTestSuccedded && 10000L > System.currentTimeMillis() - theStart) {
                    List theAll = theDriver.manage().logs().get("browser").getAll();
                    for (LogEntry theEntry : theAll) {
                        String theMessage = theEntry.getMessage();
                        System.out.println(theMessage);
                        if (!theMessage.contains("Test finished OK")) continue;
                        theTestSuccedded = true;
                    }
                    if (theTestSuccedded) continue;
                    Thread.sleep(100L);
                }
                if (!theTestSuccedded) {
                    aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)new RuntimeException("Test did not succeed!")));
                }
            }
            catch (Exception e) {
                aRunNotifier.fireTestFailure(new Failure(theDescription, (Throwable)e));
            }
            finally {
                aRunNotifier.fireTestFinished(theDescription);
            }
        }
    }

    protected void runChild(FrameworkMethodWithTestOption aFrameworkMethod, RunNotifier aRunNotifier) {
        if (aFrameworkMethod.getMethod().isAnnotationPresent(Ignore.class)) {
            aRunNotifier.fireTestIgnored(Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)aFrameworkMethod.getName()));
            return;
        }
        TestOption o = aFrameworkMethod.getTestOption();
        if (o.getBackendType() == null) {
            this.testJVMBackendFrameworkMethod(aFrameworkMethod, aRunNotifier);
        } else {
            switch (o.getBackendType()) {
                case js: {
                    this.testJSBackendFrameworkMethod(aFrameworkMethod, aRunNotifier, o);
                    break;
                }
                case wasm: {
                    this.testWASMASTBackendFrameworkMethod(aFrameworkMethod, aRunNotifier, o);
                    break;
                }
                case wasm_llvm: {
                    this.testLLVMWASMASTBackendFrameworkMethod(aFrameworkMethod, aRunNotifier, o);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported backend :" + (Object)((Object)o.getBackendType()));
                }
            }
        }
    }

    static {
        HTTPFILESDIR = new AtomicReference();
    }
}

