/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.stackifier;

import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.stackifier.HeadToHeadControlFlowException;
import de.mirkosertic.bytecoder.stackifier.JumpArrow;
import de.mirkosertic.bytecoder.stackifier.StructuredControlFlow;
import java.util.ArrayList;
import java.util.List;

public class StructuredControlFlowBuilder<T> {
    private final List<JumpArrow<T>> knownJumpArrows;
    private final List<T> nodesInOrder;

    public StructuredControlFlowBuilder(List<T> nodesInOrder) {
        this.nodesInOrder = nodesInOrder;
        this.knownJumpArrows = new ArrayList<JumpArrow<T>>();
    }

    public void add(ControlFlowEdgeType edgeType, T source, T destination) {
        this.knownJumpArrows.add(new JumpArrow<T>(edgeType, source, destination));
    }

    public StructuredControlFlow<T> build() throws HeadToHeadControlFlowException {
        StructuredControlFlow<T> stack = new StructuredControlFlow<T>(this.knownJumpArrows, this.nodesInOrder);
        stack.stackify();
        return stack;
    }
}

