/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.stackifier;

import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.Label;
import de.mirkosertic.bytecoder.stackifier.Block;
import de.mirkosertic.bytecoder.stackifier.HeadToHeadControlFlowException;
import de.mirkosertic.bytecoder.stackifier.JumpArrow;
import de.mirkosertic.bytecoder.stackifier.StructuredControlFlowWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class StructuredControlFlow<T> {
    private final List<JumpArrow<T>> knownJumpArrows;
    private final List<T> nodesInOrder;

    StructuredControlFlow(List<JumpArrow<T>> knownJumpArrows, List<T> nodesInOrder) {
        this.knownJumpArrows = knownJumpArrows;
        this.nodesInOrder = nodesInOrder;
    }

    public int indexOf(T aValue) {
        return this.nodesInOrder.indexOf(aValue);
    }

    public int indexOf(JumpArrow<T> arrow) {
        return this.knownJumpArrows.indexOf(arrow);
    }

    private List<JumpArrow<T>> forwardArrowsWithHead(T head) {
        ArrayList<JumpArrow<T>> forwardArrows = new ArrayList<JumpArrow<T>>();
        for (JumpArrow<T> f : this.knownJumpArrows) {
            if (f.getEdgeType() != ControlFlowEdgeType.forward || f.getHead() != head) continue;
            forwardArrows.add(f);
        }
        forwardArrows.sort((o1, o2) -> Integer.compare(this.indexOf(o2.getTail()), this.indexOf(o1.getTail())));
        return forwardArrows;
    }

    private List<JumpArrow<T>> jumpArrowsSortedByTail() {
        ArrayList<JumpArrow<T>> forwardArrows = new ArrayList<JumpArrow<T>>(this.knownJumpArrows);
        forwardArrows.sort(Comparator.comparingInt(value -> this.indexOf(value.getTail())));
        return forwardArrows;
    }

    private List<JumpArrow<T>> backwardArrowsWithHead(T head) {
        ArrayList<JumpArrow<T>> backwardArrows = new ArrayList<JumpArrow<T>>();
        for (JumpArrow<T> f : this.knownJumpArrows) {
            if (f.getEdgeType() != ControlFlowEdgeType.back || this.indexOf(f.getHead()) != this.indexOf(head)) continue;
            backwardArrows.add(f);
        }
        return backwardArrows;
    }

    void stackify() throws HeadToHeadControlFlowException {
        Stack<T> s = new Stack<T>();
        for (T v : this.nodesInOrder) {
            for (JumpArrow jumpArrow : this.forwardArrowsWithHead(v)) {
                if (s.isEmpty()) continue;
                while (this.indexOf(jumpArrow.getTail()) < this.indexOf(s.peek())) {
                    Object w = s.pop();
                    for (JumpArrow backward : this.backwardArrowsWithHead(w)) {
                        if (this.indexOf(backward.getTail()) > this.indexOf(v)) {
                            throw new HeadToHeadControlFlowException(String.format("{%d,%d} are head to head, arrow %d ", this.indexOf(v), this.indexOf(backward.getTail()), this.knownJumpArrows.indexOf(backward)));
                        }
                        backward.setNewTail(this.nodesInOrder.get(this.indexOf(v) - 1));
                    }
                }
                jumpArrow.setNewTail(s.peek());
            }
            s.push(v);
        }
        while (!s.isEmpty()) {
            Object w = s.pop();
            for (JumpArrow backward : this.backwardArrowsWithHead(w)) {
                backward.setNewTail(this.nodesInOrder.get(this.nodesInOrder.size() - 1));
            }
        }
    }

    public void printDebug(PrintWriter pw) {
        pw.println("Original:");
        this.printDebug(pw, false);
        for (JumpArrow<T> arrow : this.knownJumpArrows) {
            pw.println(String.format(" %s %d -> %d", arrow.getEdgeType(), this.indexOf(arrow.getTail()), this.indexOf(arrow.getHead())));
        }
        pw.println();
        pw.println("Stackified:");
        this.printDebug(pw, true);
        for (JumpArrow<T> arrow : this.knownJumpArrows) {
            pw.println(String.format(" %s %d -> %d", arrow.getEdgeType(), this.indexOf(arrow.getNewTail()), this.indexOf(arrow.getHead())));
        }
        pw.println();
        pw.println("Data:");
        for (int i = 0; i < this.nodesInOrder.size(); ++i) {
            pw.println(String.format(" %d %s", i, this.nodesInOrder.get(i)));
        }
        pw.flush();
    }

    private void printDebug(PrintWriter pw, boolean newTail) {
        pw.print("        ");
        for (T t : this.nodesInOrder) {
            pw.print(String.format("%3d", this.indexOf(t)));
            pw.print(" ");
        }
        pw.println();
        for (JumpArrow jumpArrow : this.jumpArrowsSortedByTail()) {
            int i;
            pw.print(String.format("%3d-%3d ", this.indexOf(jumpArrow.getTail()), this.indexOf(jumpArrow.getHead())));
            Object tail = newTail ? jumpArrow.getNewTail() : jumpArrow.getTail();
            Object head = jumpArrow.getHead();
            if (jumpArrow.getEdgeType() == ControlFlowEdgeType.forward) {
                for (i = 0; i < this.indexOf(tail); ++i) {
                    pw.print("    ");
                }
                pw.print("  ");
                for (i = this.indexOf(tail); i < this.indexOf(head); ++i) {
                    pw.print("----");
                }
                pw.print(">");
            } else {
                for (i = 0; i < this.indexOf(head); ++i) {
                    pw.print("    ");
                }
                pw.print("  <-");
                for (i = this.indexOf(tail); i < this.indexOf(head) - 1; ++i) {
                    pw.print("----");
                }
                pw.print("---");
            }
            pw.println();
        }
    }

    private Label toLabel(JumpArrow<T> arrow) {
        switch (arrow.getEdgeType()) {
            case forward: {
                return new Label(String.format("B_%d_%d", this.indexOf(arrow.getNewTail()), this.indexOf(arrow.getHead())));
            }
            case back: {
                return new Label(String.format("L_%d_%d", this.indexOf(arrow.getHead()), this.indexOf(arrow.getNewTail())));
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean contains(JumpArrow<T> loop, JumpArrow<T> block) {
        int loopHeadIdx = this.indexOf(loop.getHead());
        int loopTailIdx = this.indexOf(loop.getNewTail());
        int blockHeadIdx = this.indexOf(block.getHead());
        int blockTailIdx = this.indexOf(block.getNewTail());
        return blockTailIdx >= loopHeadIdx && blockTailIdx <= loopTailIdx && blockHeadIdx >= loopHeadIdx && blockHeadIdx <= loopTailIdx;
    }

    public void writeStructuredControlFlow(StructuredControlFlowWriter<T> writer) {
        writer.begin();
        this.writeStructuredControlFlow(writer, this.nodesInOrder);
        writer.end();
    }

    private boolean endsBefore(Block<T> block, T node) {
        switch (block.getArrow().getEdgeType()) {
            case forward: {
                return this.indexOf(block.getEnding()) <= this.indexOf(node);
            }
            case back: {
                return this.indexOf(block.getEnding()) < this.indexOf(node);
            }
        }
        throw new IllegalArgumentException();
    }

    public void writeStructuredControlFlow(StructuredControlFlowWriter<T> writer, List<T> nodes) {
        List filteredJumpArrows = this.knownJumpArrows.stream().filter(arrow -> {
            switch (arrow.getEdgeType()) {
                case back: {
                    return true;
                }
                case forward: {
                    if (this.indexOf(arrow.getTail()) + 1 == this.indexOf(arrow.getHead())) {
                        if (this.knownJumpArrows.stream().filter(t -> t.getTail() == arrow.getTail()).count() == 1L) {
                            return false;
                        }
                        return this.knownJumpArrows.stream().filter(t -> t.getEdgeType() == ControlFlowEdgeType.back && t.getNewTail() == arrow.getNewTail()).count() != 1L;
                    }
                    for (JumpArrow<T> a : this.knownJumpArrows) {
                        if (a.getEdgeType() != ControlFlowEdgeType.back || this.indexOf(arrow.getNewTail()) < this.indexOf(a.getHead()) || this.indexOf(arrow.getNewTail()) > this.indexOf(a.getNewTail()) || this.indexOf(arrow.getHead()) != this.indexOf(a.getNewTail()) + 1 || this.contains(a, (JumpArrow<T>)arrow)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new IllegalStateException();
        }).collect(Collectors.toList());
        Stack<Block> blockStack = new Stack<Block>();
        for (Object node : nodes) {
            Set uniqueBlocksStartingFromHere = filteredJumpArrows.stream().filter(t -> t.getEdgeType() == ControlFlowEdgeType.forward && t.getNewTail() == node).map(t -> new Block(this.toLabel((JumpArrow<T>)t), t)).collect(Collectors.toSet());
            List backEdgesToHere = filteredJumpArrows.stream().filter(t -> t.getEdgeType() == ControlFlowEdgeType.back && t.getHead() == node).collect(Collectors.toList());
            for (JumpArrow back : backEdgesToHere) {
                uniqueBlocksStartingFromHere.add(new Block(this.toLabel(back), back));
            }
            ArrayList blocksStartingFromHere = new ArrayList(uniqueBlocksStartingFromHere);
            blocksStartingFromHere.sort((o1, o2) -> {
                int a = o1.getArrow().getEdgeType() == ControlFlowEdgeType.forward ? this.indexOf(o1.getEnding()) : this.indexOf(o1.getEnding()) + 1;
                int b = o2.getArrow().getEdgeType() == ControlFlowEdgeType.forward ? this.indexOf(o2.getEnding()) : this.indexOf(o2.getEnding()) + 1;
                return Integer.compare(b, a);
            });
            while (!blockStack.isEmpty() && this.endsBefore((Block)blockStack.peek(), node)) {
                writer.closeBlock();
                blockStack.pop();
            }
            if (!blockStack.isEmpty() && this.indexOf(((Block)blockStack.peek()).getEnding()) == this.indexOf(node) && ((Block)blockStack.peek()).getArrow().getEdgeType() == ControlFlowEdgeType.back) {
                for (Block block : blocksStartingFromHere) {
                    block0 : switch (block.arrow.getEdgeType()) {
                        case forward: {
                            for (Block onStack : blockStack) {
                                if (onStack.getArrow().getEdgeType() != ControlFlowEdgeType.forward || onStack.getEnding() != block.getEnding()) continue;
                                break block0;
                            }
                            this.printDebug(new PrintWriter(System.out));
                            throw new IllegalStateException(String.format("Don't know what to do for node %s. Closing loop with starting blocks at the same place!", node));
                        }
                        case back: {
                            writer.beginLoopFor(block);
                            blockStack.push(block);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                writer.write(node);
                while (!blockStack.isEmpty() && this.indexOf(((Block)blockStack.peek()).getEnding()) == this.indexOf(node) && ((Block)blockStack.peek()).getArrow().getEdgeType() == ControlFlowEdgeType.back) {
                    writer.closeBlock();
                    blockStack.pop();
                }
                continue;
            }
            for (Block block : blocksStartingFromHere) {
                switch (block.arrow.getEdgeType()) {
                    case forward: {
                        writer.beginBlockFor(block);
                        break;
                    }
                    case back: {
                        writer.beginLoopFor(block);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                blockStack.push(block);
            }
            writer.write(node);
        }
        while (!blockStack.isEmpty()) {
            writer.closeBlock();
            blockStack.pop();
        }
    }
}

