/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.stackifier;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.GraphDFSOrder;
import de.mirkosertic.bytecoder.ssa.BreakExpression;
import de.mirkosertic.bytecoder.ssa.ContinueExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.IFElseExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.stackifier.Block;
import de.mirkosertic.bytecoder.stackifier.HeadToHeadControlFlowException;
import de.mirkosertic.bytecoder.stackifier.StructuredControlFlow;
import de.mirkosertic.bytecoder.stackifier.StructuredControlFlowBuilder;
import de.mirkosertic.bytecoder.stackifier.StructuredControlFlowWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class Stackifier {
    private final StructuredControlFlow<RegionNode> flow;
    private final ControlFlowGraph controlFlowGraph;

    public Stackifier(ControlFlowGraph controlFlowGraph) throws HeadToHeadControlFlowException {
        this.controlFlowGraph = controlFlowGraph;
        GraphDFSOrder<RegionNode> order = new GraphDFSOrder<RegionNode>(controlFlowGraph.startNode(), RegionNode.NODE_COMPARATOR, RegionNode.FORWARD_EDGE_FILTER_REGULAR_FLOW_ONLY);
        List<RegionNode> sorted = order.getNodesInOrder();
        StructuredControlFlowBuilder<RegionNode> builder = new StructuredControlFlowBuilder<RegionNode>(sorted);
        for (RegionNode node : sorted) {
            block5: for (Edge succ : node.outgoingEdges().collect(Collectors.toList())) {
                switch ((ControlFlowEdgeType)succ.edgeType()) {
                    case forward: {
                        if (!sorted.contains(succ.targetNode())) continue block5;
                        builder.add(ControlFlowEdgeType.forward, node, (RegionNode)succ.targetNode());
                        continue block5;
                    }
                    case back: {
                        if (!sorted.contains(succ.targetNode())) continue block5;
                        builder.add(ControlFlowEdgeType.back, node, (RegionNode)succ.targetNode());
                        continue block5;
                    }
                }
                throw new IllegalStateException();
            }
        }
        this.flow = builder.build();
    }

    public void writeStructuredControlFlow(StackifierStructuredControlFlowWriter writer) {
        this.flow.writeStructuredControlFlow(writer);
    }

    public void printDebug(PrintWriter printWriter) {
        this.flow.printDebug(printWriter);
    }

    public static abstract class StackifierStructuredControlFlowWriter
    extends StructuredControlFlowWriter<RegionNode> {
        private final Stackifier stackifier;
        private final Stack<RegionNode> nodes;

        public StackifierStructuredControlFlowWriter(Stackifier stackifier) {
            this.stackifier = stackifier;
            this.nodes = new Stack();
        }

        private Expression potentiallyReplaceGoto(Expression aExpression) {
            RegionNode currentNode = this.nodes.peek();
            if (aExpression instanceof GotoExpression) {
                GotoExpression theGoto = (GotoExpression)aExpression;
                BytecodeOpcodeAddress theTarget = theGoto.jumpTarget();
                RegionNode theTargetNode = this.stackifier.controlFlowGraph.nodeStartingAt(theTarget);
                if (this.stackifier.flow.indexOf(theTargetNode) == this.stackifier.flow.indexOf(currentNode) + 1 && this.stackifier.controlFlowGraph.dominatesInRegularFlowOnly(currentNode, theTargetNode) && currentNode.outgoingEdges().filter(t -> ((RegionNode)t.targetNode()).getType() == RegionNode.BlockType.NORMAL).count() == 1L) {
                    return null;
                }
                int numLoops = 0;
                block4: for (int i = this.hierarchy.size() - 1; i >= 0; --i) {
                    Block block = (Block)this.hierarchy.get(i);
                    switch (block.getArrow().getEdgeType()) {
                        case back: {
                            ++numLoops;
                            if (theTargetNode == block.getArrow().getHead()) {
                                ContinueExpression theContinue = new ContinueExpression(theGoto.getProgram(), theGoto.getAddress(), block.getLabel(), theTarget);
                                if (numLoops == 1) {
                                    theContinue.noJumpLabelRequired();
                                }
                                return theContinue;
                            }
                            if (theTargetNode != block.getArrow().getNewTail()) continue block4;
                            BreakExpression theBreak = new BreakExpression(theGoto.getProgram(), theGoto.getAddress(), block.getLabel(), theTarget);
                            if (numLoops == 1) {
                                theBreak.noJumpLabelRequired();
                            }
                            return theBreak;
                        }
                        case forward: {
                            if (theTargetNode != block.getArrow().getHead()) continue block4;
                            BreakExpression theBreak = new BreakExpression(theGoto.getProgram(), theGoto.getAddress(), block.getLabel(), theTarget);
                            return theBreak;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                throw new IllegalStateException(String.format("Don't know how to handle Goto %s from %d to %d in %s", theTarget, this.stackifier.flow.indexOf(currentNode), this.stackifier.flow.indexOf(theTargetNode), currentNode.getStartAddress()));
            }
            return aExpression;
        }

        private void replaceGotosAndEnhanceIFExpressions(ExpressionList aList) {
            List<Expression> el = aList.toList();
            for (int i = 0; i < el.size(); ++i) {
                Expression original = el.get(i);
                Expression converted = this.potentiallyReplaceGoto(original);
                if (converted instanceof ExpressionListContainer) {
                    ExpressionListContainer c = (ExpressionListContainer)((Object)converted);
                    for (ExpressionList l : c.getExpressionLists()) {
                        this.replaceGotosAndEnhanceIFExpressions(l);
                    }
                }
                if (converted != null) {
                    if (converted instanceof IFExpression) {
                        IFExpression ie = (IFExpression)converted;
                        ExpressionList elsePart = new ExpressionList();
                        for (int k = i + 1; k < el.size(); ++k) {
                            Expression elsePartElement = el.get(k);
                            elsePart.add(elsePartElement);
                            aList.remove(elsePartElement);
                        }
                        this.replaceGotosAndEnhanceIFExpressions(elsePart);
                        aList.replace(original, new IFElseExpression(ie.getProgram(), ie.getAddress(), ie, elsePart));
                        return;
                    }
                    if (original == converted) continue;
                    aList.replace(original, converted);
                    continue;
                }
                aList.remove(original);
            }
        }

        public final void writeExpressionList(RegionNode currentNode, ExpressionList aList) {
            this.replaceGotosAndEnhanceIFExpressions(aList);
            for (Expression e : aList.toList()) {
                this.writeExpression(currentNode, e);
            }
        }

        public abstract void writeExpression(RegionNode var1, Expression var2);

        @Override
        public void write(RegionNode node) {
            this.nodes.push(node);
            this.writeExpressionList(node, node.getExpressions());
            this.nodes.pop();
        }
    }
}

