/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.stackifier;

import de.mirkosertic.bytecoder.ssa.Label;
import de.mirkosertic.bytecoder.stackifier.JumpArrow;
import java.util.Objects;

public class Block<T> {
    private final Label label;
    final JumpArrow<T> arrow;

    public Block(Label label, JumpArrow<T> arrow) {
        this.label = label;
        this.arrow = arrow;
    }

    public Label getLabel() {
        return this.label;
    }

    public JumpArrow<T> getArrow() {
        return this.arrow;
    }

    public T getEnding() {
        switch (this.arrow.getEdgeType()) {
            case forward: {
                return this.arrow.getHead();
            }
            case back: {
                return this.arrow.getNewTail();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return this.label.equals(block.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }
}

