/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.ssa.DataFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.LiveRange;
import de.mirkosertic.bytecoder.ssa.MethodParameterValue;
import de.mirkosertic.bytecoder.ssa.SelfReferenceParameterValue;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;

public class Variable
extends Value {
    public static final String THISREF_NAME = "__tr";
    private final TypeRef type;
    private final String name;
    private final boolean synthetic;
    private final LiveRange liveRange;

    public static Variable createThisRef(TypeRef aThisType) {
        Variable theVariable = new Variable(aThisType, THISREF_NAME, true, 0L);
        theVariable.initializeWith(new SelfReferenceParameterValue(), 0L);
        return theVariable;
    }

    public static Variable createMethodParameter(int aIndex, TypeRef aTypeRef) {
        Variable theVariable = new Variable(aTypeRef, "p" + aIndex, true, 0L);
        theVariable.initializeWith(new MethodParameterValue(aIndex, aTypeRef), 0L);
        return theVariable;
    }

    public static Variable createMethodParameter(int aIndex, String aName, TypeRef aTypeRef) {
        Variable theVariable = new Variable(aTypeRef, aName, true, 0L);
        theVariable.initializeWith(new MethodParameterValue(aIndex, aTypeRef), 0L);
        return theVariable;
    }

    private Variable(TypeRef aType, String aName, boolean aSynthetic, long aDefinedAt) {
        this.type = aType;
        this.name = aName;
        this.synthetic = aSynthetic;
        this.liveRange = new LiveRange(aDefinedAt, aDefinedAt);
    }

    public Variable(TypeRef aType, String aName, long definedAt) {
        this(aType, aName, false, definedAt);
    }

    public LiveRange liveRange() {
        return this.liveRange;
    }

    public void initializeWith(Value aValue, long analysisTime) {
        this.type.resolve().eventuallyPromoteTo(aValue.resolveType().resolve());
        aValue.addEdgeTo(DataFlowEdgeType.instance, this);
        this.liveRange.usedAt(analysisTime);
        this.markUsageIn(aValue, analysisTime);
    }

    private void markUsageIn(Value aValue, long analysisTime) {
        if (aValue instanceof Variable) {
            ((Variable)aValue).liveRange().usedAt(analysisTime);
        } else {
            for (Value theValue : aValue.incomingDataFlows()) {
                this.markUsageIn(theValue, analysisTime);
            }
        }
    }

    @Override
    public TypeRef resolveType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " of type " + this.resolveType();
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }
}

