/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.EdgeType;
import de.mirkosertic.bytecoder.graph.Node;
import de.mirkosertic.bytecoder.ssa.DataFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Value
extends Node<Node, EdgeType> {
    private List<? extends Value> cachedIncomingFlows;

    protected Value() {
    }

    private void resetCaches() {
        this.cachedIncomingFlows = null;
    }

    protected void receivesDataFrom(Value aOtherValue) {
        aOtherValue.addEdgeTo(DataFlowEdgeType.instance, this);
        this.resetCaches();
    }

    protected void receivesDataFrom(List<Value> aValues) {
        for (Value aValue : aValues) {
            this.receivesDataFrom(aValue);
        }
    }

    protected void receivesDataFrom(Value ... aValues) {
        for (Value aValue : aValues) {
            this.receivesDataFrom(aValue);
        }
    }

    public <T extends Value> List<T> incomingDataFlows() {
        if (this.cachedIncomingFlows == null) {
            this.cachedIncomingFlows = this.incomingEdges(DataFlowEdgeType.filter()).map(t -> (Value)t.sourceNode()).collect(Collectors.toList());
        }
        return this.cachedIncomingFlows;
    }

    public void replaceIncomingDataEdge(Value aOldValue, Value aNewValue) {
        this.incomingEdges(DataFlowEdgeType.filter()).forEach(aEdge -> {
            if (aEdge.sourceNode() == aOldValue) {
                aEdge.newSourceIs(aNewValue);
            }
        });
        this.resetCaches();
    }

    public void routeIncomingDataFlowsTo(Value aNewExpression) {
        this.incomingEdges(DataFlowEdgeType.filter()).forEach(aEdge -> {
            aEdge.newTargetId(aNewExpression);
            aNewExpression.addIncomingEdge((Edge)aEdge);
        });
        this.resetCaches();
    }

    public abstract TypeRef resolveType();

    public static TypeRef widestTypeOf(Collection<Value> aValue, BytecodeLinkerContext aLinkerContext) {
        if (aValue.size() == 1) {
            return aValue.iterator().next().resolveType();
        }
        HashSet<TypeRef> theTypes = new HashSet<TypeRef>();
        for (Value v : aValue) {
            TypeRef theType = v.resolveType();
            if (theType == TypeRef.Native.REFERENCE) continue;
            theTypes.add(v.resolveType());
        }
        if (theTypes.size() == 1) {
            return (TypeRef)theTypes.iterator().next();
        }
        TypeRef.Native theCurrent = null;
        for (Value theValue : aValue) {
            TypeRef.Native theValueType = theValue.resolveType().resolve();
            if (theCurrent == null) {
                theCurrent = theValueType;
                continue;
            }
            theCurrent = theCurrent.eventuallyPromoteTo(theValueType);
        }
        return theCurrent;
    }
}

