/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public interface TypeRef {
    public Native resolve();

    public boolean isArray();

    public boolean isObject();

    public String toString();

    public static TypeRef toType(final BytecodeTypeRef aTypeRef) {
        if (aTypeRef.isVoid()) {
            return Native.VOID;
        }
        if (aTypeRef.isArray()) {
            return new ArrayTypeRef(){

                @Override
                public BytecodeArrayTypeRef arrayType() {
                    return (BytecodeArrayTypeRef)aTypeRef;
                }

                @Override
                public boolean isArray() {
                    return true;
                }

                @Override
                public Native resolve() {
                    return Native.REFERENCE;
                }

                @Override
                public boolean isObject() {
                    return true;
                }

                @Override
                public String toString() {
                    return "array of " + this.arrayType().singleElementType();
                }
            };
        }
        if (aTypeRef.isPrimitive()) {
            BytecodePrimitiveTypeRef thePrimitive = (BytecodePrimitiveTypeRef)aTypeRef;
            switch (thePrimitive) {
                case INT: {
                    return Native.INT;
                }
                case LONG: {
                    return Native.LONG;
                }
                case FLOAT: {
                    return Native.FLOAT;
                }
                case DOUBLE: {
                    return Native.DOUBLE;
                }
                case BYTE: {
                    return Native.BYTE;
                }
                case VOID: {
                    return Native.VOID;
                }
                case CHAR: {
                    return Native.CHAR;
                }
                case SHORT: {
                    return Native.SHORT;
                }
                case BOOLEAN: {
                    return Native.BOOLEAN;
                }
            }
            throw new IllegalStateException("Not supported : " + aTypeRef);
        }
        return new ObjectTypeRef(){

            @Override
            public BytecodeObjectTypeRef objectType() {
                return (BytecodeObjectTypeRef)aTypeRef;
            }

            @Override
            public Native resolve() {
                return Native.REFERENCE;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean isObject() {
                return true;
            }

            @Override
            public String toString() {
                return "object of type " + aTypeRef.name();
            }
        };
    }

    public static enum Native implements TypeRef
    {
        BYTE{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case BYTE: {
                        return BYTE;
                    }
                    case INT: {
                        return INT;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        SHORT{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        CHAR{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case CHAR: {
                        return CHAR;
                    }
                    case INT: {
                        return INT;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case INT: {
                        return INT;
                    }
                    case BOOLEAN: {
                        return BOOLEAN;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        INT{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case INT: {
                        return INT;
                    }
                    case BOOLEAN: {
                        return INT;
                    }
                    case BYTE: {
                        return INT;
                    }
                    case CHAR: {
                        return INT;
                    }
                    case REFERENCE: {
                        return INT;
                    }
                    case SHORT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        LONG{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case LONG: {
                        return LONG;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }

            @Override
            public boolean isCategory2() {
                return true;
            }
        }
        ,
        FLOAT{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case FLOAT: {
                        return FLOAT;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        }
        ,
        DOUBLE{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case DOUBLE: {
                        return DOUBLE;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }

            @Override
            public boolean isCategory2() {
                return true;
            }
        }
        ,
        REFERENCE{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case REFERENCE: {
                        return REFERENCE;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }

            @Override
            public boolean isObject() {
                return true;
            }
        }
        ,
        VOID{

            @Override
            public Native eventuallyPromoteTo(Native aOtherType) {
                switch (aOtherType) {
                    case VOID: {
                        return VOID;
                    }
                }
                throw new IllegalStateException("Don't know how to promote " + this + " to " + aOtherType);
            }
        };


        @Override
        public Native resolve() {
            return this;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        public boolean isCategory2() {
            return false;
        }

        public abstract Native eventuallyPromoteTo(Native var1);
    }

    public static interface ObjectTypeRef
    extends TypeRef {
        public BytecodeObjectTypeRef objectType();
    }

    public static interface ArrayTypeRef
    extends TypeRef {
        public BytecodeArrayTypeRef arrayType();
    }
}

