/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableSwitchExpression
extends Expression
implements ExpressionListContainer {
    private final long lowValue;
    private final long highValue;
    private final ExpressionList defaultExpressions;
    private final BytecodeOpcodeAddress defaultJumpTarget;
    private final Map<Long, ExpressionList> offsets;

    public TableSwitchExpression(Program aProgram, BytecodeOpcodeAddress aAddress, Value aValue, long aLowValue, long aHighValue, ExpressionList aDefaultPath, BytecodeOpcodeAddress aDefaultJumpTarget, Map<Long, ExpressionList> aPathPerOffset) {
        super(aProgram, aAddress);
        this.lowValue = aLowValue;
        this.highValue = aHighValue;
        this.defaultExpressions = aDefaultPath;
        this.defaultJumpTarget = aDefaultJumpTarget;
        this.offsets = aPathPerOffset;
        this.receivesDataFrom(aValue);
    }

    public long getLowValue() {
        return this.lowValue;
    }

    public long getHighValue() {
        return this.highValue;
    }

    public ExpressionList getDefaultExpressions() {
        return this.defaultExpressions;
    }

    public Map<Long, ExpressionList> getOffsets() {
        return this.offsets;
    }

    @Override
    public Set<ExpressionList> getExpressionLists() {
        HashSet<ExpressionList> theResult = new HashSet<ExpressionList>();
        theResult.add(this.defaultExpressions);
        theResult.addAll(this.offsets.values());
        return theResult;
    }

    public BytecodeOpcodeAddress getDefaultJumpTarget() {
        return this.defaultJumpTarget;
    }

    @Override
    public Expression deepCopy() {
        HashMap<Long, ExpressionList> theHandler = new HashMap<Long, ExpressionList>();
        for (Map.Entry<Long, ExpressionList> theEntry : this.offsets.entrySet()) {
            theHandler.put(theEntry.getKey(), theEntry.getValue().deepCopy());
        }
        return new TableSwitchExpression(this.getProgram(), this.getAddress(), (Value)this.incomingDataFlows().get(0), this.lowValue, this.highValue, this.defaultExpressions.deepCopy(), this.defaultJumpTarget, theHandler);
    }
}

