/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeResolvedFields;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GetStaticExpression;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewMultiArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectExpression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StaticDependencies {
    private final Set<BytecodeLinkedClass> dependencies = new HashSet<BytecodeLinkedClass>();

    public StaticDependencies(Program aProgram) {
        this.searchDependencies(aProgram);
    }

    public List<BytecodeLinkedClass> list() {
        return this.dependencies.stream().sorted(Comparator.comparing(o -> o.getClassName().name())).collect(Collectors.toList());
    }

    private void searchDependencies(Program aProgram) {
        HashSet<Value> theAlreadySeen = new HashSet<Value>();
        for (RegionNode theNode : aProgram.getControlFlowGraph().dominators().getPreOrder()) {
            this.searchDependencies(aProgram, theNode.getExpressions(), theAlreadySeen);
        }
    }

    private void searchDependencies(Program aProgram, ExpressionList aList, Set<Value> aAlreadySeen) {
        for (Expression e : aList.toList()) {
            if (e instanceof ExpressionListContainer) {
                ExpressionListContainer c = (ExpressionListContainer)((Object)e);
                for (ExpressionList l : c.getExpressionLists()) {
                    this.searchDependencies(aProgram, l, aAlreadySeen);
                }
            }
            this.searchDependencies(aProgram, e, aAlreadySeen);
        }
    }

    private BytecodeResolvedFields.FieldEntry implementingClassForStaticField(BytecodeLinkerContext aLinkerContext, BytecodeObjectTypeRef aClass, String aFieldName) {
        BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(aClass);
        BytecodeResolvedFields theFields = theLinkedClass.resolvedFields();
        return theFields.fieldByName(aFieldName);
    }

    private void searchDependencies(Program aProgram, Value e, Set<Value> alreadySeen) {
        if (alreadySeen.add(e)) {
            Expression n;
            BytecodeObjectTypeRef theClass;
            BytecodeResolvedFields.FieldEntry theEntry;
            if (e instanceof InvokeStaticMethodExpression) {
                InvokeStaticMethodExpression inv = (InvokeStaticMethodExpression)e;
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(inv.getClassName()));
            } else if (e instanceof PutStaticExpression) {
                PutStaticExpression put = (PutStaticExpression)e;
                theEntry = this.implementingClassForStaticField(aProgram.getLinkerContext(), BytecodeObjectTypeRef.fromUtf8Constant(put.getField().getClassIndex().getClassConstant().getConstant()), put.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
                theClass = theEntry.getProvidingClass().getClassName();
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(theClass));
            } else if (e instanceof GetStaticExpression) {
                GetStaticExpression get = (GetStaticExpression)e;
                theEntry = this.implementingClassForStaticField(aProgram.getLinkerContext(), BytecodeObjectTypeRef.fromUtf8Constant(get.getField().getClassIndex().getClassConstant().getConstant()), get.getField().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue());
                theClass = theEntry.getProvidingClass().getClassName();
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(theClass));
            } else if (e instanceof NewArrayExpression) {
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)));
            } else if (e instanceof NewMultiArrayExpression) {
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)));
            } else if (e instanceof ClassReferenceValue) {
                ClassReferenceValue r = (ClassReferenceValue)e;
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(r.getType()));
            } else if (e instanceof NewObjectExpression) {
                n = (NewObjectExpression)e;
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(((NewObjectExpression)n).getType().getConstant())));
            } else if (e instanceof NewObjectAndConstructExpression) {
                n = (NewObjectAndConstructExpression)e;
                this.dependencies.add(aProgram.getLinkerContext().resolveClass(((NewObjectAndConstructExpression)n).getClazz()));
            }
            for (Value v : e.incomingDataFlows()) {
                this.searchDependencies(aProgram, v, alreadySeen);
            }
        }
    }
}

