/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.graph.Node;
import de.mirkosertic.bytecoder.ssa.BlockState;
import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.ssa.VariableDescription;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RegionNode
extends Node<RegionNode, ControlFlowEdgeType> {
    public static final Comparator<RegionNode> NODE_COMPARATOR = Comparator.comparingInt(o -> o.getStartAddress().getAddress());
    public static final Predicate<Edge> FORWARD_EDGE_FILTER_REGULAR_FLOW_ONLY = edge -> edge.edgeType() == ControlFlowEdgeType.forward && ((RegionNode)edge.targetNode()).getType() == BlockType.NORMAL;
    public static final Predicate<Edge> ALL_SUCCCESSORS_REGULAR_FLOW_ONLY = edge -> ((RegionNode)edge.targetNode()).getType() == BlockType.NORMAL;
    private final BytecodeOpcodeAddress startAddress;
    private final Program program;
    private final BlockType type;
    private final Map<VariableDescription, Value> liveIn;
    private final Map<VariableDescription, Value> liveOut;
    private final ControlFlowGraph owningGraph;
    private final ExpressionList expressions;
    private long startAnalysisTime;
    private long finishedAnalysisTime;

    protected RegionNode(ControlFlowGraph aOwningGraph, BlockType aType, Program aProgram, BytecodeOpcodeAddress aStartAddress) {
        this.type = aType;
        this.owningGraph = aOwningGraph;
        this.startAddress = aStartAddress;
        this.program = aProgram;
        this.liveIn = new HashMap<VariableDescription, Value>();
        this.liveOut = new HashMap<VariableDescription, Value>();
        this.expressions = new ExpressionList();
    }

    public long getStartAnalysisTime() {
        return this.startAnalysisTime;
    }

    public void setStartAnalysisTime(long startAnalysisTime) {
        this.startAnalysisTime = startAnalysisTime;
    }

    public long getFinishedAnalysisTime() {
        return this.finishedAnalysisTime;
    }

    public void setFinishedAnalysisTime(long finishedAnalysisTime) {
        this.finishedAnalysisTime = finishedAnalysisTime;
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    public BlockType getType() {
        return this.type;
    }

    public boolean hasBackEdgeTo(RegionNode aNode) {
        for (Edge edge : this.outgoingEdges(t -> t == ControlFlowEdgeType.back).collect(Collectors.toList())) {
            if (edge.targetNode() != aNode) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncomingBackEdges() {
        return this.incomingEdges().anyMatch(t -> t.edgeType() == ControlFlowEdgeType.back);
    }

    public Set<RegionNode> getPredecessorsIgnoringBackEdges() {
        return this.incomingEdges().filter(t -> t.edgeType() == ControlFlowEdgeType.forward).map(t -> (RegionNode)t.sourceNode()).collect(Collectors.toSet());
    }

    public Set<RegionNode> getPredecessors() {
        return this.incomingEdges().map(t -> (RegionNode)t.sourceNode()).collect(Collectors.toSet());
    }

    public BytecodeOpcodeAddress getStartAddress() {
        return this.startAddress;
    }

    public Variable newVariable(TypeRef aType) {
        return this.program.createVariable(aType);
    }

    public Variable newVariable(BytecodeOpcodeAddress aAddress, TypeRef aType, Value aValue) {
        Variable theVar;
        if (aValue instanceof Variable && (theVar = (Variable)aValue).isSynthetic()) {
            return theVar;
        }
        Variable theNewVariable = this.newVariable(aType);
        theNewVariable.initializeWith(aValue, this.program.getAnalysisTime());
        this.expressions.add(new VariableAssignmentExpression(this.program, aAddress, theNewVariable, aValue));
        return theNewVariable;
    }

    public void addToLiveIn(Value aValue, VariableDescription aDescription) {
        this.liveIn.put(aDescription, aValue);
    }

    public void addToLiveOut(Value aValue, VariableDescription aDescription) {
        this.liveOut.put(aDescription, aValue);
    }

    public BlockState liveIn() {
        BlockState theState = new BlockState();
        for (Map.Entry<VariableDescription, Value> theEntry : this.liveIn.entrySet()) {
            theState.assignToPort(theEntry.getKey(), theEntry.getValue());
        }
        return theState;
    }

    public BlockState liveOut() {
        BlockState theState = new BlockState();
        for (Map.Entry<VariableDescription, Value> theEntry : this.liveOut.entrySet()) {
            theState.assignToPort(theEntry.getKey(), theEntry.getValue());
        }
        return theState;
    }

    public boolean isImmediatelyDominatedBy(RegionNode aNode) {
        Set<RegionNode> thePredecessors = this.getPredecessorsIgnoringBackEdges();
        return thePredecessors.size() == 1 && thePredecessors.contains(aNode);
    }

    public boolean isDominatedBy(RegionNode aOtherNode) {
        return this.owningGraph.dominates(aOtherNode, this);
    }

    public Set<RegionNode> dominatedNodes() {
        return this.owningGraph.dominatedNodesOf(this);
    }

    @Override
    public <T extends Node> T addEdgeTo(ControlFlowEdgeType aType, T aTargetNode) {
        if (this.outgoingEdges().noneMatch(t -> t.targetNode() == aTargetNode)) {
            return super.addEdgeTo(aType, aTargetNode);
        }
        return null;
    }

    public String toString() {
        return "RegionNode{startAddress=" + this.startAddress + '}';
    }

    public static enum BlockType {
        NORMAL,
        EXCEPTION_HANDLER,
        FINALLY;

    }

    public static class ExceptionHandler {
        private final BytecodeOpcodeAddress startPc;
        private final BytecodeOpcodeAddress endPC;
        private final List<BytecodeExceptionTableEntry> catchEntries;

        public ExceptionHandler(BytecodeOpcodeAddress startPc, BytecodeOpcodeAddress endPC) {
            this.startPc = startPc;
            this.endPC = endPC;
            this.catchEntries = new ArrayList<BytecodeExceptionTableEntry>();
        }

        public void addCatchEntry(BytecodeExceptionTableEntry aEntry) {
            this.catchEntries.add(aEntry);
        }

        public boolean regionMatchesTo(BytecodeExceptionTableEntry aEntry) {
            return this.startPc.equals(aEntry.getStartPC()) && this.endPC.equals(aEntry.getEndPc());
        }

        public List<BytecodeExceptionTableEntry> getCatchEntries() {
            return this.catchEntries;
        }

        public BytecodeOpcodeAddress getStartPc() {
            return this.startPc;
        }

        public BytecodeOpcodeAddress getEndPC() {
            return this.endPC;
        }

        public boolean sameCatchBlockAs(ExceptionHandler aOther) {
            if (this.catchEntries.size() != aOther.catchEntries.size()) {
                return false;
            }
            for (BytecodeExceptionTableEntry theCatch : this.catchEntries) {
                boolean found = false;
                for (BytecodeExceptionTableEntry theOtherCatch : this.catchEntries) {
                    if (theOtherCatch.getHandlerPc().getAddress() != theCatch.getHandlerPc().getAddress() || theOtherCatch.getCatchTypeAsInt() != theCatch.getCatchTypeAsInt()) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

