/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.DebugInformation;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Variable;
import java.util.ArrayList;
import java.util.List;

public class Program {
    private final DebugInformation debugInformation;
    private final ControlFlowGraph controlFlowGraph = new ControlFlowGraph(this);
    private final List<Variable> variables = new ArrayList<Variable>();
    private final List<Variable> arguments = new ArrayList<Variable>();
    private BytecodeProgram.FlowInformation flowInformation;
    private long analysisTime;
    private final BytecodeLinkerContext linkerContext;

    public Program(DebugInformation aDebugInformation, BytecodeLinkerContext aLinkerContext) {
        this.debugInformation = aDebugInformation;
        this.analysisTime = 0L;
        this.linkerContext = aLinkerContext;
    }

    public BytecodeLinkerContext getLinkerContext() {
        return this.linkerContext;
    }

    public DebugInformation getDebugInformation() {
        return this.debugInformation;
    }

    public void setFlowInformation(BytecodeProgram.FlowInformation flowInformation) {
        this.flowInformation = flowInformation;
    }

    public BytecodeProgram.FlowInformation getFlowInformation() {
        return this.flowInformation;
    }

    public void addArgument(Variable aVariable) {
        this.arguments.add(aVariable);
    }

    public List<Variable> getArguments() {
        return this.arguments;
    }

    public Variable argumentAt(int aIndex) {
        if (aIndex >= 0 && aIndex < this.arguments.size()) {
            return this.arguments.get(aIndex);
        }
        throw new IllegalStateException("No argument at index " + aIndex);
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable createVariable(TypeRef aType) {
        int theIndex = this.variables.size();
        return this.createVariable("var" + theIndex, aType);
    }

    public Variable createVariable(String aName, TypeRef aType) {
        Variable theNewVariable = new Variable(aType, aName, this.analysisTime);
        this.variables.add(theNewVariable);
        return theNewVariable;
    }

    public void deleteVariable(Variable aVariable) {
        this.variables.remove(aVariable);
    }

    public void incrementAnalysisTime() {
        ++this.analysisTime;
    }

    public long getAnalysisTime() {
        return this.analysisTime;
    }
}

