/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.ssa.LocalVariableDescription;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.StackVariableDescription;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.ssa.VariableDescription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ParsingHelperCache {
    private final BytecodeObjectTypeRef linkedClass;
    private final BytecodeMethod method;
    private final RegionNode startNode;
    private final Map<RegionNode, ParsingHelper> finalStatesForNodes;
    private final Program program;
    private final BytecodeLocalVariableTableAttributeInfo localVariableTableAttributeInfo;
    private final BytecodeLinkerContext linkerContext;

    public ParsingHelperCache(Program aProgram, BytecodeObjectTypeRef aLinkedClass, BytecodeMethod aMethod, BytecodeLocalVariableTableAttributeInfo aLocalVariablesInfo, BytecodeLinkerContext aLinkerContext) {
        this.linkedClass = aLinkedClass;
        this.program = aProgram;
        this.startNode = aProgram.getControlFlowGraph().startNode();
        this.method = aMethod;
        this.localVariableTableAttributeInfo = aLocalVariablesInfo;
        this.finalStatesForNodes = new HashMap<RegionNode, ParsingHelper>();
        this.linkerContext = aLinkerContext;
    }

    public void registerFinalStateForNode(RegionNode aNode, ParsingHelper aState) {
        this.finalStatesForNodes.put(aNode, aState);
    }

    public ParsingHelper resolveInitialProgramFlowState() {
        BytecodeTypeRef[] theTypes;
        HashMap<LocalVariableDescription, Variable> theValues = new HashMap<LocalVariableDescription, Variable>();
        int theCurrentIndex = 0;
        int theLocalVariableIndex = 0;
        if (!this.method.getAccessFlags().isStatic()) {
            TypeRef theThisType = TypeRef.toType(this.linkedClass);
            LocalVariableDescription localVariableDescription = new LocalVariableDescription(theLocalVariableIndex, theThisType);
            Variable theThisRef = this.program.argumentAt(theCurrentIndex);
            Variable theShadow = this.program.createVariable(theThisType);
            theShadow.initializeWith(theThisRef, 0L);
            this.startNode.getExpressions().add(new VariableAssignmentExpression(this.program, BytecodeOpcodeAddress.START_AT_ZERO, theShadow, theThisRef));
            theValues.put(localVariableDescription, theShadow);
            ++theCurrentIndex;
            ++theLocalVariableIndex;
        }
        for (BytecodeTypeRef theRef : theTypes = this.method.getSignature().getArguments()) {
            LocalVariableDescription theDesc = new LocalVariableDescription(theLocalVariableIndex, TypeRef.toType(theRef));
            Variable theArgument = this.program.argumentAt(theCurrentIndex);
            Variable theShadow = this.program.createVariable(theArgument.resolveType());
            theShadow.initializeWith(theArgument, 0L);
            this.startNode.getExpressions().add(new VariableAssignmentExpression(this.program, BytecodeOpcodeAddress.START_AT_ZERO, theShadow, theArgument));
            theValues.put(theDesc, theShadow);
            ++theCurrentIndex;
            ++theLocalVariableIndex;
            if (theRef != BytecodePrimitiveTypeRef.LONG && theRef != BytecodePrimitiveTypeRef.DOUBLE) continue;
            ++theLocalVariableIndex;
        }
        ParsingHelper.ValueProvider valueProvider = aDescription -> {
            Value theValue = (Value)theValues.get(aDescription);
            if (theValue == null) {
                throw new IllegalStateException("No value on cfg enter : " + aDescription);
            }
            return theValue;
        };
        return new ParsingHelper(this.program, this.localVariableTableAttributeInfo, this.startNode, valueProvider);
    }

    public ParsingHelper resolveFinalStateForNode(RegionNode aGraphNode) {
        return this.finalStatesForNodes.get(aGraphNode);
    }

    public ParsingHelper resolveInitialPHIStateForNode(RegionNode aBlock) {
        if (aBlock.getType() != RegionNode.BlockType.NORMAL) {
            ParsingHelper.ValueProvider theProvider = aDescription -> {
                if (aDescription instanceof StackVariableDescription) {
                    throw new IllegalStateException("Stack imports not allowed for EXCEPTION HANDLER or FINALLY blocks");
                }
                LocalVariableDescription theLocal = (LocalVariableDescription)aDescription;
                Set<RegionNode> thePredecessors = aBlock.getPredecessorsIgnoringBackEdges();
                if (thePredecessors.size() == 1 && !aBlock.hasIncomingBackEdges()) {
                    RegionNode theSinglePred = thePredecessors.iterator().next();
                    ParsingHelper theHelper = this.finalStatesForNodes.get(theSinglePred);
                    Value theValue = theHelper.requestValue(theLocal);
                    aBlock.addToLiveIn(theValue, theLocal);
                    return theValue;
                }
                return this.newPHIFor(thePredecessors, theLocal, aBlock);
            };
            return new ParsingHelper(this.program, this.localVariableTableAttributeInfo, aBlock, theProvider);
        }
        HashMap<StackVariableDescription, Set> theStackToImport = new HashMap<StackVariableDescription, Set>();
        int theRequestedStack = -1;
        for (RegionNode thePredecessor : aBlock.getPredecessorsIgnoringBackEdges()) {
            ParsingHelper theHelper = this.finalStatesForNodes.get(thePredecessor);
            if (theHelper.getStack().isEmpty()) continue;
            if (theRequestedStack == -1) {
                theRequestedStack = theHelper.getStack().size();
            } else if (theRequestedStack != theHelper.getStack().size()) {
                throw new IllegalStateException("Wrong number of exported stack in " + thePredecessor.getStartAddress().getAddress() + " expected " + theRequestedStack + " got " + theHelper.getStack().size() + " to jump to " + aBlock.getStartAddress().getAddress());
            }
            for (int i = 0; i < theHelper.getStack().size(); ++i) {
                StackVariableDescription theStackPos = new StackVariableDescription(theHelper.getStack().size() - i - 1);
                Value theStackValue = (Value)theHelper.getStack().get(i);
                Set theKnownValues = theStackToImport.computeIfAbsent(theStackPos, k -> new HashSet());
                theKnownValues.add(theStackValue);
            }
        }
        ParsingHelper.ValueProvider theProvider = aDescription -> this.newPHIFor(aBlock.getPredecessorsIgnoringBackEdges(), aDescription, aBlock);
        ParsingHelper theHelper = new ParsingHelper(this.program, this.localVariableTableAttributeInfo, aBlock, theProvider);
        for (Map.Entry theEntry : theStackToImport.entrySet()) {
            Set theValues = (Set)theEntry.getValue();
            if (theValues.size() == 1 && !aBlock.hasIncomingBackEdges()) {
                Value theSingleValue = (Value)theValues.iterator().next();
                theHelper.setStackValue(theRequestedStack - ((StackVariableDescription)theEntry.getKey()).getPos() - 1, theSingleValue);
                aBlock.addToLiveIn(theSingleValue, (VariableDescription)theEntry.getKey());
                continue;
            }
            TypeRef theType = Value.widestTypeOf(theValues, this.linkerContext);
            PHIValue thePHI = new PHIValue((VariableDescription)theEntry.getKey(), theType);
            for (Value v : theValues) {
                thePHI.receivesDataFrom(v);
            }
            theHelper.setStackValue(theRequestedStack - ((StackVariableDescription)theEntry.getKey()).getPos() - 1, thePHI);
            aBlock.addToLiveIn(thePHI, (VariableDescription)theEntry.getKey());
        }
        return theHelper;
    }

    private Value newPHIFor(Set<RegionNode> aNodes, VariableDescription aDescription, RegionNode aImportingBlock) {
        HashSet<Value> theValues = new HashSet<Value>();
        for (RegionNode thePredecessor : aNodes) {
            ParsingHelper theHelper = this.finalStatesForNodes.get(thePredecessor);
            if (theHelper == null) {
                throw new IllegalStateException("No helper for " + thePredecessor.getStartAddress().getAddress());
            }
            theValues.add(theHelper.requestValue(aDescription));
        }
        if (theValues.isEmpty()) {
            throw new IllegalStateException("No values for " + aDescription + " in block " + aImportingBlock.getStartAddress().getAddress());
        }
        if (theValues.size() == 1 && !aImportingBlock.hasIncomingBackEdges()) {
            Value theValue = (Value)theValues.iterator().next();
            aImportingBlock.addToLiveIn(theValue, aDescription);
            return theValue;
        }
        TypeRef theType = Value.widestTypeOf(theValues, this.linkerContext);
        PHIValue thePHI = new PHIValue(aDescription, theType);
        for (Value v : theValues) {
            thePHI.receivesDataFrom(v);
        }
        aImportingBlock.addToLiveIn(thePHI, aDescription);
        return thePHI;
    }

    public ParsingHelper resolveInitialStateFromPredecessorFor(RegionNode aNode, ParsingHelper aPredecessor) {
        ParsingHelper.ValueProvider theProvider = aPredecessor::requestValue;
        ParsingHelper theNew = new ParsingHelper(this.program, this.localVariableTableAttributeInfo, aNode, theProvider);
        Stack<Value> theStackToImport = aPredecessor.getStack();
        for (int i = 0; i < theStackToImport.size(); ++i) {
            StackVariableDescription theStackDesc = new StackVariableDescription(theStackToImport.size() - i - 1);
            Value theImportedValue = (Value)theStackToImport.get(i);
            theNew.getStack().push(theImportedValue);
            aNode.addToLiveIn(theImportedValue, theStackDesc);
            aPredecessor.getBlock().addToLiveOut(theImportedValue, theStackDesc);
        }
        return theNew;
    }
}

