/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.LocalVariableDescription;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.StackVariableDescription;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.ssa.VariableDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ParsingHelper {
    private final Program program;
    private final RegionNode block;
    private final Stack<Value> stack;
    private final Map<Integer, Value> localVariables;
    private final ValueProvider valueProvider;
    private final BytecodeLocalVariableTableAttributeInfo localVariableTableAttributeInfo;

    public ParsingHelper(Program aProgram, BytecodeLocalVariableTableAttributeInfo aDebugInfo, RegionNode aBlock, ValueProvider aValueProvider) {
        this.program = aProgram;
        this.stack = new Stack();
        this.block = aBlock;
        this.localVariables = new HashMap<Integer, Value>();
        this.valueProvider = aValueProvider;
        this.localVariableTableAttributeInfo = aDebugInfo;
    }

    public RegionNode getBlock() {
        return this.block;
    }

    public int numberOfLocalVariables() {
        return this.localVariables.size();
    }

    public Stack<Value> getStack() {
        return this.stack;
    }

    public Value pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Stack is empty!!!");
        }
        Value theValue = this.stack.pop();
        if (theValue instanceof Variable) {
            ((Variable)theValue).liveRange().usedAt(this.program.getAnalysisTime());
        }
        return theValue;
    }

    public Value peek() {
        Value theValue = this.stack.peek();
        if (theValue instanceof Variable) {
            ((Variable)theValue).liveRange().usedAt(this.program.getAnalysisTime());
        }
        return theValue;
    }

    public void push(BytecodeOpcodeAddress aAddress, Value aValue) {
        if (aValue == null) {
            throw new IllegalStateException("Trying to push null in " + this);
        }
        if (aValue instanceof Variable) {
            Variable v = (Variable)aValue;
            v.liveRange().usedAt(this.program.getAnalysisTime());
            this.stack.push(v);
        } else {
            Variable v = this.program.createVariable(aValue.resolveType());
            v.initializeWith(aValue, this.program.getAnalysisTime());
            this.block.getExpressions().add(new VariableAssignmentExpression(this.program, aAddress, v, aValue));
            this.stack.push(v);
        }
    }

    public Value getLocalVariable(int aIndex, TypeRef aExpectedType) {
        Value theValue = this.localVariables.get(aIndex);
        if (theValue == null) {
            LocalVariableDescription theDesc = new LocalVariableDescription(aIndex, aExpectedType);
            theValue = this.valueProvider.resolveValueFor(theDesc);
            if (theValue == null) {
                throw new IllegalStateException("Value must not be null from provider for " + theDesc);
            }
            this.block.addToLiveIn(theValue, theDesc);
            this.localVariables.put(aIndex, theValue);
        }
        if (theValue instanceof Variable) {
            ((Variable)theValue).liveRange().usedAt(this.program.getAnalysisTime());
        }
        return theValue;
    }

    public Value requestValue(VariableDescription aDescription) {
        if (aDescription instanceof LocalVariableDescription) {
            LocalVariableDescription theDesc = (LocalVariableDescription)aDescription;
            Value theValue = this.getLocalVariable(theDesc.getIndex(), ((LocalVariableDescription)aDescription).getTypeRef());
            this.block.addToLiveOut(theValue, theDesc);
            return theValue;
        }
        StackVariableDescription theStack = (StackVariableDescription)aDescription;
        if (theStack.getPos() < this.stack.size()) {
            Value theValue = (Value)this.stack.get(this.stack.size() - theStack.getPos() - 1);
            this.block.addToLiveOut(theValue, theStack);
            return theValue;
        }
        throw new IllegalStateException("Invalid stack index : " + theStack.getPos() + " with total size of " + this.stack.size());
    }

    public void setLocalVariable(BytecodeOpcodeAddress aInstruction, int aIndex, TypeRef aType, Value aValue) {
        BytecodeLocalVariableTableEntry theEntry;
        if (aValue == null) {
            throw new IllegalStateException("local variable " + aIndex + " must not be null in " + this);
        }
        if (this.localVariableTableAttributeInfo == null || (theEntry = this.localVariableTableAttributeInfo.matchingEntryFor(aInstruction, aIndex)) != null) {
            // empty if block
        }
        if (aValue instanceof Variable) {
            this.localVariables.put(aIndex, aValue);
            return;
        }
        Variable v = this.program.createVariable(aValue.resolveType());
        v.liveRange().usedAt(this.program.getAnalysisTime());
        this.block.getExpressions().add(new VariableAssignmentExpression(this.program, aInstruction, v, aValue));
        v.initializeWith(aValue, this.program.getAnalysisTime());
        this.localVariables.put(aIndex, v);
    }

    public void setStackValue(int aStackPos, Value aValue) {
        if (aValue instanceof Variable) {
            ((Variable)aValue).liveRange().usedAt(this.program.getAnalysisTime());
        }
        ArrayList<Value> theValues = new ArrayList<Value>(this.stack);
        while (theValues.size() <= aStackPos) {
            theValues.add(null);
        }
        theValues.set(aStackPos, aValue);
        this.stack.clear();
        this.stack.addAll(theValues);
    }

    @FunctionalInterface
    static interface ValueProvider {
        public Value resolveValueFor(VariableDescription var1);
    }
}

