/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.classlib.VM;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeBasicBlock;
import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethod;
import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethodsAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeCodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeConstant;
import de.mirkosertic.bytecoder.core.BytecodeDoubleConstant;
import de.mirkosertic.bytecoder.core.BytecodeFloatConstant;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeInstructionACONSTNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionALOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionANEWARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionARRAYLENGTH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionASTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionATHROW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionBIPUSH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionCHECKCAST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionD2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2X1;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2X2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUPX1;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUPX2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionF2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionFCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGETFIELD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGETSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGOTO;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericADD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericAND;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericArrayLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericArraySTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericCMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericDIV;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericInvoke;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericLDC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericMUL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericNEG;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericOR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericREM;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSHL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSHR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSUB;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericUSHR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericXOR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionI2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionICONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFACMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFCOND;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFICMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFNONNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIINC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINSTANCEOF;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEDYNAMIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEINTERFACE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESPECIAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEVIRTUAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionL2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLCMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLOOKUPSWITCH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionMONITORENTER;
import de.mirkosertic.bytecoder.core.BytecodeInstructionMONITOREXIT;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEWARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEWMULTIARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNOP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectArrayLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectArraySTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPOP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPOP2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTFIELD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionSIPUSH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionSWAP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionTABLESWITCH;
import de.mirkosertic.bytecoder.core.BytecodeIntegerConstant;
import de.mirkosertic.bytecoder.core.BytecodeInvokeDynamicConstant;
import de.mirkosertic.bytecoder.core.BytecodeLineNumberTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeLongConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodHandleConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeMethodTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.core.BytecodeReferenceIndex;
import de.mirkosertic.bytecoder.core.BytecodeReferenceKind;
import de.mirkosertic.bytecoder.core.BytecodeSourceFileAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeStringConstant;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.graph.Dominators;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.intrinsics.Intrinsics;
import de.mirkosertic.bytecoder.ssa.ArrayEntryExpression;
import de.mirkosertic.bytecoder.ssa.ArrayLengthExpression;
import de.mirkosertic.bytecoder.ssa.ArrayStoreExpression;
import de.mirkosertic.bytecoder.ssa.BinaryExpression;
import de.mirkosertic.bytecoder.ssa.BlockState;
import de.mirkosertic.bytecoder.ssa.ClassReferenceValue;
import de.mirkosertic.bytecoder.ssa.CompareExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.ControlFlowProcessingException;
import de.mirkosertic.bytecoder.ssa.CurrentExceptionExpression;
import de.mirkosertic.bytecoder.ssa.DebugInformation;
import de.mirkosertic.bytecoder.ssa.DirectInvokeMethodExpression;
import de.mirkosertic.bytecoder.ssa.DoubleValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.FixedBinaryExpression;
import de.mirkosertic.bytecoder.ssa.FloatValue;
import de.mirkosertic.bytecoder.ssa.FloorExpression;
import de.mirkosertic.bytecoder.ssa.GetFieldExpression;
import de.mirkosertic.bytecoder.ssa.GetStaticExpression;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.InstanceOfExpression;
import de.mirkosertic.bytecoder.ssa.IntegerValue;
import de.mirkosertic.bytecoder.ssa.InvokeStaticMethodExpression;
import de.mirkosertic.bytecoder.ssa.InvokeVirtualMethodExpression;
import de.mirkosertic.bytecoder.ssa.LongValue;
import de.mirkosertic.bytecoder.ssa.LookupSwitchExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandleExpression;
import de.mirkosertic.bytecoder.ssa.MethodHandlesGeneratedLookupExpression;
import de.mirkosertic.bytecoder.ssa.MethodTypeExpression;
import de.mirkosertic.bytecoder.ssa.NegatedExpression;
import de.mirkosertic.bytecoder.ssa.NewArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewMultiArrayExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectAndConstructExpression;
import de.mirkosertic.bytecoder.ssa.NewObjectExpression;
import de.mirkosertic.bytecoder.ssa.NullValue;
import de.mirkosertic.bytecoder.ssa.PHIValue;
import de.mirkosertic.bytecoder.ssa.ParsingHelper;
import de.mirkosertic.bytecoder.ssa.ParsingHelperCache;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.ProgramGenerator;
import de.mirkosertic.bytecoder.ssa.ProgramGeneratorFactory;
import de.mirkosertic.bytecoder.ssa.PutFieldExpression;
import de.mirkosertic.bytecoder.ssa.PutStaticExpression;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.ResolveCallsiteObjectExpression;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.StringValue;
import de.mirkosertic.bytecoder.ssa.TableSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import de.mirkosertic.bytecoder.ssa.TypeConversionExpression;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import de.mirkosertic.bytecoder.ssa.VariableDescription;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class NaiveProgramGenerator
implements ProgramGenerator {
    public static final ProgramGeneratorFactory FACTORY = NaiveProgramGenerator::new;
    private final BytecodeLinkerContext linkerContext;
    private final Intrinsics intrinsics;

    private NaiveProgramGenerator(BytecodeLinkerContext aLinkerContext, Intrinsics aIntrinsics) {
        this.linkerContext = aLinkerContext;
        this.intrinsics = aIntrinsics;
    }

    private DebugInformation debugInformationFor(BytecodeClass aOwningClass, BytecodeCodeAttributeInfo aCode) {
        BytecodeSourceFileAttributeInfo theSourceFileAttribute = aOwningClass.getAttributes().getByType(BytecodeSourceFileAttributeInfo.class);
        BytecodeLineNumberTableAttributeInfo theLineInfoAttribute = aCode.attributeByType(BytecodeLineNumberTableAttributeInfo.class);
        if (theSourceFileAttribute != null && theLineInfoAttribute != null) {
            String theSourceFileName = theSourceFileAttribute.getFileName();
            String theClassName = aOwningClass.getThisInfo().getConstant().stringValue();
            int p = theClassName.lastIndexOf("/");
            String thePackageName = theClassName.substring(0, p);
            String theOriginalFileName = thePackageName.replace(".", "/") + "/" + theSourceFileName;
            return DebugInformation.jvm(theOriginalFileName, theLineInfoAttribute);
        }
        return DebugInformation.empty();
    }

    @Override
    public Program generateFrom(BytecodeClass aOwningClass, BytecodeMethod aMethod) {
        Program theProgram;
        BytecodeCodeAttributeInfo theCode = aMethod.getCode(aOwningClass);
        BytecodeLocalVariableTableAttributeInfo theDebugInfos = null;
        if (theCode != null) {
            theDebugInfos = theCode.attributeByType(BytecodeLocalVariableTableAttributeInfo.class);
            theProgram = new Program(this.debugInformationFor(aOwningClass, theCode), this.linkerContext);
        } else {
            theProgram = new Program(DebugInformation.empty(), this.linkerContext);
        }
        int theCurrentIndex = 0;
        if (!aMethod.getAccessFlags().isStatic()) {
            theProgram.addArgument(Variable.createThisRef(TypeRef.toType(BytecodeObjectTypeRef.fromUtf8Constant(aOwningClass.getThisInfo().getConstant()))));
            ++theCurrentIndex;
        }
        BytecodeTypeRef[] theTypes = aMethod.getSignature().getArguments();
        for (int i = 0; i < theTypes.length; ++i) {
            BytecodeTypeRef theRef = theTypes[i];
            TypeRef theType = TypeRef.toType(theRef);
            if (theDebugInfos != null) {
                BytecodeLocalVariableTableEntry theEntry = theDebugInfos.matchingEntryFor(BytecodeOpcodeAddress.START_AT_ZERO, theCurrentIndex);
                if (theEntry != null) {
                    String theVariableName = "_" + theDebugInfos.resolveVariableName(theEntry).replace('<', '_').replace('-', '_').replace('?', '_').replace('*', '_').replace('>', '_');
                    theProgram.addArgument(Variable.createMethodParameter(i + 1, theVariableName, theType));
                } else {
                    theProgram.addArgument(Variable.createMethodParameter(i + 1, theType));
                }
            } else {
                theProgram.addArgument(Variable.createMethodParameter(i + 1, theType));
            }
            ++theCurrentIndex;
            if (theRef != BytecodePrimitiveTypeRef.LONG && theRef != BytecodePrimitiveTypeRef.DOUBLE) continue;
            ++theCurrentIndex;
        }
        if (aMethod.getAccessFlags().isAbstract() || aMethod.getAccessFlags().isNative()) {
            return theProgram;
        }
        BytecodeProgram.FlowInformation theFlowInformation = theCode.getProgram().toFlow();
        theProgram.setFlowInformation(theFlowInformation);
        HashMap<BytecodeBasicBlock, RegionNode> theCreatedBlocks = new HashMap<BytecodeBasicBlock, RegionNode>();
        ControlFlowGraph theGraph = theProgram.getControlFlowGraph();
        for (BytecodeBasicBlock theBlock : theFlowInformation.knownBlocks()) {
            RegionNode theSingleAssignmentBlock;
            switch (theBlock.getType()) {
                case NORMAL: {
                    theSingleAssignmentBlock = theGraph.createAt(theBlock.getStartAddress(), RegionNode.BlockType.NORMAL);
                    break;
                }
                case EXCEPTION_HANDLER: {
                    for (BytecodeUtf8Constant theClassInfo : theBlock.getCatchType()) {
                        this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theClassInfo));
                    }
                    theSingleAssignmentBlock = theGraph.createAt(theBlock.getStartAddress(), RegionNode.BlockType.EXCEPTION_HANDLER);
                    break;
                }
                case FINALLY: {
                    theSingleAssignmentBlock = theGraph.createAt(theBlock.getStartAddress(), RegionNode.BlockType.FINALLY);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported block type : " + (Object)((Object)theBlock.getType()));
                }
            }
            theCreatedBlocks.put(theBlock, theSingleAssignmentBlock);
        }
        for (Map.Entry theEntry : theCreatedBlocks.entrySet()) {
            for (BytecodeBasicBlock theSuccessor : ((BytecodeBasicBlock)theEntry.getKey()).getSuccessors()) {
                RegionNode theSuccessorBlock = (RegionNode)theCreatedBlocks.get(theSuccessor);
                if (theSuccessorBlock == null) {
                    throw new IllegalStateException("Cannot find successor block " + theSuccessor.getStartAddress().getAddress() + " from " + ((BytecodeBasicBlock)theEntry.getKey()).getStartAddress().getAddress());
                }
                ((RegionNode)theEntry.getValue()).addEdgeTo(ControlFlowEdgeType.forward, theSuccessorBlock);
            }
        }
        theProgram.getControlFlowGraph().calculateReachabilityAndMarkBackEdges();
        try {
            ParsingHelperCache theParsingHelperCache = new ParsingHelperCache(theProgram, BytecodeObjectTypeRef.fromUtf8Constant(aOwningClass.getThisInfo().getConstant()), aMethod, theDebugInfos, this.linkerContext);
            Dominators<RegionNode> theGraphDominators = theProgram.getControlFlowGraph().dominators();
            for (RegionNode theNode : theGraphDominators.getPreOrder()) {
                this.initializeBlock(aOwningClass, aMethod, theNode, theParsingHelperCache, theFlowInformation, theProgram);
            }
            for (RegionNode theNode : theGraphDominators.getPreOrder()) {
                GotoExpression theGoto;
                ExpressionList theCurrentList = theNode.getExpressions();
                Expression theLast = theCurrentList.lastExpression();
                if (theLast instanceof GotoExpression && Objects.equals((theGoto = (GotoExpression)theLast).jumpTarget(), theNode.getStartAddress())) {
                    theCurrentList.remove(theGoto);
                }
                if (theNode.getExpressions().endWithNeverReturningExpression()) continue;
                List theSuccessors = theNode.outgoingEdges().map(Edge::targetNode).collect(Collectors.toList());
                for (Expression theExpression : theCurrentList.toList()) {
                    if (!(theExpression instanceof IFExpression)) continue;
                    IFExpression theIF = (IFExpression)theExpression;
                    BytecodeOpcodeAddress theGoto2 = theIF.getGotoAddress();
                    theSuccessors.remove(theGraph.nodeStartingAt(theGoto2));
                }
                List theSuccessorRegions = theSuccessors.stream().filter(t -> t.getType() == RegionNode.BlockType.NORMAL).collect(Collectors.toList());
                if (theSuccessorRegions.size() == 1) {
                    theNode.getExpressions().add((Expression)new GotoExpression(theProgram, null, ((RegionNode)theSuccessorRegions.get(0)).getStartAddress()).withComment("Resolving pass thru direct"));
                    continue;
                }
                theSuccessorRegions = theNode.outgoingEdges().map(Edge::targetNode).filter(t -> t.getType() == RegionNode.BlockType.NORMAL).collect(Collectors.toList());
                if (theSuccessorRegions.size() == 1) {
                    theNode.getExpressions().add((Expression)new GotoExpression(theProgram, null, ((RegionNode)theSuccessorRegions.get(0)).getStartAddress()).withComment("Resolving pass thru direct"));
                    continue;
                }
                throw new IllegalStateException("Invalid number of successors : " + theSuccessors.size() + " for " + theNode.getStartAddress().getAddress());
            }
            for (RegionNode theNode : theGraphDominators.getPreOrder()) {
                BlockState theLiveIn = theNode.liveIn();
                theLiveIn.getPorts().forEach((d, value) -> {
                    for (RegionNode thePred : theNode.getPredecessors()) {
                        ParsingHelper theHelper = theParsingHelperCache.resolveFinalStateForNode(thePred);
                        theHelper.requestValue((VariableDescription)d);
                    }
                });
            }
            for (RegionNode theNode : theGraphDominators.getPreOrder()) {
                BlockState theNodeOut = theNode.liveOut();
                theNode.outgoingEdges().forEach(edge -> {
                    if (edge.edgeType() == ControlFlowEdgeType.back) {
                        RegionNode theReceiver = (RegionNode)edge.targetNode();
                        BlockState theReceiverLiveIn = theReceiver.liveIn();
                        theReceiverLiveIn.getPorts().entrySet().stream().forEach(entry -> {
                            if (entry.getValue() instanceof PHIValue) {
                                PHIValue phi = (PHIValue)entry.getValue();
                                Value theOutValue = theNodeOut.getPorts().get(entry.getKey());
                                if (theOutValue != phi) {
                                    phi.receivesDataFrom(theOutValue);
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            throw new ControlFlowProcessingException("Error processing CFG for " + aOwningClass.getThisInfo().getConstant().stringValue() + "." + aMethod.getName().stringValue(), e, theProgram.getControlFlowGraph());
        }
        return theProgram;
    }

    private void initializeBlock(BytecodeClass aOwningClass, BytecodeMethod aMethod, RegionNode aCurrentBlock, ParsingHelperCache aCache, BytecodeProgram.FlowInformation aFlowInformation, Program aProgram) {
        ParsingHelper theParsingState;
        Set<RegionNode> thePredecessors = aCurrentBlock.getPredecessorsIgnoringBackEdges();
        if (aCurrentBlock.getType() != RegionNode.BlockType.NORMAL) {
            theParsingState = aCache.resolveInitialPHIStateForNode(aCurrentBlock);
            if (!aMethod.getAccessFlags().isStatic()) {
                TypeRef theClass = TypeRef.toType(BytecodeObjectTypeRef.fromUtf8Constant(aOwningClass.getThisInfo().getConstant()));
                theParsingState.setLocalVariable(aCurrentBlock.getStartAddress(), theParsingState.numberOfLocalVariables(), theClass, Variable.createThisRef(theClass));
            }
            theParsingState.push(aCurrentBlock.getStartAddress(), new CurrentExceptionExpression(aProgram, null));
        } else if (aCurrentBlock == aProgram.getControlFlowGraph().startNode()) {
            theParsingState = aCache.resolveInitialProgramFlowState();
        } else if (thePredecessors.size() == 1 && !aCurrentBlock.hasIncomingBackEdges()) {
            RegionNode thePredecessor = thePredecessors.iterator().next();
            ParsingHelper theResolved = aCache.resolveFinalStateForNode(thePredecessor);
            if (theResolved == null) {
                throw new IllegalStateException("No fully resolved predecessor found!");
            }
            theParsingState = aCache.resolveInitialStateFromPredecessorFor(aCurrentBlock, theResolved);
        } else {
            theParsingState = aCache.resolveInitialPHIStateForNode(aCurrentBlock);
        }
        this.initializeBlockWith(aOwningClass, aMethod, aCurrentBlock, aFlowInformation, theParsingState, aProgram);
        aCache.registerFinalStateForNode(aCurrentBlock, theParsingState);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeBlockWith(BytecodeClass aOwningClass, BytecodeMethod aMethod, RegionNode aTargetBlock, BytecodeProgram.FlowInformation aFlowInformation, ParsingHelper aHelper, Program aProgram) {
        aTargetBlock.setStartAnalysisTime(aProgram.getAnalysisTime());
        BytecodeBasicBlock theBytecodeBlock = aFlowInformation.blockAt(aTargetBlock.getStartAddress());
        for (BytecodeInstruction theInstruction : theBytecodeBlock.getInstructions()) {
            BytecodeConstant[] theAssignment;
            BytecodeTypeRef[] theArgumentTypes;
            BinaryExpression theBinaryValue;
            ExpressionList theExpressions;
            Variable theNewVariable;
            Value theTarget;
            Value theValue3;
            BytecodeInstruction theINS;
            if (theInstruction instanceof BytecodeInstructionNOP) {
                BytecodeInstructionNOP bytecodeInstructionNOP = (BytecodeInstructionNOP)theInstruction;
            } else if (theInstruction instanceof BytecodeInstructionMONITORENTER) {
                theINS = (BytecodeInstructionMONITORENTER)theInstruction;
                aHelper.pop();
            } else if (theInstruction instanceof BytecodeInstructionMONITOREXIT) {
                theINS = (BytecodeInstructionMONITOREXIT)theInstruction;
                aHelper.pop();
            } else if (theInstruction instanceof BytecodeInstructionCHECKCAST) {
                theINS = (BytecodeInstructionCHECKCAST)theInstruction;
                Value value = aHelper.peek();
            } else if (theInstruction instanceof BytecodeInstructionPOP) {
                theINS = (BytecodeInstructionPOP)theInstruction;
                aHelper.pop();
            } else if (theInstruction instanceof BytecodeInstructionPOP2) {
                theINS = (BytecodeInstructionPOP2)theInstruction;
                Value value = aHelper.pop();
                switch (value.resolveType().resolve()) {
                    case LONG: {
                        break;
                    }
                    case DOUBLE: {
                        break;
                    }
                    default: {
                        aHelper.pop();
                        break;
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionDUP) {
                theINS = (BytecodeInstructionDUP)theInstruction;
                Value value = aHelper.peek();
                aHelper.push(theINS.getOpcodeAddress(), value);
            } else if (theInstruction instanceof BytecodeInstructionDUP2) {
                theINS = (BytecodeInstructionDUP2)theInstruction;
                Value value = aHelper.pop();
                if (value.resolveType().resolve().isCategory2()) {
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                } else {
                    Value value2 = aHelper.pop();
                    aHelper.push(theINS.getOpcodeAddress(), value2);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), value2);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                }
            } else if (theInstruction instanceof BytecodeInstructionDUP2X1) {
                theINS = (BytecodeInstructionDUP2X1)theInstruction;
                Value value = aHelper.pop();
                if (value.resolveType().resolve().isCategory2()) {
                    Value value3 = aHelper.pop();
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), value3);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                } else {
                    Value value4 = aHelper.pop();
                    theValue3 = aHelper.pop();
                    aHelper.push(theINS.getOpcodeAddress(), value4);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), theValue3);
                    aHelper.push(theINS.getOpcodeAddress(), value4);
                    aHelper.push(theINS.getOpcodeAddress(), value4);
                }
            } else if (theInstruction instanceof BytecodeInstructionDUP2X2) {
                theINS = (BytecodeInstructionDUP2X2)theInstruction;
                Value value = aHelper.pop();
                if (value.resolveType().resolve().isCategory2()) {
                    Value value5 = aHelper.pop();
                    if (value5.resolveType().resolve().isCategory2()) {
                        aHelper.push(theINS.getOpcodeAddress(), value);
                        aHelper.push(theINS.getOpcodeAddress(), value5);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                    } else {
                        theValue3 = aHelper.pop();
                        aHelper.push(theINS.getOpcodeAddress(), value);
                        aHelper.push(theINS.getOpcodeAddress(), theValue3);
                        aHelper.push(theINS.getOpcodeAddress(), value5);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                    }
                } else {
                    Value value6 = aHelper.pop();
                    theValue3 = aHelper.pop();
                    if (theValue3.resolveType().resolve().isCategory2()) {
                        aHelper.push(theINS.getOpcodeAddress(), value6);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                        aHelper.push(theINS.getOpcodeAddress(), theValue3);
                        aHelper.push(theINS.getOpcodeAddress(), value6);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                    } else {
                        Value value7 = aHelper.pop();
                        aHelper.push(theINS.getOpcodeAddress(), value6);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                        aHelper.push(theINS.getOpcodeAddress(), value7);
                        aHelper.push(theINS.getOpcodeAddress(), theValue3);
                        aHelper.push(theINS.getOpcodeAddress(), value6);
                        aHelper.push(theINS.getOpcodeAddress(), value);
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionDUPX1) {
                theINS = (BytecodeInstructionDUPX1)theInstruction;
                Value value = aHelper.pop();
                Value value8 = aHelper.pop();
                aHelper.push(theINS.getOpcodeAddress(), value);
                aHelper.push(theINS.getOpcodeAddress(), value8);
                aHelper.push(theINS.getOpcodeAddress(), value);
            } else if (theInstruction instanceof BytecodeInstructionDUPX2) {
                theINS = (BytecodeInstructionDUPX2)theInstruction;
                Value value = aHelper.pop();
                Value value9 = aHelper.pop();
                if (value9.resolveType().resolve().isCategory2()) {
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), value9);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                } else {
                    theValue3 = aHelper.pop();
                    aHelper.push(theINS.getOpcodeAddress(), value);
                    aHelper.push(theINS.getOpcodeAddress(), theValue3);
                    aHelper.push(theINS.getOpcodeAddress(), value9);
                    aHelper.push(theINS.getOpcodeAddress(), value);
                }
            } else if (theInstruction instanceof BytecodeInstructionGETSTATIC) {
                theINS = (BytecodeInstructionGETSTATIC)theInstruction;
                if (!this.intrinsics.intrinsify(aProgram, (BytecodeInstructionGETSTATIC)theINS, aTargetBlock, aHelper)) {
                    GetStaticExpression getStaticExpression = new GetStaticExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionGETSTATIC)theINS).getConstant());
                    Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGETSTATIC)theINS).getConstant().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().fieldType()), getStaticExpression);
                    aHelper.push(theINS.getOpcodeAddress(), variable);
                }
            } else if (theInstruction instanceof BytecodeInstructionASTORE) {
                theINS = (BytecodeInstructionASTORE)theInstruction;
                Value value = aHelper.pop();
                aHelper.setLocalVariable(theInstruction.getOpcodeAddress(), ((BytecodeInstructionASTORE)theINS).getVariableIndex(), value.resolveType(), value);
            } else if (theInstruction instanceof BytecodeInstructionGenericSTORE) {
                theINS = (BytecodeInstructionGenericSTORE)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), value.resolveType().resolve(), value);
                aHelper.setLocalVariable(theInstruction.getOpcodeAddress(), ((BytecodeInstructionGenericSTORE)theINS).getVariableIndex(), TypeRef.toType(((BytecodeInstructionGenericSTORE)theINS).getType()), variable);
            } else if (theInstruction instanceof BytecodeInstructionObjectArrayLOAD) {
                theINS = (BytecodeInstructionObjectArrayLOAD)theInstruction;
                Value value = aHelper.pop();
                Value value10 = aHelper.pop();
                TypeRef theType = value10.resolveType();
                if (theType instanceof TypeRef.ArrayTypeRef) {
                    TypeRef.ArrayTypeRef arrayTypeRef = (TypeRef.ArrayTypeRef)value10.resolveType();
                    TypeRef singleElementType = TypeRef.toType(arrayTypeRef.arrayType().singleElementType());
                    Variable theVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), singleElementType, new ArrayEntryExpression(aProgram, theInstruction.getOpcodeAddress(), singleElementType, value10, value));
                    aHelper.push(theINS.getOpcodeAddress(), theVariable);
                } else {
                    Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), theType, new ArrayEntryExpression(aProgram, theInstruction.getOpcodeAddress(), theType, value10, value));
                    aHelper.push(theINS.getOpcodeAddress(), variable);
                }
            } else if (theInstruction instanceof BytecodeInstructionGenericArrayLOAD) {
                theINS = (BytecodeInstructionGenericArrayLOAD)theInstruction;
                Value value = aHelper.pop();
                Value value11 = aHelper.pop();
                Variable theVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericArrayLOAD)theINS).getType()), new ArrayEntryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericArrayLOAD)theINS).getType()), value11, value));
                aHelper.push(theINS.getOpcodeAddress(), theVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericArraySTORE) {
                theINS = (BytecodeInstructionGenericArraySTORE)theInstruction;
                Value value = aHelper.pop();
                Value value12 = aHelper.pop();
                theTarget = aHelper.pop();
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericArraySTORE)theINS).getType()), theTarget, value12, value));
            } else if (theInstruction instanceof BytecodeInstructionObjectArraySTORE) {
                theINS = (BytecodeInstructionObjectArraySTORE)theInstruction;
                Value value = aHelper.pop();
                Value value13 = aHelper.pop();
                theTarget = aHelper.pop();
                aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theTarget, value13, value));
            } else if (theInstruction instanceof BytecodeInstructionACONSTNULL) {
                theINS = (BytecodeInstructionACONSTNULL)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new NullValue());
            } else if (theInstruction instanceof BytecodeInstructionPUTFIELD) {
                theINS = (BytecodeInstructionPUTFIELD)theInstruction;
                Value value = aHelper.pop();
                Value value14 = aHelper.pop();
                aTargetBlock.getExpressions().add(new PutFieldExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionPUTFIELD)theINS).getFieldRefConstant(), value14, value));
            } else if (theInstruction instanceof BytecodeInstructionGETFIELD) {
                theINS = (BytecodeInstructionGETFIELD)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGETFIELD)theINS).getFieldRefConstant().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().fieldType()), new GetFieldExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionGETFIELD)theINS).getFieldRefConstant(), value));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionPUTSTATIC) {
                theINS = (BytecodeInstructionPUTSTATIC)theInstruction;
                Value value = aHelper.pop();
                if (!this.intrinsics.intrinsify(aProgram, (BytecodeInstructionPUTSTATIC)theINS, value, aTargetBlock, aHelper)) {
                    aTargetBlock.getExpressions().add(new PutStaticExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionPUTSTATIC)theINS).getConstant(), value));
                }
            } else if (theInstruction instanceof BytecodeInstructionGenericLDC) {
                theINS = (BytecodeInstructionGenericLDC)theInstruction;
                BytecodeConstant bytecodeConstant = ((BytecodeInstructionGenericLDC)theINS).constant();
                if (bytecodeConstant instanceof BytecodeDoubleConstant) {
                    BytecodeDoubleConstant bytecodeDoubleConstant = (BytecodeDoubleConstant)bytecodeConstant;
                    aHelper.push(theINS.getOpcodeAddress(), new DoubleValue(bytecodeDoubleConstant.getDoubleValue()));
                } else if (bytecodeConstant instanceof BytecodeLongConstant) {
                    BytecodeLongConstant bytecodeLongConstant = (BytecodeLongConstant)bytecodeConstant;
                    aHelper.push(theINS.getOpcodeAddress(), new LongValue(bytecodeLongConstant.getLongValue()));
                } else if (bytecodeConstant instanceof BytecodeFloatConstant) {
                    BytecodeFloatConstant bytecodeFloatConstant = (BytecodeFloatConstant)bytecodeConstant;
                    aHelper.push(theINS.getOpcodeAddress(), new FloatValue(bytecodeFloatConstant.getFloatValue()));
                } else if (bytecodeConstant instanceof BytecodeIntegerConstant) {
                    BytecodeIntegerConstant bytecodeIntegerConstant = (BytecodeIntegerConstant)bytecodeConstant;
                    aHelper.push(theINS.getOpcodeAddress(), new IntegerValue(bytecodeIntegerConstant.getIntegerValue()));
                } else if (bytecodeConstant instanceof BytecodeStringConstant) {
                    BytecodeStringConstant bytecodeStringConstant = (BytecodeStringConstant)bytecodeConstant;
                    aHelper.push(theINS.getOpcodeAddress(), new StringValue(bytecodeStringConstant.getValue().stringValue()));
                } else {
                    if (!(bytecodeConstant instanceof BytecodeClassinfoConstant)) throw new IllegalArgumentException("Unsupported constant type : " + bytecodeConstant);
                    BytecodeClassinfoConstant bytecodeClassinfoConstant = (BytecodeClassinfoConstant)bytecodeConstant;
                    BytecodeUtf8Constant theUTF8 = bytecodeClassinfoConstant.getConstant();
                    if (theUTF8.stringValue().startsWith("[")) {
                        aHelper.push(theINS.getOpcodeAddress(), new ClassReferenceValue(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)));
                    } else {
                        aHelper.push(theINS.getOpcodeAddress(), new ClassReferenceValue(BytecodeObjectTypeRef.fromUtf8Constant(bytecodeClassinfoConstant.getConstant())));
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionBIPUSH) {
                theINS = (BytecodeInstructionBIPUSH)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new IntegerValue(((BytecodeInstructionBIPUSH)theINS).getByteValue()));
            } else if (theInstruction instanceof BytecodeInstructionSIPUSH) {
                theINS = (BytecodeInstructionSIPUSH)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new IntegerValue(((BytecodeInstructionSIPUSH)theINS).getShortValue()));
            } else if (theInstruction instanceof BytecodeInstructionICONST) {
                theINS = (BytecodeInstructionICONST)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new IntegerValue(((BytecodeInstructionICONST)theINS).getIntConst()));
            } else if (theInstruction instanceof BytecodeInstructionFCONST) {
                theINS = (BytecodeInstructionFCONST)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new FloatValue(((BytecodeInstructionFCONST)theINS).getFloatValue()));
            } else if (theInstruction instanceof BytecodeInstructionDCONST) {
                theINS = (BytecodeInstructionDCONST)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new DoubleValue(((BytecodeInstructionDCONST)theINS).getDoubleConst()));
            } else if (theInstruction instanceof BytecodeInstructionLCONST) {
                theINS = (BytecodeInstructionLCONST)theInstruction;
                aHelper.push(theINS.getOpcodeAddress(), new LongValue(((BytecodeInstructionLCONST)theINS).getLongConst()));
            } else if (theInstruction instanceof BytecodeInstructionGenericNEG) {
                theINS = (BytecodeInstructionGenericNEG)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), value.resolveType(), new NegatedExpression(aProgram, theInstruction.getOpcodeAddress(), value));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionARRAYLENGTH) {
                theINS = (BytecodeInstructionARRAYLENGTH)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.INT, new ArrayLengthExpression(aProgram, theInstruction.getOpcodeAddress(), value));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionGenericLOAD) {
                theINS = (BytecodeInstructionGenericLOAD)theInstruction;
                Value value = aHelper.getLocalVariable(((BytecodeInstructionGenericLOAD)theINS).getVariableIndex(), TypeRef.toType(((BytecodeInstructionGenericLOAD)theINS).getType()));
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), value.resolveType(), value);
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionALOAD) {
                theINS = (BytecodeInstructionALOAD)theInstruction;
                Value value = aHelper.getLocalVariable(((BytecodeInstructionALOAD)theINS).getVariableIndex(), TypeRef.Native.REFERENCE);
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), value.resolveType(), value);
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionGenericCMP) {
                theINS = (BytecodeInstructionGenericCMP)theInstruction;
                Value value = aHelper.pop();
                Value value15 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.INT, new CompareExpression(aProgram, theInstruction.getOpcodeAddress(), value15, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionLCMP) {
                theINS = (BytecodeInstructionLCMP)theInstruction;
                Value value = aHelper.pop();
                Value value16 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.INT, new CompareExpression(aProgram, theInstruction.getOpcodeAddress(), value16, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionIINC) {
                theINS = (BytecodeInstructionIINC)theInstruction;
                Value value = aHelper.getLocalVariable(((BytecodeInstructionIINC)theINS).getIndex(), TypeRef.Native.INT);
                aHelper.setLocalVariable(theInstruction.getOpcodeAddress(), ((BytecodeInstructionIINC)theINS).getIndex(), TypeRef.Native.INT, new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.INT, value, BinaryExpression.Operator.ADD, new IntegerValue(((BytecodeInstructionIINC)theINS).getConstant())));
            } else if (theInstruction instanceof BytecodeInstructionGenericREM) {
                theINS = (BytecodeInstructionGenericREM)theInstruction;
                Value value = aHelper.pop();
                Value value17 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericREM)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericREM)theINS).getType()), value17, BinaryExpression.Operator.REMAINDER, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericADD) {
                theINS = (BytecodeInstructionGenericADD)theInstruction;
                Value value = aHelper.pop();
                Value value18 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericADD)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericADD)theINS).getType()), value18, BinaryExpression.Operator.ADD, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionSWAP) {
                theINS = (BytecodeInstructionSWAP)theInstruction;
                Value value = aHelper.pop();
                Value value19 = aHelper.pop();
                aHelper.push(theINS.getOpcodeAddress(), value19);
                aHelper.push(theINS.getOpcodeAddress(), value);
            } else if (theInstruction instanceof BytecodeInstructionGenericDIV) {
                theINS = (BytecodeInstructionGenericDIV)theInstruction;
                Value value = aHelper.pop();
                Value value20 = aHelper.pop();
                BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericDIV)theINS).getType()), value20, BinaryExpression.Operator.DIV, value);
                switch (((BytecodeInstructionGenericDIV)theINS).getType()) {
                    case FLOAT: {
                        theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericDIV)theINS).getType()), binaryExpression);
                        break;
                    }
                    case DOUBLE: {
                        theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericDIV)theINS).getType()), binaryExpression);
                        break;
                    }
                    default: {
                        theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericDIV)theINS).getType()), new FloorExpression(aProgram, theInstruction.getOpcodeAddress(), binaryExpression, TypeRef.toType(((BytecodeInstructionGenericDIV)theINS).getType())));
                    }
                }
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericMUL) {
                theINS = (BytecodeInstructionGenericMUL)theInstruction;
                Value value = aHelper.pop();
                Value value21 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericMUL)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericMUL)theINS).getType()), value21, BinaryExpression.Operator.MUL, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericSUB) {
                theINS = (BytecodeInstructionGenericSUB)theInstruction;
                Value value = aHelper.pop();
                Value value22 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSUB)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSUB)theINS).getType()), value22, BinaryExpression.Operator.SUB, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericXOR) {
                theINS = (BytecodeInstructionGenericXOR)theInstruction;
                Value value = aHelper.pop();
                Value value23 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericXOR)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericXOR)theINS).getType()), value23, BinaryExpression.Operator.BINARYXOR, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericOR) {
                theINS = (BytecodeInstructionGenericOR)theInstruction;
                Value value = aHelper.pop();
                Value value24 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericOR)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericOR)theINS).getType()), value24, BinaryExpression.Operator.BINARYOR, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericAND) {
                theINS = (BytecodeInstructionGenericAND)theInstruction;
                Value value = aHelper.pop();
                Value value25 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericAND)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericAND)theINS).getType()), value25, BinaryExpression.Operator.BINARYAND, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericSHL) {
                theINS = (BytecodeInstructionGenericSHL)theInstruction;
                Value value = aHelper.pop();
                Value value26 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSHL)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSHL)theINS).getType()), value26, BinaryExpression.Operator.BINARYSHIFTLEFT, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericSHR) {
                theINS = (BytecodeInstructionGenericSHR)theInstruction;
                Value value = aHelper.pop();
                Value value27 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSHR)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericSHR)theINS).getType()), value27, BinaryExpression.Operator.BINARYSHIFTRIGHT, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionGenericUSHR) {
                theINS = (BytecodeInstructionGenericUSHR)theInstruction;
                Value value = aHelper.pop();
                Value value28 = aHelper.pop();
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericUSHR)theINS).getType()), new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionGenericUSHR)theINS).getType()), value28, BinaryExpression.Operator.BINARYUNSIGNEDSHIFTRIGHT, value));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionIFNULL) {
                theINS = (BytecodeInstructionIFNULL)theInstruction;
                Value value = aHelper.pop();
                FixedBinaryExpression fixedBinaryExpression = new FixedBinaryExpression(aProgram, theInstruction.getOpcodeAddress(), value, FixedBinaryExpression.Operator.ISNULL);
                theExpressions = new ExpressionList();
                theExpressions.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionIFNULL)theINS).getJumpTarget()));
                aTargetBlock.getExpressions().add(new IFExpression(aProgram, theINS.getOpcodeAddress(), ((BytecodeInstructionIFNULL)theINS).getJumpTarget(), fixedBinaryExpression, theExpressions));
            } else if (theInstruction instanceof BytecodeInstructionIFNONNULL) {
                theINS = (BytecodeInstructionIFNONNULL)theInstruction;
                Value value = aHelper.pop();
                FixedBinaryExpression fixedBinaryExpression = new FixedBinaryExpression(aProgram, theInstruction.getOpcodeAddress(), value, FixedBinaryExpression.Operator.ISNONNULL);
                theExpressions = new ExpressionList();
                theExpressions.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionIFNONNULL)theINS).getJumpTarget()));
                aTargetBlock.getExpressions().add(new IFExpression(aProgram, theINS.getOpcodeAddress(), ((BytecodeInstructionIFNONNULL)theINS).getJumpTarget(), fixedBinaryExpression, theExpressions));
            } else if (theInstruction instanceof BytecodeInstructionIFICMP) {
                theINS = (BytecodeInstructionIFICMP)theInstruction;
                Value value = aHelper.pop();
                Value value29 = aHelper.pop();
                switch (((BytecodeInstructionIFICMP)theINS).getType()) {
                    case lt: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.LESSTHAN, value);
                        break;
                    }
                    case eq: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.EQUALS, value);
                        break;
                    }
                    case gt: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.GREATERTHAN, value);
                        break;
                    }
                    case ge: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.GREATEROREQUALS, value);
                        break;
                    }
                    case le: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.LESSTHANOREQUALS, value);
                        break;
                    }
                    case ne: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value29, BinaryExpression.Operator.NOTEQUALS, value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not supported operation : " + (Object)((Object)((BytecodeInstructionIFICMP)theINS).getType()));
                    }
                }
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionIFICMP)theINS).getJumpTarget()));
                aTargetBlock.getExpressions().add(new IFExpression(aProgram, theINS.getOpcodeAddress(), ((BytecodeInstructionIFICMP)theINS).getJumpTarget(), theBinaryValue, expressionList));
            } else if (theInstruction instanceof BytecodeInstructionIFACMP) {
                theINS = (BytecodeInstructionIFACMP)theInstruction;
                Value value = aHelper.pop();
                Value value30 = aHelper.pop();
                switch (((BytecodeInstructionIFACMP)theINS).getType()) {
                    case eq: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value30, BinaryExpression.Operator.EQUALS, value);
                        break;
                    }
                    case ne: {
                        theBinaryValue = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value30, BinaryExpression.Operator.NOTEQUALS, value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not supported operation : " + (Object)((Object)((BytecodeInstructionIFACMP)theINS).getType()));
                    }
                }
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionIFACMP)theINS).getJumpTarget()));
                aTargetBlock.getExpressions().add(new IFExpression(aProgram, theINS.getOpcodeAddress(), ((BytecodeInstructionIFACMP)theINS).getJumpTarget(), theBinaryValue, expressionList));
            } else if (theInstruction instanceof BytecodeInstructionIFCOND) {
                void var12_129;
                theINS = (BytecodeInstructionIFCOND)theInstruction;
                Value value = aHelper.pop();
                switch (((BytecodeInstructionIFCOND)theINS).getType()) {
                    case lt: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.LESSTHAN, new IntegerValue(0));
                        break;
                    }
                    case eq: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.EQUALS, new IntegerValue(0));
                        break;
                    }
                    case gt: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.GREATERTHAN, new IntegerValue(0));
                        break;
                    }
                    case ge: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.GREATEROREQUALS, new IntegerValue(0));
                        break;
                    }
                    case le: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.LESSTHANOREQUALS, new IntegerValue(0));
                        break;
                    }
                    case ne: {
                        BinaryExpression binaryExpression = new BinaryExpression(aProgram, theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, value, BinaryExpression.Operator.NOTEQUALS, new IntegerValue(0));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not supported operation : " + (Object)((Object)((BytecodeInstructionIFCOND)theINS).getType()));
                    }
                }
                theExpressions = new ExpressionList();
                theExpressions.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionIFCOND)theINS).getJumpTarget()));
                aTargetBlock.getExpressions().add(new IFExpression(aProgram, theINS.getOpcodeAddress(), ((BytecodeInstructionIFCOND)theINS).getJumpTarget(), (Value)var12_129, theExpressions));
            } else if (theInstruction instanceof BytecodeInstructionObjectRETURN) {
                theINS = (BytecodeInstructionObjectRETURN)theInstruction;
                Value value = aHelper.pop();
                aTargetBlock.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), value));
            } else if (theInstruction instanceof BytecodeInstructionGenericRETURN) {
                theINS = (BytecodeInstructionGenericRETURN)theInstruction;
                Value value = aHelper.pop();
                aTargetBlock.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), value));
            } else if (theInstruction instanceof BytecodeInstructionATHROW) {
                theINS = (BytecodeInstructionATHROW)theInstruction;
                Value value = aHelper.pop();
                aTargetBlock.getExpressions().add(new ThrowExpression(aProgram, theInstruction.getOpcodeAddress(), value));
            } else if (theInstruction instanceof BytecodeInstructionRETURN) {
                theINS = (BytecodeInstructionRETURN)theInstruction;
                aTargetBlock.getExpressions().add(new ReturnExpression(aProgram, theInstruction.getOpcodeAddress()));
            } else if (theInstruction instanceof BytecodeInstructionNEW) {
                theINS = (BytecodeInstructionNEW)theInstruction;
                BytecodeClassinfoConstant bytecodeClassinfoConstant = ((BytecodeInstructionNEW)theINS).getClassInfoForObjectToCreate();
                BytecodeObjectTypeRef bytecodeObjectTypeRef = BytecodeObjectTypeRef.fromUtf8Constant(bytecodeClassinfoConstant.getConstant());
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(bytecodeObjectTypeRef), new NewObjectExpression(aProgram, theInstruction.getOpcodeAddress(), bytecodeClassinfoConstant));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionNEWARRAY) {
                theINS = (BytecodeInstructionNEWARRAY)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewArrayExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionNEWARRAY)theINS).getPrimitiveType(), value));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionNEWMULTIARRAY) {
                void var12_133;
                theINS = (BytecodeInstructionNEWMULTIARRAY)theInstruction;
                ArrayList<Value> arrayList = new ArrayList<Value>();
                boolean bl = false;
                while (var12_133 < ((BytecodeInstructionNEWMULTIARRAY)theINS).getDimensions()) {
                    arrayList.add(aHelper.pop());
                    ++var12_133;
                }
                Collections.reverse(arrayList);
                BytecodeTypeRef bytecodeTypeRef = this.linkerContext.getSignatureParser().toFieldType(new BytecodeUtf8Constant(((BytecodeInstructionNEWMULTIARRAY)theINS).getTypeConstant().getConstant().stringValue()));
                theNewVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewMultiArrayExpression(aProgram, theInstruction.getOpcodeAddress(), bytecodeTypeRef, arrayList));
                aHelper.push(theINS.getOpcodeAddress(), theNewVariable);
            } else if (theInstruction instanceof BytecodeInstructionANEWARRAY) {
                theINS = (BytecodeInstructionANEWARRAY)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewArrayExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionANEWARRAY)theINS).getObjectType(), value));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionGOTO) {
                theINS = (BytecodeInstructionGOTO)theInstruction;
                aTargetBlock.getExpressions().add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionGOTO)theINS).getJumpAddress()));
            } else if (theInstruction instanceof BytecodeInstructionL2Generic) {
                theINS = (BytecodeInstructionL2Generic)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionL2Generic)theINS).getTargetType()), new TypeConversionExpression(aProgram, theInstruction.getOpcodeAddress(), value, TypeRef.toType(((BytecodeInstructionL2Generic)theINS).getTargetType())));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionI2Generic) {
                theINS = (BytecodeInstructionI2Generic)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionI2Generic)theINS).getTargetType()), new TypeConversionExpression(aProgram, theInstruction.getOpcodeAddress(), value, TypeRef.toType(((BytecodeInstructionI2Generic)theINS).getTargetType())));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionF2Generic) {
                theINS = (BytecodeInstructionF2Generic)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionF2Generic)theINS).getTargetType()), new TypeConversionExpression(aProgram, theInstruction.getOpcodeAddress(), value, TypeRef.toType(((BytecodeInstructionF2Generic)theINS).getTargetType())));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionD2Generic) {
                theINS = (BytecodeInstructionD2Generic)theInstruction;
                Value value = aHelper.pop();
                Variable variable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(((BytecodeInstructionD2Generic)theINS).getTargetType()), new TypeConversionExpression(aProgram, theInstruction.getOpcodeAddress(), value, TypeRef.toType(((BytecodeInstructionD2Generic)theINS).getTargetType())));
                aHelper.push(theINS.getOpcodeAddress(), variable);
            } else if (theInstruction instanceof BytecodeInstructionINVOKESPECIAL) {
                theINS = (BytecodeInstructionINVOKESPECIAL)theInstruction;
                BytecodeMethodSignature bytecodeMethodSignature = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (BytecodeTypeRef theArgumentType : theArgumentTypes = bytecodeMethodSignature.getArguments()) {
                    arrayList.add(aHelper.pop());
                }
                Collections.reverse(arrayList);
                Variable variable = (Variable)aHelper.pop();
                String theMethodName = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue();
                BytecodeObjectTypeRef theType = BytecodeObjectTypeRef.fromUtf8Constant(((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getClassIndex().getClassConstant().getConstant());
                if (!this.intrinsics.intrinsify(aProgram, (BytecodeInstructionINVOKESPECIAL)theINS, theType, arrayList, variable, aTargetBlock, aHelper)) {
                    List theIncomingValues;
                    if ("<init>".equals(theMethodName) && (theIncomingValues = variable.incomingDataFlows()).size() == 1 && theIncomingValues.get(0) instanceof NewObjectExpression) {
                        for (RegionNode theNode : aProgram.getControlFlowGraph().dominators().getPreOrder()) {
                            for (Expression theExpression : theNode.getExpressions().toList()) {
                                if (!(theExpression instanceof VariableAssignmentExpression) || !(theAssignment = (BytecodeConstant[])theExpression).getVariable().getName().equals(variable.getName()) || !(theAssignment.incomingDataFlows().get(0) instanceof NewObjectExpression)) continue;
                                theNode.getExpressions().remove((Expression)theAssignment);
                            }
                        }
                        aTargetBlock.getExpressions().add(new VariableAssignmentExpression(aProgram, theINS.getOpcodeAddress(), variable, new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), theType, bytecodeMethodSignature, arrayList)));
                    } else {
                        DirectInvokeMethodExpression theExpression = new DirectInvokeMethodExpression(aProgram, theInstruction.getOpcodeAddress(), theType, theMethodName, bytecodeMethodSignature, variable, arrayList);
                        if (bytecodeMethodSignature.getReturnType().isVoid()) {
                            aTargetBlock.getExpressions().add(theExpression);
                        } else {
                            Variable theNewVariable2 = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(bytecodeMethodSignature.getReturnType()), theExpression);
                            aHelper.push(theINS.getOpcodeAddress(), theNewVariable2);
                        }
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionINVOKEVIRTUAL) {
                BytecodeTypeRef[] theArgumentTypes2;
                theINS = (BytecodeInstructionINVOKEVIRTUAL)theInstruction;
                BytecodeUtf8Constant bytecodeUtf8Constant = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getClassIndex().getClassConstant().getConstant();
                if (bytecodeUtf8Constant.stringValue().startsWith("[")) {
                    BytecodeTypeRef bytecodeTypeRef = this.linkerContext.getSignatureParser().toFieldType(bytecodeUtf8Constant);
                } else {
                    BytecodeObjectTypeRef bytecodeObjectTypeRef = BytecodeObjectTypeRef.fromUtf8Constant(bytecodeUtf8Constant);
                }
                BytecodeMethodSignature theSignature = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (BytecodeTypeRef theArgumentType : theArgumentTypes2 = theSignature.getArguments()) {
                    arrayList.add(aHelper.pop());
                }
                Collections.reverse(arrayList);
                Value theTarget2 = aHelper.pop();
                if (!this.intrinsics.intrinsify(aProgram, (BytecodeInstructionINVOKEVIRTUAL)theINS, arrayList, theTarget2, aTargetBlock, aHelper)) {
                    void var11_69;
                    InvokeVirtualMethodExpression theExpression = new InvokeVirtualMethodExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType(), theTarget2, arrayList, false, (BytecodeTypeRef)var11_69);
                    if (theSignature.getReturnType().isVoid()) {
                        aTargetBlock.getExpressions().add(theExpression);
                    } else {
                        Variable theNewVariable3 = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(theSignature.getReturnType()), theExpression);
                        aHelper.push(theINS.getOpcodeAddress(), theNewVariable3);
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionINVOKEINTERFACE) {
                BytecodeTypeRef[] bytecodeTypeRefArray;
                theINS = (BytecodeInstructionINVOKEINTERFACE)theInstruction;
                BytecodeObjectTypeRef bytecodeObjectTypeRef = BytecodeObjectTypeRef.fromUtf8Constant(((BytecodeInstructionINVOKEINTERFACE)theINS).getMethodDescriptor().getClassIndex().getClassConstant().getConstant());
                BytecodeMethodSignature bytecodeMethodSignature = ((BytecodeInstructionINVOKEINTERFACE)theINS).getMethodDescriptor().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                ArrayList<Value> theArguments = new ArrayList<Value>();
                for (BytecodeTypeRef theArgumentType : bytecodeTypeRefArray = bytecodeMethodSignature.getArguments()) {
                    theArguments.add(aHelper.pop());
                }
                Collections.reverse(theArguments);
                Value theTarget3 = aHelper.pop();
                InvokeVirtualMethodExpression theExpression = new InvokeVirtualMethodExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionINVOKEINTERFACE)theINS).getMethodDescriptor().getNameAndTypeIndex().getNameAndType(), theTarget3, theArguments, true, bytecodeObjectTypeRef);
                if (bytecodeMethodSignature.getReturnType().isVoid()) {
                    aTargetBlock.getExpressions().add(theExpression);
                } else {
                    Variable theNewVariable4 = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(bytecodeMethodSignature.getReturnType()), theExpression);
                    aHelper.push(theINS.getOpcodeAddress(), theNewVariable4);
                }
            } else if (theInstruction instanceof BytecodeInstructionINVOKESTATIC) {
                theINS = (BytecodeInstructionINVOKESTATIC)theInstruction;
                BytecodeMethodSignature bytecodeMethodSignature = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (BytecodeTypeRef theArgumentType : theArgumentTypes = bytecodeMethodSignature.getArguments()) {
                    arrayList.add(aHelper.pop());
                }
                Collections.reverse(arrayList);
                BytecodeClassinfoConstant bytecodeClassinfoConstant = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getClassIndex().getClassConstant();
                BytecodeObjectTypeRef theObjectType = BytecodeObjectTypeRef.fromUtf8Constant(bytecodeClassinfoConstant.getConstant());
                if (!this.intrinsics.intrinsify(aProgram, (BytecodeInstructionINVOKESTATIC)theINS, arrayList, theObjectType, aTargetBlock, aHelper)) {
                    BytecodeObjectTypeRef theClassToInvoke = BytecodeObjectTypeRef.fromUtf8Constant(((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getClassIndex().getClassConstant().getConstant());
                    this.linkerContext.resolveClass(theClassToInvoke).resolveStaticMethod(((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature());
                    BytecodeMethodSignature theCalledSignature = ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                    InvokeStaticMethodExpression theExpression = new InvokeStaticMethodExpression(aProgram, theInstruction.getOpcodeAddress(), theClassToInvoke, ((BytecodeInstructionGenericInvoke)theINS).getMethodReference().getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theCalledSignature, arrayList);
                    if (bytecodeMethodSignature.getReturnType().isVoid()) {
                        aTargetBlock.getExpressions().add(theExpression);
                    } else {
                        Variable theNewVariable5 = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(bytecodeMethodSignature.getReturnType()), theExpression);
                        aHelper.push(theINS.getOpcodeAddress(), theNewVariable5);
                    }
                }
            } else if (theInstruction instanceof BytecodeInstructionINSTANCEOF) {
                theINS = (BytecodeInstructionINSTANCEOF)theInstruction;
                Value value = aHelper.pop();
                InstanceOfExpression instanceOfExpression = new InstanceOfExpression(aProgram, theInstruction.getOpcodeAddress(), value, ((BytecodeInstructionINSTANCEOF)theINS).getTypeRef());
                Variable theCheckResult = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.BOOLEAN, instanceOfExpression);
                aHelper.push(theINS.getOpcodeAddress(), theCheckResult);
            } else if (theInstruction instanceof BytecodeInstructionTABLESWITCH) {
                theINS = (BytecodeInstructionTABLESWITCH)theInstruction;
                Value value = aHelper.pop();
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionTABLESWITCH)theINS).getDefaultJumpTarget()));
                HashMap<Long, ExpressionList> theOffsets = new HashMap<Long, ExpressionList>();
                long[] lArray = ((BytecodeInstructionTABLESWITCH)theINS).getOffsets();
                for (int i = 0; i < lArray.length; ++i) {
                    ExpressionList theJump = new ExpressionList();
                    theJump.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), theINS.getOpcodeAddress().add((int)lArray[i])));
                    theOffsets.put(Long.valueOf(i), theJump);
                }
                aTargetBlock.getExpressions().add(new TableSwitchExpression(aProgram, theInstruction.getOpcodeAddress(), value, ((BytecodeInstructionTABLESWITCH)theINS).getLowValue(), ((BytecodeInstructionTABLESWITCH)theINS).getHighValue(), expressionList, ((BytecodeInstructionTABLESWITCH)theINS).getDefaultJumpTarget(), theOffsets));
            } else if (theInstruction instanceof BytecodeInstructionLOOKUPSWITCH) {
                theINS = (BytecodeInstructionLOOKUPSWITCH)theInstruction;
                Value value = aHelper.pop();
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), ((BytecodeInstructionLOOKUPSWITCH)theINS).getDefaultJumpTarget()));
                HashMap<Long, ExpressionList> thePairs = new HashMap<Long, ExpressionList>();
                for (BytecodeInstructionLOOKUPSWITCH.Pair thePair : ((BytecodeInstructionLOOKUPSWITCH)theINS).getPairs()) {
                    ExpressionList thePairExpressions = new ExpressionList();
                    thePairExpressions.add(new GotoExpression(aProgram, theInstruction.getOpcodeAddress(), theINS.getOpcodeAddress().add((int)thePair.getOffset())));
                    thePairs.put(thePair.getMatch(), thePairExpressions);
                }
                aTargetBlock.getExpressions().add(new LookupSwitchExpression(aProgram, theInstruction.getOpcodeAddress(), value, expressionList, ((BytecodeInstructionLOOKUPSWITCH)theINS).getDefaultJumpTarget(), thePairs));
            } else {
                if (!(theInstruction instanceof BytecodeInstructionINVOKEDYNAMIC)) throw new IllegalArgumentException("Not implemented : " + theInstruction);
                theINS = (BytecodeInstructionINVOKEDYNAMIC)theInstruction;
                BytecodeInvokeDynamicConstant bytecodeInvokeDynamicConstant = ((BytecodeInstructionINVOKEDYNAMIC)theINS).getCallSite();
                BytecodeMethodSignature bytecodeMethodSignature = bytecodeInvokeDynamicConstant.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                BytecodeBootstrapMethodsAttributeInfo theBootStrapMethods = aOwningClass.getAttributes().getByType(BytecodeBootstrapMethodsAttributeInfo.class);
                BytecodeBootstrapMethod bytecodeBootstrapMethod = theBootStrapMethods.methodByIndex(bytecodeInvokeDynamicConstant.getBootstrapMethodAttributeIndex().getIndex());
                BytecodeMethodHandleConstant theMethodRef = bytecodeBootstrapMethod.getMethodRef();
                BytecodeMethodRefConstant theBootstrapMethodToInvoke = (BytecodeMethodRefConstant)theMethodRef.getReferenceIndex().getConstant();
                Program theProgram = new Program(DebugInformation.empty(), this.linkerContext);
                RegionNode theInitNode = theProgram.getControlFlowGraph().createAt(BytecodeOpcodeAddress.START_AT_ZERO, RegionNode.BlockType.NORMAL);
                theProgram.getControlFlowGraph().calculateReachabilityAndMarkBackEdges();
                switch (theMethodRef.getReferenceKind()) {
                    case REF_invokeStatic: {
                        String theMethodName;
                        BytecodeObjectTypeRef theClassWithBootstrapMethod = BytecodeObjectTypeRef.fromUtf8Constant(theBootstrapMethodToInvoke.getClassIndex().getClassConstant().getConstant());
                        BytecodeMethodSignature theSignature = theBootstrapMethodToInvoke.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature();
                        ArrayList<Value> theArguments = new ArrayList<Value>();
                        theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new MethodHandlesGeneratedLookupExpression(aProgram, theInstruction.getOpcodeAddress(), theClassWithBootstrapMethod)));
                        theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new StringValue(bytecodeInvokeDynamicConstant.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue())));
                        theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new MethodTypeExpression(aProgram, theInstruction.getOpcodeAddress(), bytecodeMethodSignature)));
                        theAssignment = bytecodeBootstrapMethod.getArguments();
                        int n = theAssignment.length;
                        for (int i = 0; i < n; ++i) {
                            BytecodeConstant thePrimitive;
                            BytecodeConstant theArgumentConstant = theAssignment[i];
                            if (theArgumentConstant instanceof BytecodeMethodTypeConstant) {
                                BytecodeMethodTypeConstant theMethodType = (BytecodeMethodTypeConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new MethodTypeExpression(aProgram, theInstruction.getOpcodeAddress(), theMethodType.getDescriptorIndex().methodSignature())));
                                continue;
                            }
                            if (theArgumentConstant instanceof BytecodeStringConstant) {
                                thePrimitive = (BytecodeStringConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new StringValue(((BytecodeStringConstant)thePrimitive).getValue().stringValue())));
                                continue;
                            }
                            if (theArgumentConstant instanceof BytecodeLongConstant) {
                                thePrimitive = (BytecodeLongConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.LONG, new LongValue(((BytecodeLongConstant)thePrimitive).getLongValue())));
                                continue;
                            }
                            if (theArgumentConstant instanceof BytecodeIntegerConstant) {
                                thePrimitive = (BytecodeIntegerConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.INT, new LongValue(((BytecodeIntegerConstant)thePrimitive).getIntegerValue())));
                                continue;
                            }
                            if (theArgumentConstant instanceof BytecodeFloatConstant) {
                                thePrimitive = (BytecodeFloatConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.FLOAT, new FloatValue(((BytecodeFloatConstant)thePrimitive).getFloatValue())));
                                continue;
                            }
                            if (theArgumentConstant instanceof BytecodeDoubleConstant) {
                                thePrimitive = (BytecodeDoubleConstant)theArgumentConstant;
                                theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.DOUBLE, new DoubleValue(((BytecodeDoubleConstant)thePrimitive).getDoubleValue())));
                                continue;
                            }
                            if (!(theArgumentConstant instanceof BytecodeMethodHandleConstant)) throw new IllegalStateException("Unsupported argument type : " + theArgumentConstant);
                            BytecodeMethodHandleConstant theMethodHandle = (BytecodeMethodHandleConstant)theArgumentConstant;
                            BytecodeReferenceIndex theReference = theMethodHandle.getReferenceIndex();
                            BytecodeMethodRefConstant theReferenceConstant = (BytecodeMethodRefConstant)theReference.getConstant();
                            theArguments.add(theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new MethodHandleExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromUtf8Constant(theReferenceConstant.getClassIndex().getClassConstant().getConstant()), theReferenceConstant.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue(), theReferenceConstant.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature(), theMethodHandle.getReferenceKind())));
                        }
                        BytecodeTypeRef theLastArgument = theSignature.getArguments()[theSignature.getArguments().length - 1];
                        if (theLastArgument.isArray()) {
                            int theSignatureLength = theSignature.getArguments().length;
                            int theArgumentsLength = theArguments.size();
                            int theVarArgsLength = theArgumentsLength - theSignatureLength + 1;
                            Variable theNewVarargsArray = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewArrayExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(Object.class), new IntegerValue(theVarArgsLength)));
                            for (int i = theSignatureLength - 1; i < theArgumentsLength; ++i) {
                                Value theVariable = (Value)theArguments.get(theSignatureLength - 1);
                                theArguments.remove(theVariable);
                                theInitNode.getExpressions().add(new ArrayStoreExpression(aProgram, theInstruction.getOpcodeAddress(), theVariable.resolveType(), theNewVarargsArray, new IntegerValue(i - theSignatureLength + 1), theVariable));
                            }
                            theArguments.add(theNewVarargsArray);
                        }
                        if ("metafactory".equals(theMethodName = theBootstrapMethodToInvoke.getNameAndTypeIndex().getNameAndType().getNameIndex().getName().stringValue())) {
                            StringValue theLambdaMethodName = (StringValue)((Value)theArguments.get(1)).incomingDataFlows().get(0);
                            MethodTypeExpression theStaticInvocationType = (MethodTypeExpression)((Value)theArguments.get(2)).incomingDataFlows().get(0);
                            MethodTypeExpression theSAMMethodType = (MethodTypeExpression)((Value)theArguments.get(3)).incomingDataFlows().get(0);
                            MethodHandleExpression theImplRef = (MethodHandleExpression)((Value)theArguments.get(4)).incomingDataFlows().get(0);
                            MethodTypeExpression theDynamicInvocationType = (MethodTypeExpression)((Value)theArguments.get(5)).incomingDataFlows().get(0);
                            MethodHandleExpression.AdapterAnnotation theAdaptertInfo = new MethodHandleExpression.AdapterAnnotation(theStaticInvocationType.getSignature(), theDynamicInvocationType.getSignature(), theSAMMethodType.getSignature());
                            theImplRef.setAdapterAnnotation(theAdaptertInfo);
                            switch (theImplRef.getReferenceKind()) {
                                case REF_invokeInterface: {
                                    NewObjectAndConstructExpression theValue = new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeInterfaceCallsite.class), new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}), Arrays.asList((Value)theArguments.get(2), (Value)theArguments.get(4)));
                                    Variable theNewVariable6 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                                    theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable6));
                                    break;
                                }
                                case REF_invokeVirtual: {
                                    NewObjectAndConstructExpression theValue = new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeVirtualCallsite.class), new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}), Arrays.asList((Value)theArguments.get(2), (Value)theArguments.get(4)));
                                    Variable theNewVariable6 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                                    theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable6));
                                    break;
                                }
                                case REF_invokeSpecial: {
                                    NewObjectAndConstructExpression theValue = new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(VM.InvokeSpecialCallsite.class), new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}), Arrays.asList((Value)theArguments.get(2), (Value)theArguments.get(4)));
                                    Variable theNewVariable6 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                                    theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable6));
                                    break;
                                }
                                case REF_invokeStatic: {
                                    NewObjectAndConstructExpression theValue = new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(VM.LambdaStaticImplCallsite.class), new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(String.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}), Arrays.asList((Value)theArguments.get(1), (Value)theArguments.get(2), (Value)theArguments.get(4)));
                                    Variable theNewVariable6 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                                    theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable6));
                                    break;
                                }
                                case REF_newInvokeSpecial: {
                                    MethodTypeExpression theConstructorType = (MethodTypeExpression)((Value)theArguments.get(5)).incomingDataFlows().get(0);
                                    BytecodeMethodSignature theConstructorSignature = theConstructorType.getSignature();
                                    BytecodeObjectTypeRef theClassToInstantiate = (BytecodeObjectTypeRef)theConstructorSignature.getReturnType();
                                    BytecodeMethodSignature theInvocationSignature = new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, theConstructorSignature.getArguments());
                                    MethodHandleExpression theConstructorMethodRef = new MethodHandleExpression(aProgram, theInitNode.getStartAddress(), theClassToInstantiate, "<init>", theInvocationSignature, BytecodeReferenceKind.REF_newInvokeSpecial);
                                    theConstructorMethodRef.setAdapterAnnotation(theAdaptertInfo);
                                    Variable theConstructorMethodRefVariable = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theConstructorMethodRef);
                                    NewObjectAndConstructExpression theValue = new NewObjectAndConstructExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(VM.LambdaConstructorRefCallsite.class), new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{BytecodeObjectTypeRef.fromRuntimeClass(MethodType.class), BytecodeObjectTypeRef.fromRuntimeClass(MethodHandle.class)}), Arrays.asList((Value)theArguments.get(2), theConstructorMethodRefVariable));
                                    Variable theNewVariable7 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                                    theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable7));
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException((Object)((Object)theImplRef.getReferenceKind()) + " not supported for lambda " + theLambdaMethodName.getStringValue() + " -> " + (Object)((Object)theImplRef.getReferenceKind()) + " statictype = " + theStaticInvocationType.getSignature() + ", dynamictype = " + theDynamicInvocationType.getSignature());
                                }
                            }
                        } else {
                            InvokeStaticMethodExpression theInvokeStaticValue = new InvokeStaticMethodExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromUtf8Constant(theBootstrapMethodToInvoke.getClassIndex().getClassConstant().getConstant()), theMethodName, theBootstrapMethodToInvoke.getNameAndTypeIndex().getNameAndType().getDescriptorIndex().methodSignature(), theArguments);
                            Variable theNewVariable8 = theInitNode.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theInvokeStaticValue);
                            theInitNode.getExpressions().add(new ReturnValueExpression(aProgram, theInstruction.getOpcodeAddress(), theNewVariable8));
                        }
                        ResolveCallsiteObjectExpression theValue = new ResolveCallsiteObjectExpression(theInstruction.getOpcodeAddress(), aOwningClass.getThisInfo().getConstant().stringValue() + "_" + aMethod.getName().stringValue() + "_" + theINS.getOpcodeAddress().getAddress(), aOwningClass, theProgram, theInitNode);
                        Variable theCallsiteVariable = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, theValue);
                        ArrayList<Value> theInvokeArguments = new ArrayList<Value>();
                        Variable theArray = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.Native.REFERENCE, new NewArrayExpression(aProgram, theInstruction.getOpcodeAddress(), BytecodeObjectTypeRef.fromRuntimeClass(Object.class), new IntegerValue(bytecodeMethodSignature.getArguments().length)));
                        for (int i = bytecodeMethodSignature.getArguments().length - 1; i >= 0; --i) {
                            IntegerValue theIndex = new IntegerValue(i);
                            Value theStoredValue = aHelper.pop();
                            aTargetBlock.getExpressions().add(new ArrayStoreExpression(aProgram, theInstruction.getOpcodeAddress(), theStoredValue.resolveType(), theArray, theIndex, theStoredValue));
                        }
                        theInvokeArguments.add(theArray);
                        InvokeVirtualMethodExpression theInvokeValue = new InvokeVirtualMethodExpression(aProgram, theInstruction.getOpcodeAddress(), "invokeExact", new BytecodeMethodSignature(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodeObjectTypeRef.fromRuntimeClass(Object.class), 1)}), theCallsiteVariable, theInvokeArguments, false, BytecodeObjectTypeRef.fromRuntimeClass(CallSite.class));
                        Variable theInvokeExactResult = aTargetBlock.newVariable(theInstruction.getOpcodeAddress(), TypeRef.toType(bytecodeMethodSignature.getReturnType()), theInvokeValue);
                        aHelper.push(theINS.getOpcodeAddress(), theInvokeExactResult);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Nut supported reference kind for invoke dynamic : " + (Object)((Object)theMethodRef.getReferenceKind()));
                    }
                }
            }
            aProgram.incrementAnalysisTime();
        }
        aTargetBlock.setFinishedAnalysisTime(aProgram.getAnalysisTime());
    }
}

