/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeReferenceKind;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.TypeRef;

public class MethodHandleExpression
extends Expression {
    private final BytecodeObjectTypeRef className;
    private final String methodName;
    private final BytecodeMethodSignature implementationSignature;
    private final BytecodeReferenceKind referenceKind;
    private AdapterAnnotation adapterAnnotation;

    public MethodHandleExpression(Program aProgram, BytecodeOpcodeAddress aAddress, BytecodeObjectTypeRef className, String methodName, BytecodeMethodSignature implementationSignature, BytecodeReferenceKind referenceKind) {
        super(aProgram, aAddress);
        this.className = className;
        this.methodName = methodName;
        this.implementationSignature = implementationSignature;
        this.referenceKind = referenceKind;
    }

    public BytecodeReferenceKind getReferenceKind() {
        return this.referenceKind;
    }

    public BytecodeObjectTypeRef getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public BytecodeMethodSignature getImplementationSignature() {
        return this.implementationSignature;
    }

    public AdapterAnnotation getAdapterAnnotation() {
        return this.adapterAnnotation;
    }

    public void setAdapterAnnotation(AdapterAnnotation aAdapterAnnotation) {
        this.adapterAnnotation = aAdapterAnnotation;
    }

    @Override
    public TypeRef resolveType() {
        return TypeRef.Native.REFERENCE;
    }

    public static class AdapterAnnotation {
        private final BytecodeMethodSignature linkageSignature;
        private final BytecodeMethodSignature captureSignature;
        private final BytecodeMethodSignature samMethodType;

        public AdapterAnnotation(BytecodeMethodSignature linkageSignature, BytecodeMethodSignature captureSignature, BytecodeMethodSignature samMethodType) {
            this.linkageSignature = linkageSignature;
            this.captureSignature = captureSignature;
            this.samMethodType = samMethodType;
        }

        public BytecodeMethodSignature getLinkageSignature() {
            return this.linkageSignature;
        }

        public BytecodeMethodSignature getCaptureSignature() {
            return this.captureSignature;
        }

        public BytecodeMethodSignature getSamMethodType() {
            return this.samMethodType;
        }
    }
}

