/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LookupSwitchExpression
extends Expression
implements ExpressionListContainer {
    private final ExpressionList defaultExpressions;
    private final BytecodeOpcodeAddress defaultJumpTarget;
    private final Map<Long, ExpressionList> pairs;

    public LookupSwitchExpression(Program aProgram, BytecodeOpcodeAddress aAddress, Value aValue, ExpressionList aDefaultExpressions, BytecodeOpcodeAddress aDefaultJumpTarget, Map<Long, ExpressionList> aPairs) {
        super(aProgram, aAddress);
        this.defaultExpressions = aDefaultExpressions;
        this.defaultJumpTarget = aDefaultJumpTarget;
        this.pairs = aPairs;
        this.receivesDataFrom(aValue);
    }

    public ExpressionList getDefaultExpressions() {
        return this.defaultExpressions;
    }

    public BytecodeOpcodeAddress getDefaultJumpTarget() {
        return this.defaultJumpTarget;
    }

    public Map<Long, ExpressionList> getPairs() {
        return this.pairs;
    }

    @Override
    public Set<ExpressionList> getExpressionLists() {
        HashSet<ExpressionList> theResult = new HashSet<ExpressionList>();
        theResult.add(this.defaultExpressions);
        theResult.addAll(this.pairs.values());
        return theResult;
    }

    @Override
    public Expression deepCopy() {
        HashMap<Long, ExpressionList> thePairs = new HashMap<Long, ExpressionList>();
        for (Map.Entry<Long, ExpressionList> theEntry : this.pairs.entrySet()) {
            thePairs.put(theEntry.getKey(), theEntry.getValue().deepCopy());
        }
        return new LookupSwitchExpression(this.getProgram(), this.getAddress(), (Value)this.incomingDataFlows().get(0), this.defaultExpressions.deepCopy(), this.defaultJumpTarget, thePairs);
    }
}

