/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeNameAndTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.ssa.InvocationExpression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.List;

public class InvokeVirtualMethodExpression
extends InvocationExpression {
    private final String methodName;
    private final boolean interfaceInvocation;
    private final BytecodeTypeRef invokedClass;

    public InvokeVirtualMethodExpression(Program aProgram, BytecodeOpcodeAddress aAddress, BytecodeNameAndTypeConstant aMethod, Value aTarget, List<Value> aArguments, boolean aInterfaceInvocation, BytecodeTypeRef aInvokedClass) {
        this(aProgram, aAddress, aMethod.getNameIndex().getName().stringValue(), aMethod.getDescriptorIndex().methodSignature(), aTarget, aArguments, aInterfaceInvocation, aInvokedClass);
    }

    public InvokeVirtualMethodExpression(Program aProgram, BytecodeOpcodeAddress aAddress, String aMethodName, BytecodeMethodSignature aSignature, Value aTarget, List<Value> aArguments, boolean aInterfaceInvocation, BytecodeTypeRef aInvokedClass) {
        super(aProgram, aAddress, aSignature);
        this.methodName = aMethodName;
        this.interfaceInvocation = aInterfaceInvocation;
        this.invokedClass = aInvokedClass;
        this.receivesDataFrom(aTarget);
        this.receivesDataFrom(aArguments);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isInterfaceInvocation() {
        return this.interfaceInvocation;
    }

    public BytecodeTypeRef getInvokedClass() {
        return this.invokedClass;
    }
}

