/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.HashSet;
import java.util.Set;

public class IFExpression
extends Expression
implements ExpressionListContainer {
    private final ExpressionList expressions;
    private final BytecodeOpcodeAddress gotoAddress;

    public IFExpression(Program aProgram, BytecodeOpcodeAddress aAddress, BytecodeOpcodeAddress aGotoAddress, Value aBooleanValue, ExpressionList aExpressions) {
        super(aProgram, aAddress);
        this.expressions = aExpressions;
        this.gotoAddress = aGotoAddress;
        this.receivesDataFrom(aBooleanValue);
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    @Override
    public Set<ExpressionList> getExpressionLists() {
        HashSet<ExpressionList> theResult = new HashSet<ExpressionList>();
        theResult.add(this.expressions);
        return theResult;
    }

    public BytecodeOpcodeAddress getGotoAddress() {
        return this.gotoAddress;
    }

    @Override
    public Expression deepCopy() {
        return new IFExpression(this.getProgram(), this.getAddress(), this.gotoAddress, (Value)this.incomingDataFlows().get(0), this.expressions.deepCopy());
    }
}

