/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.Program;
import java.util.Collections;
import java.util.Set;

public class IFElseExpression
extends Expression
implements ExpressionListContainer {
    private final IFExpression condition;
    private final ExpressionList elsePart;

    public IFElseExpression(Program program, BytecodeOpcodeAddress address, IFExpression condition, ExpressionList elsePart) {
        super(program, address);
        this.condition = condition;
        this.elsePart = elsePart;
    }

    public IFExpression getCondition() {
        return this.condition;
    }

    public ExpressionList getElsePart() {
        return this.elsePart;
    }

    @Override
    public Set<ExpressionList> getExpressionLists() {
        return Collections.singleton(this.elsePart);
    }

    @Override
    public Expression deepCopy() {
        return new IFElseExpression(this.getProgram(), this.getAddress(), (IFExpression)this.condition.deepCopy(), this.elsePart.deepCopy());
    }
}

