/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.LookupSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ReturnExpression;
import de.mirkosertic.bytecoder.ssa.ReturnValueExpression;
import de.mirkosertic.bytecoder.ssa.TableSwitchExpression;
import de.mirkosertic.bytecoder.ssa.ThrowExpression;
import java.util.ArrayList;
import java.util.List;

public class ExpressionList {
    private final List<Expression> expressions = new ArrayList<Expression>();

    public void add(Expression aExpression) {
        this.expressions.add(aExpression);
    }

    public List<Expression> toList() {
        return new ArrayList<Expression>(this.expressions);
    }

    public int size() {
        return this.expressions.size();
    }

    public Expression lastExpression() {
        if (this.expressions.isEmpty()) {
            return null;
        }
        int theLastIndex = this.expressions.size() - 1;
        return this.expressions.get(theLastIndex);
    }

    public void addBefore(Expression aNewExpression, Expression aTarget) {
        this.expressions.add(this.expressions.indexOf(aTarget), aNewExpression);
    }

    public void replace(Expression aExpressionToReplace, Expression aNewExpression) {
        int p = this.expressions.indexOf(aExpressionToReplace);
        if (p >= 0) {
            this.expressions.remove(p);
            this.expressions.add(p, aNewExpression);
        }
    }

    public void replace(Expression aExpressionToReplace, ExpressionList aList) {
        int p = this.expressions.indexOf(aExpressionToReplace);
        if (p >= 0) {
            this.expressions.remove(p);
            List<Expression> theList = aList.toList();
            for (int i = theList.size() - 1; i >= 0; --i) {
                this.expressions.add(p, theList.get(i));
            }
        }
    }

    public void remove(Expression aExpression) {
        this.expressions.remove(aExpression);
    }

    public Expression predecessorOf(Expression aExpression) {
        int p = this.expressions.indexOf(aExpression);
        if (p > 0) {
            return this.expressions.get(p - 1);
        }
        return null;
    }

    public boolean endWithNeverReturningExpression() {
        Expression theLastExpression = this.lastExpression();
        return theLastExpression instanceof ReturnExpression || theLastExpression instanceof ReturnValueExpression || theLastExpression instanceof TableSwitchExpression || theLastExpression instanceof LookupSwitchExpression || theLastExpression instanceof ThrowExpression || theLastExpression instanceof GotoExpression;
    }

    public boolean endsWithReturn() {
        Expression theLastExpression = this.lastExpression();
        return theLastExpression instanceof ReturnExpression || theLastExpression instanceof ReturnValueExpression;
    }

    public ExpressionList deepCopy() {
        ExpressionList theList = new ExpressionList();
        for (Expression theExpression : this.expressions) {
            if (theExpression instanceof ExpressionListContainer) {
                ExpressionListContainer theContainer = (ExpressionListContainer)((Object)theExpression);
                theList.add(theContainer.deepCopy());
                continue;
            }
            theList.add(theExpression);
        }
        return theList;
    }
}

