/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeLineNumberTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.DebugPosition;

public abstract class DebugInformation {
    public static DebugInformation empty() {
        return new DebugInformation(){

            @Override
            public DebugPosition debugPositionFor(BytecodeOpcodeAddress aAddress) {
                return null;
            }

            @Override
            public String originalFileName() {
                return null;
            }
        };
    }

    public static DebugInformation jvm(final String aOriginalFileName, final BytecodeLineNumberTableAttributeInfo aLineNumberInfo) {
        return new DebugInformation(){

            @Override
            public DebugPosition debugPositionFor(BytecodeOpcodeAddress aAddress) {
                BytecodeLineNumberTableAttributeInfo.Entry[] theEntries;
                for (BytecodeLineNumberTableAttributeInfo.Entry theEntry : theEntries = aLineNumberInfo.getEntries()) {
                    if (theEntry.getStartPc() != aAddress.getAddress()) continue;
                    return new DebugPosition(aOriginalFileName, theEntry.getLineNumber() - 1);
                }
                return null;
            }

            @Override
            public String originalFileName() {
                return aOriginalFileName;
            }
        };
    }

    public abstract DebugPosition debugPositionFor(BytecodeOpcodeAddress var1);

    public abstract String originalFileName();
}

