/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class ControlFlowGraphSCC {
    private final List<List<RegionNode>> connectedComponentList = new ArrayList<List<RegionNode>>();
    private int time = 0;
    private final Map<RegionNode, Integer> lowLink;
    private final Set<RegionNode> visited;
    private final Stack<RegionNode> stack;
    private final List<RegionNode> nodesInOrder = new ArrayList<RegionNode>();

    public ControlFlowGraphSCC(ControlFlowGraph g) {
        this.lowLink = new HashMap<RegionNode, Integer>();
        this.visited = new HashSet<RegionNode>();
        this.stack = new Stack();
        for (RegionNode node : g.dominators().getPreOrder()) {
            if (this.visited.contains(node)) continue;
            this.dfs(node);
        }
        for (int i = this.connectedComponentList.size() - 1; i >= 0; --i) {
            List<RegionNode> l = this.connectedComponentList.get(i);
            for (int j = l.size() - 1; j >= 0; --j) {
                this.nodesInOrder.add(l.get(j));
            }
        }
    }

    private void dfs(RegionNode vertex) {
        this.lowLink.put(vertex, this.time++);
        this.visited.add(vertex);
        this.stack.push(vertex);
        boolean isComponentRoot = true;
        List successors = vertex.outgoingEdges().filter(t -> ((RegionNode)t.targetNode()).getType() == RegionNode.BlockType.NORMAL).map(Edge::targetNode).sorted((o1, o2) -> Integer.compare(o2.getStartAddress().getAddress(), o1.getStartAddress().getAddress())).collect(Collectors.toList());
        for (RegionNode v : successors) {
            if (!this.visited.contains(v)) {
                this.dfs(v);
            }
            if (this.lowLink.get(vertex) <= this.lowLink.get(v)) continue;
            this.lowLink.put(vertex, this.lowLink.get(v));
            isComponentRoot = false;
        }
        if (isComponentRoot) {
            RegionNode actualVertex;
            ArrayList<RegionNode> component = new ArrayList<RegionNode>();
            do {
                actualVertex = this.stack.pop();
                component.add(actualVertex);
                this.lowLink.put(actualVertex, Integer.MAX_VALUE);
            } while (actualVertex != vertex);
            this.connectedComponentList.add(component);
        }
    }

    public List<List<RegionNode>> getConnectedComponentList() {
        return this.connectedComponentList;
    }

    public List<RegionNode> getNodesInOrder() {
        return this.nodesInOrder;
    }
}

