/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.graph.Dominators;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.PrimitiveValue;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import de.mirkosertic.bytecoder.ssa.Variable;
import de.mirkosertic.bytecoder.ssa.VariableAssignmentExpression;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ControlFlowGraph {
    private final List<RegionNode> knownNodes;
    private final Program program;
    private Dominators<RegionNode> dominators;
    private Dominators<RegionNode> regularFlowDominators;

    public ControlFlowGraph(Program aProgram) {
        this.program = aProgram;
        this.knownNodes = new ArrayList<RegionNode>();
    }

    public Program getProgram() {
        return this.program;
    }

    public Dominators<RegionNode> dominators() {
        return this.dominators;
    }

    public boolean dominates(RegionNode dominator, RegionNode dominated) {
        return this.dominators.dominates(dominator, dominated);
    }

    public boolean dominatesInRegularFlowOnly(RegionNode node, RegionNode targetNode) {
        return this.regularFlowDominators.dominates(node, targetNode);
    }

    public void calculateReachabilityAndMarkBackEdges() {
        Stack<RegionNode> currentPath = new Stack<RegionNode>();
        this.calculateReachabilityAndMarkBackEdges(currentPath, this.startNode(), new HashSet<RegionNode>());
        this.dominators = new Dominators<RegionNode>(this.startNode(), RegionNode.NODE_COMPARATOR);
        this.regularFlowDominators = new Dominators<RegionNode>(this.startNode(), RegionNode.NODE_COMPARATOR, t -> ((RegionNode)t.targetNode()).getType() == RegionNode.BlockType.NORMAL);
    }

    private void calculateReachabilityAndMarkBackEdges(Stack<RegionNode> aCurrentPath, RegionNode aNode, Set<RegionNode> aVisited) {
        if (aVisited.add(aNode)) {
            aCurrentPath.push(aNode);
            for (Edge theEdge : aNode.outgoingEdges().collect(Collectors.toList())) {
                RegionNode theTarget = (RegionNode)theEdge.targetNode();
                if (aCurrentPath.contains(theTarget)) {
                    theEdge.newTypeIs(ControlFlowEdgeType.back);
                    continue;
                }
                this.calculateReachabilityAndMarkBackEdges(aCurrentPath, theTarget, aVisited);
            }
            aCurrentPath.pop();
        }
    }

    public RegionNode createAt(BytecodeOpcodeAddress aAddress, RegionNode.BlockType aType) {
        RegionNode theNewBlock = new RegionNode(this, aType, this.program, aAddress);
        this.knownNodes.add(theNewBlock);
        return theNewBlock;
    }

    public RegionNode startNode() {
        return this.nodeStartingAt(BytecodeOpcodeAddress.START_AT_ZERO);
    }

    public RegionNode nodeStartingAt(BytecodeOpcodeAddress aAddress) {
        for (RegionNode theBlock : this.knownNodes) {
            if (!Objects.equals(aAddress, theBlock.getStartAddress())) continue;
            return theBlock;
        }
        throw new IllegalArgumentException("Unknown address : " + aAddress.getAddress());
    }

    public List<RegionNode.ExceptionHandler> exceptionHandlersStartingAt(BytecodeOpcodeAddress aAddress) {
        ArrayList<RegionNode.ExceptionHandler> theHandler = new ArrayList<RegionNode.ExceptionHandler>();
        BytecodeProgram.FlowInformation theFlowinfo = this.program.getFlowInformation();
        if (theFlowinfo != null) {
            BytecodeProgram theBytecode = theFlowinfo.getProgram();
            for (BytecodeExceptionTableEntry theEntry : theBytecode.getExceptionHandlers()) {
                if (!theEntry.getStartPC().equals(aAddress) || theEntry.isFinally()) continue;
                RegionNode.ExceptionHandler theMatchingHandler = null;
                for (RegionNode.ExceptionHandler theExisting : theHandler) {
                    if (!theExisting.regionMatchesTo(theEntry)) continue;
                    theMatchingHandler = theExisting;
                }
                if (theMatchingHandler == null) {
                    theMatchingHandler = new RegionNode.ExceptionHandler(theEntry.getStartPC(), theEntry.getEndPc());
                    theHandler.add(theMatchingHandler);
                }
                theMatchingHandler.addCatchEntry(theEntry);
            }
        }
        theHandler.sort((o1, o2) -> Integer.compare(o2.getEndPC().getAddress(), o1.getEndPC().getAddress()));
        return theHandler;
    }

    public boolean isImmediatelyDominatedBy(RegionNode aDominator, RegionNode aNode) {
        return this.dominators.getIDom(aNode) == aDominator;
    }

    public String toDOT() {
        final IDRegister theRegister = new IDRegister();
        final ArrayList theJumps = new ArrayList();
        StringWriter theStr = new StringWriter();
        try (final PrintWriter thePW = new PrintWriter(theStr);){
            final HashSet theAllValues = new HashSet();
            thePW.println("digraph CFG {");
            Consumer<DotContext> theExpressionConsumer = new Consumer<DotContext>(){

                @Override
                public void accept(DotContext aContext) {
                    List<Expression> theExpressios = aContext.expressionList.toList();
                    for (Expression theExpression : theExpressios) {
                        theAllValues.add(theExpression);
                        String theNodeName = theRegister.idFor(theExpression);
                        thePW.print("       ");
                        thePW.print(aContext.owningNodeName);
                        thePW.print(" -> E_");
                        thePW.print(theNodeName);
                        thePW.print("[style=dotted,color=blue,label=\"e-");
                        thePW.print(theExpressios.indexOf(theExpression));
                        thePW.println("\"];");
                        this.printIncomingValues(theExpression, "E_" + theNodeName);
                        if (theExpression instanceof GotoExpression) {
                            GotoExpression theGoto = (GotoExpression)theExpression;
                            RegionNode theJumpTarget = ControlFlowGraph.this.nodeStartingAt(theGoto.jumpTarget());
                            String theJumpTargetRegion = theRegister.idFor(theJumpTarget);
                            theJumps.add(new DotJump("E_" + theNodeName, "C_" + theJumpTargetRegion + "_control", aContext.regionNode.hasBackEdgeTo(theJumpTarget)));
                        }
                        if (!(theExpression instanceof ExpressionListContainer)) continue;
                        ExpressionListContainer theList = (ExpressionListContainer)((Object)theExpression);
                        for (ExpressionList theCont : theList.getExpressionLists()) {
                            DotContext theContext = new DotContext(aContext.regionNode, theCont, "E_" + theNodeName);
                            this.accept(theContext);
                        }
                    }
                }

                private void printIncomingValues(Value aValue, String aReceivingNodeID) {
                    if (aValue instanceof VariableAssignmentExpression) {
                        VariableAssignmentExpression theAssignment = (VariableAssignmentExpression)aValue;
                        Variable theTarget = theAssignment.getVariable();
                        theAllValues.add(theTarget);
                        thePW.print("       ");
                        thePW.print(aReceivingNodeID);
                        thePW.print(" -> V_");
                        thePW.print(theRegister.idFor(theTarget));
                        thePW.println(";");
                        Value theValue = (Value)theAssignment.incomingDataFlows().get(0);
                        theAllValues.add(theValue);
                        String theValueID = null;
                        if (theValue instanceof Expression) {
                            theValueID = "E_" + theRegister.idFor(theValue);
                        }
                        if (theValue instanceof PrimitiveValue) {
                            theValueID = "P_" + theRegister.idFor(theValue);
                        }
                        if (theValue instanceof Variable) {
                            theValueID = "V_" + theRegister.idFor(theValue);
                        }
                        thePW.print("       ");
                        thePW.print(theValueID);
                        thePW.print(" -> ");
                        thePW.print(aReceivingNodeID);
                        thePW.println(";");
                        if (theValue instanceof Expression) {
                            this.printIncomingValues(theValue, theValueID);
                        }
                    } else {
                        List theIncomingDataFlows = aValue.incomingDataFlows();
                        for (Value theValue : theIncomingDataFlows) {
                            theAllValues.add(theValue);
                            String theValueID = null;
                            if (theValue instanceof Expression) {
                                theValueID = "E_" + theRegister.idFor(theValue);
                            }
                            if (theValue instanceof PrimitiveValue) {
                                theValueID = "P_" + theRegister.idFor(theValue);
                            }
                            if (theValue instanceof Variable) {
                                theValueID = "V_" + theRegister.idFor(theValue);
                            }
                            thePW.print("       ");
                            thePW.print(theValueID);
                            thePW.print(" -> ");
                            thePW.print(aReceivingNodeID);
                            thePW.println(";");
                            if (!(theValue instanceof Expression)) continue;
                            this.printIncomingValues(theValue, theValueID);
                        }
                    }
                }
            };
            for (RegionNode theRegion : this.knownNodes) {
                String theRegionID = theRegister.idFor(theRegion);
                thePW.print("   subgraph cluster_");
                thePW.print(theRegionID);
                thePW.println(" {");
                thePW.print("       label=\"Region Address ");
                thePW.print(theRegion.getStartAddress().getAddress());
                thePW.println("\";");
                thePW.println("       style=filled;");
                switch (theRegion.getType()) {
                    case NORMAL: {
                        thePW.println("       color=lightgray;");
                        break;
                    }
                    case EXCEPTION_HANDLER: {
                        thePW.println("       color=lightsalmon;");
                        break;
                    }
                    case FINALLY: {
                        thePW.println("       color=goldenrod;");
                    }
                }
                thePW.println();
                thePW.print("       C_");
                thePW.print(theRegionID);
                thePW.println("_control [shape=box, label=\"Control\"];");
                DotContext theContext = new DotContext(theRegion, theRegion.getExpressions(), "C_" + theRegionID + "_control");
                theExpressionConsumer.accept(theContext);
                thePW.println("   }");
            }
            for (Value theValue : theAllValues) {
                String theNodeID = theRegister.idFor(theValue);
                thePW.print("   ");
                if (theValue instanceof Expression) {
                    thePW.print("E_");
                }
                if (theValue instanceof PrimitiveValue) {
                    thePW.print("P_");
                }
                if (theValue instanceof Variable) {
                    thePW.print("V_");
                }
                thePW.print(theNodeID);
                thePW.print("[");
                if (theValue instanceof Expression) {
                    Expression theValueExpression = (Expression)theValue;
                    thePW.print("label=\"");
                    thePW.print(theValueExpression.getClass().getSimpleName().replace("Expression", ""));
                    thePW.print("\"");
                }
                if (theValue instanceof PrimitiveValue) {
                    PrimitiveValue thePrimitive = (PrimitiveValue)theValue;
                    thePW.print("label=\"");
                    thePW.print(thePrimitive.getClass().getSimpleName().replace("Value", ""));
                    thePW.print("\",color=orange");
                }
                if (theValue instanceof Variable) {
                    Variable theVariable = (Variable)theValue;
                    thePW.print("label=\"");
                    thePW.print(theVariable.getName());
                    thePW.print("\",color=green");
                }
                thePW.println("];");
            }
            for (DotJump theJump : theJumps) {
                thePW.print("   ");
                thePW.print(theJump.source);
                thePW.print(" -> ");
                thePW.print(theJump.target);
                if (theJump.backEdge) {
                    thePW.println(" [label=\"back-edge\",color=blue,style=dotted];");
                    continue;
                }
                thePW.println("[color=blue,style=dotted];");
            }
            thePW.println("}");
        }
        return theStr.toString();
    }

    protected Set<RegionNode> dominatedNodesOf(RegionNode aNode) {
        return this.dominators.domSetOf(aNode);
    }

    static class DotJump {
        final String source;
        final String target;
        final boolean backEdge;

        public DotJump(String aSource, String aTarget, boolean aBackEdge) {
            this.source = aSource;
            this.target = aTarget;
            this.backEdge = aBackEdge;
        }
    }

    static class DotContext {
        final RegionNode regionNode;
        final ExpressionList expressionList;
        final String owningNodeName;

        public DotContext(RegionNode aRegionNode, ExpressionList aExpressionList, String aOwningNodeName) {
            this.regionNode = aRegionNode;
            this.expressionList = aExpressionList;
            this.owningNodeName = aOwningNodeName;
        }
    }

    private static class IDRegister {
        private final List<Object> objects = new ArrayList<Object>();

        public String idFor(Object aObject) {
            if (!this.objects.contains(aObject)) {
                this.objects.add(aObject);
            }
            return "" + this.objects.indexOf(aObject);
        }
    }
}

