/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ClassHierarchyAnalysis {
    private final BytecodeLinkerContext linkerContext;

    public ClassHierarchyAnalysis(BytecodeLinkerContext linkerContext) {
        this.linkerContext = linkerContext;
    }

    public Optional<BytecodeLinkedClass> classProvidingInvokableMethod(String aMethodName, BytecodeMethodSignature aSignature, BytecodeTypeRef aInvocationTarget, Value aReceiver, Predicate<BytecodeLinkedClass> aClassFilter, Predicate<BytecodeMethod> aMethodFilter) {
        BytecodeLinkedClass theInvocationTarget = aInvocationTarget.isArray() ? this.linkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class)) : this.linkerContext.resolveClass((BytecodeObjectTypeRef)aInvocationTarget);
        if (aClassFilter.test(theInvocationTarget)) {
            if (theInvocationTarget.getBytecodeClass().getAccessFlags().isFinal()) {
                for (BytecodeLinkedClass theCurrent = theInvocationTarget; theCurrent != null; theCurrent = theCurrent.getSuperClass()) {
                    BytecodeMethod m = theCurrent.getBytecodeClass().methodByNameAndSignatureOrNull(aMethodName, aSignature);
                    if (m == null || !aMethodFilter.test(m)) continue;
                    return Optional.of(theCurrent);
                }
                return Optional.empty();
            }
            HashSet theResult = new HashSet();
            this.linkerContext.linkedClasses().map(Edge::targetNode).filter(aClassFilter).filter(t -> {
                Set<BytecodeLinkedClass> theImplementingTypes = t.getImplementingTypes();
                return theImplementingTypes.contains(theInvocationTarget);
            }).forEach(clz -> {
                for (BytecodeLinkedClass theCurrent = clz; theCurrent != null; theCurrent = theCurrent.getSuperClass()) {
                    BytecodeMethod m = theCurrent.getBytecodeClass().methodByNameAndSignatureOrNull(aMethodName, aSignature);
                    if (m == null || !aMethodFilter.test(m)) continue;
                    theResult.add(theCurrent);
                    break;
                }
            });
            if (theResult.size() == 1) {
                return Optional.of(theResult.iterator().next());
            }
            if (theResult.size() > 1) {
                // empty if block
            }
        }
        return Optional.empty();
    }
}

