/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.Label;
import de.mirkosertic.bytecoder.ssa.Program;

public class BreakExpression
extends Expression {
    private final Label blockToBreak;
    private final BytecodeOpcodeAddress jumpTarget;
    private boolean silent;
    private boolean setLabelRequired;
    private boolean jumpLabelRequired;

    public BreakExpression(Program aProgram, BytecodeOpcodeAddress aAddress, Label aBlockToBreak, BytecodeOpcodeAddress aJumpTarget) {
        super(aProgram, aAddress);
        this.blockToBreak = aBlockToBreak;
        this.jumpTarget = aJumpTarget;
        this.silent = false;
        this.setLabelRequired = true;
        this.jumpLabelRequired = true;
    }

    public void noSetRequired() {
        this.setLabelRequired = false;
    }

    public void silent() {
        this.silent = true;
    }

    public boolean isSetLabelRequired() {
        return this.setLabelRequired;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Label blockToBreak() {
        return this.blockToBreak;
    }

    public boolean isJumpLabelRequired() {
        return this.jumpLabelRequired;
    }

    public void noJumpLabelRequired() {
        this.jumpLabelRequired = false;
    }

    public BytecodeOpcodeAddress jumpTarget() {
        return this.jumpTarget;
    }
}

