/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.ssa;

import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.Program;
import de.mirkosertic.bytecoder.ssa.TypeRef;
import de.mirkosertic.bytecoder.ssa.Value;

public class BinaryExpression
extends Expression {
    private final Operator operator;
    private final TypeRef targetType;

    public BinaryExpression(Program aProgram, BytecodeOpcodeAddress aAddress, TypeRef aTargetType, Value aValue1, Operator aOperator, Value aValue2) {
        super(aProgram, aAddress);
        this.operator = aOperator;
        this.targetType = aTargetType;
        this.receivesDataFrom(aValue1, aValue2);
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public TypeRef resolveType() {
        return this.targetType;
    }

    public static enum Operator {
        EQUALS,
        LESSTHAN,
        GREATERTHAN,
        GREATEROREQUALS,
        LESSTHANOREQUALS,
        NOTEQUALS,
        ADD,
        SUB,
        DIV,
        MUL,
        REMAINDER,
        BINARYXOR,
        BINARYOR,
        BINARYAND,
        BINARYSHIFTLEFT,
        BINARYUNSIGNEDSHIFTRIGHT,
        BINARYSHIFTRIGHT;

    }
}

