/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.relooper;

import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import de.mirkosertic.bytecoder.graph.Edge;
import de.mirkosertic.bytecoder.ssa.BreakExpression;
import de.mirkosertic.bytecoder.ssa.ContinueExpression;
import de.mirkosertic.bytecoder.ssa.ControlFlowEdgeType;
import de.mirkosertic.bytecoder.ssa.ControlFlowGraph;
import de.mirkosertic.bytecoder.ssa.Expression;
import de.mirkosertic.bytecoder.ssa.ExpressionList;
import de.mirkosertic.bytecoder.ssa.ExpressionListContainer;
import de.mirkosertic.bytecoder.ssa.GotoExpression;
import de.mirkosertic.bytecoder.ssa.IFExpression;
import de.mirkosertic.bytecoder.ssa.Label;
import de.mirkosertic.bytecoder.ssa.RegionNode;
import de.mirkosertic.bytecoder.ssa.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class Relooper {
    private final CompileOptions compileOptions;

    public Relooper(CompileOptions aCompileOptions) {
        this.compileOptions = aCompileOptions;
    }

    public Block reloop(ControlFlowGraph aGraph) {
        HashSet<RegionNode> theEntries = new HashSet<RegionNode>();
        RegionNode theStart = aGraph.startNode();
        theEntries.add(aGraph.startNode());
        Block theBlock = this.reloop(aGraph, theEntries, theStart.dominatedNodes());
        this.replaceGotosIn(theBlock);
        return theBlock;
    }

    private void replaceGotosIn(Block aBlock) {
        this.replaceGotosIn(new Stack<Block>(), aBlock);
    }

    private void replaceGotosIn(Stack<Block> aTraversalStack, Block aBlock) {
        if (aBlock == null) {
            return;
        }
        if (aBlock instanceof TryBlock) {
            TryBlock theTry = (TryBlock)aBlock;
            aTraversalStack.push(theTry);
            this.replaceGotosIn(aTraversalStack, theTry.inner());
            if (theTry.finallyBlock != null) {
                this.replaceGotosIn(aTraversalStack, theTry.finallyBlock);
            }
            for (TryBlock.CatchBlock theCatch : theTry.catchBlocks) {
                this.replaceGotosIn(aTraversalStack, theCatch.handler);
            }
            aTraversalStack.pop();
            this.replaceGotosIn(aTraversalStack, theTry.next());
            return;
        }
        if (aBlock instanceof SimpleBlock) {
            BreakExpression theBreak;
            SimpleBlock theSimple = (SimpleBlock)aBlock;
            aTraversalStack.push(theSimple);
            RegionNode theInternalLabel = theSimple.internalLabel();
            this.replaceGotosIn(aTraversalStack, theSimple, theInternalLabel, theSimple.expressions());
            this.replaceGotosIn(aTraversalStack, theSimple.next());
            aTraversalStack.pop();
            Expression theLastExpression = theSimple.expressions().lastExpression();
            if (theLastExpression instanceof BreakExpression && Objects.equals((theBreak = (BreakExpression)theLastExpression).blockToBreak().name(), theSimple.label().name())) {
                theBreak.silent();
            }
            block1: for (Edge theEdge : theInternalLabel.outgoingEdges().collect(Collectors.toList())) {
                RegionNode theTarget = (RegionNode)theEdge.targetNode();
                if (theEdge.edgeType() == ControlFlowEdgeType.forward) {
                    for (int i = aTraversalStack.size() - 1; i >= 0; --i) {
                        Block theNestingBlock = (Block)aTraversalStack.get(i);
                        if (theNestingBlock.next() != null && theNestingBlock.next().entries().contains(theTarget)) {
                            theNestingBlock.requireLabel();
                            continue block1;
                        }
                        if (!theNestingBlock.entries().contains(theTarget)) continue;
                        theNestingBlock.requireLabel();
                        continue block1;
                    }
                    continue;
                }
                for (Block theNestingBlock : aTraversalStack) {
                    if (!theNestingBlock.entries().contains(theTarget) || !(theNestingBlock instanceof LoopBlock)) continue;
                    theNestingBlock.requireLabel();
                    continue block1;
                }
            }
            return;
        }
        if (aBlock instanceof LoopBlock) {
            LoopBlock theLoop = (LoopBlock)aBlock;
            aTraversalStack.push(theLoop);
            this.replaceGotosIn(aTraversalStack, theLoop.inner());
            this.replaceGotosIn(aTraversalStack, theLoop.next());
            aTraversalStack.pop();
            return;
        }
        if (aBlock instanceof IFThenElseBlock) {
            IFThenElseBlock theIf = (IFThenElseBlock)aBlock;
            aTraversalStack.push(theIf);
            this.replaceGotosIn(aTraversalStack, theIf.getTrueBlock());
            this.replaceGotosIn(aTraversalStack, theIf.getFalseBlock());
            this.replaceGotosIn(aTraversalStack, theIf.next());
            aTraversalStack.pop();
            return;
        }
        if (aBlock instanceof MultipleBlock) {
            MultipleBlock theMultiple = (MultipleBlock)aBlock;
            aTraversalStack.push(theMultiple);
            for (Block theHandler : theMultiple.handlers()) {
                this.replaceGotosIn(aTraversalStack, theHandler);
            }
            this.replaceGotosIn(aTraversalStack, theMultiple.next());
            aTraversalStack.pop();
            return;
        }
        throw new IllegalStateException("Don't know how to handle " + aBlock);
    }

    private void replaceGotosIn(Stack<Block> aTraversalStack, SimpleBlock aCurrent, RegionNode aLabel, ExpressionList aList) {
        for (Expression theExpression : aList.toList()) {
            if (theExpression instanceof ExpressionListContainer) {
                ExpressionListContainer theContainer = (ExpressionListContainer)((Object)theExpression);
                for (ExpressionList theList : theContainer.getExpressionLists()) {
                    this.replaceGotosIn(aTraversalStack, aCurrent, aLabel, theList);
                }
            }
            if (!(theExpression instanceof GotoExpression)) continue;
            GotoExpression theGoto = (GotoExpression)theExpression;
            boolean theGotoFound = false;
            block2: for (Edge theEdge : aLabel.outgoingEdges().collect(Collectors.toList())) {
                RegionNode theTarget = (RegionNode)theEdge.targetNode();
                if (!Objects.equals(theTarget.getStartAddress(), theGoto.jumpTarget())) continue;
                theGotoFound = true;
                if (theEdge.edgeType() == ControlFlowEdgeType.forward) {
                    for (int i = aTraversalStack.size() - 1; i >= 0; --i) {
                        Block theNestingBlock = (Block)aTraversalStack.get(i);
                        if (theNestingBlock.next() != null && theNestingBlock.next().entries().contains(theTarget)) {
                            theNestingBlock.requireLabel();
                            BreakExpression theBreak = new BreakExpression(theGoto.getProgram(), theGoto.getAddress(), theNestingBlock.label(), theTarget.getStartAddress());
                            aList.replace((Expression)theGoto, theBreak);
                            if (!(theNestingBlock.next() instanceof SimpleBlock) || theNestingBlock.next().entries().size() != 1) continue block2;
                            theBreak.noSetRequired();
                            continue block2;
                        }
                        if (!theNestingBlock.entries().contains(theTarget)) continue;
                        theNestingBlock.requireLabel();
                        ContinueExpression theContinue = new ContinueExpression(theGoto.getProgram(), theGoto.getAddress(), theNestingBlock.label(), theTarget.getStartAddress());
                        aList.replace((Expression)theGoto, theContinue);
                        continue block2;
                    }
                    throw new IllegalStateException("Failed to jump to " + theTarget.getStartAddress().getAddress() + " from " + aCurrent.label().name() + " : no matching entry found!");
                }
                boolean theSomethingFound = false;
                for (Block theNestingBlock : aTraversalStack) {
                    if (!theNestingBlock.entries().contains(theTarget) || !(theNestingBlock instanceof LoopBlock)) continue;
                    theSomethingFound = true;
                    theNestingBlock.requireLabel();
                    ContinueExpression theContinue = new ContinueExpression(theGoto.getProgram(), theGoto.getAddress(), theNestingBlock.label(), theTarget.getStartAddress());
                    aList.replace((Expression)theGoto, theContinue);
                    break;
                }
                if (theSomethingFound) continue;
                throw new IllegalStateException("No back edge target from " + aLabel.getStartAddress().getAddress() + " to " + theTarget.getStartAddress().getAddress());
            }
            if (theGotoFound) continue;
            throw new IllegalStateException("No GOTO possible for " + theGoto.jumpTarget().getAddress() + " in label " + aCurrent.label().name());
        }
    }

    private Block reloop(ControlFlowGraph aGraph, Set<RegionNode> aEntryLabels, Set<RegionNode> aLabelSoup) {
        RegionNode theEntry;
        if (aEntryLabels.isEmpty()) {
            return null;
        }
        Set<RegionNode> theJumptargets = this.jumpTargetsOf(aLabelSoup);
        if (aEntryLabels.size() == 1 && !theJumptargets.contains(theEntry = aEntryLabels.iterator().next())) {
            return this.createSimpleBlock(aGraph, aEntryLabels, aLabelSoup, theEntry);
        }
        if (theJumptargets.containsAll(aEntryLabels) && aEntryLabels.size() == 1) {
            RegionNode theSingleEntry = aEntryLabels.iterator().next();
            Set<RegionNode> theInternalLabels = theSingleEntry.dominatedNodes().stream().filter(aLabelSoup::contains).collect(Collectors.toSet());
            HashSet<RegionNode> theRestLabels = new HashSet<RegionNode>(aLabelSoup);
            theRestLabels.removeAll(theInternalLabels);
            HashSet<RegionNode> theRestEntries = new HashSet<RegionNode>();
            for (RegionNode regionNode : theSingleEntry.dominatedNodes()) {
                regionNode.outgoingEdges().filter(t -> t.edgeType() == ControlFlowEdgeType.forward).forEach(edge -> {
                    if (theRestLabels.contains(edge.targetNode())) {
                        theRestEntries.add((RegionNode)edge.targetNode());
                    }
                });
            }
            Block theInternalBlock = this.createSimpleBlock(aGraph, aEntryLabels, theInternalLabels, theSingleEntry);
            Block block = this.reloop(aGraph, theRestEntries, theRestLabels);
            return new LoopBlock(aEntryLabels, theInternalBlock, block);
        }
        if (aEntryLabels.size() > 1) {
            HashSet<RegionNode> theRest = new HashSet<RegionNode>(aLabelSoup);
            HashSet<RegionNode> theRestEntries = new HashSet<RegionNode>();
            HashMap<RegionNode, Set<RegionNode>> theEntryReaches = new HashMap<RegionNode, Set<RegionNode>>();
            HashSet<Block> theHandlers = new HashSet<Block>();
            for (RegionNode regionNode : aEntryLabels) {
                Set<RegionNode> theDominated = regionNode.dominatedNodes().stream().filter(aLabelSoup::contains).collect(Collectors.toSet());
                theEntryReaches.put(regionNode, theDominated);
                theRest.removeAll(theDominated);
                HashSet<RegionNode> theHandlerEntries = new HashSet<RegionNode>();
                theHandlerEntries.add(regionNode);
                theHandlers.add(this.reloop(aGraph, theHandlerEntries, theDominated));
            }
            for (Map.Entry entry : theEntryReaches.entrySet()) {
                for (RegionNode theJumpTarget : this.allForwardJumpTargetsOf((Collection)entry.getValue())) {
                    if (!theRest.contains(theJumpTarget)) continue;
                    theRestEntries.add(theJumpTarget);
                }
            }
            Block theNext = this.reloop(aGraph, theRestEntries, theRest);
            return new MultipleBlock(aEntryLabels, theHandlers, theNext);
        }
        throw new IllegalStateException("What do do now?");
    }

    private Block createSimpleBlock(ControlFlowGraph aGraph, Set<RegionNode> aEntryLabels, Set<RegionNode> aLabelSoup, RegionNode aEntry) {
        if (this.compileOptions.isEnableExceptions()) {
            ArrayList<TryBlock.CatchBlock> catchBlocks = new ArrayList<TryBlock.CatchBlock>();
            Block finallyBlock = null;
            List<RegionNode.ExceptionHandler> theHandlers = aGraph.exceptionHandlersStartingAt(aEntry.getStartAddress());
            if (!theHandlers.isEmpty()) {
                if (theHandlers.size() != 1) {
                    throw new IllegalStateException("Overlapping exception handling regions not yet supported!");
                }
                RegionNode.ExceptionHandler theSingleHandler = theHandlers.get(0);
                HashSet<RegionNode> theInnerNodes = new HashSet<RegionNode>();
                Set theIncludesHandlers = theSingleHandler.getCatchEntries().stream().map(BytecodeExceptionTableEntry::getHandlerPc).collect(Collectors.toSet());
                HashSet<BytecodeOpcodeAddress> theFinallyHandlers = new HashSet<BytecodeOpcodeAddress>();
                for (BytecodeExceptionTableEntry theEntry : aGraph.getProgram().getFlowInformation().getProgram().getExceptionHandlers()) {
                    if (theIncludesHandlers.contains(theEntry.getHandlerPc())) {
                        for (RegionNode regionNode : aLabelSoup) {
                            if (!theEntry.coveres(regionNode.getStartAddress())) continue;
                            theInnerNodes.add(regionNode);
                        }
                        continue;
                    }
                    if (!theEntry.isFinally() || !theEntry.getStartPC().equals(aEntry.getStartAddress())) continue;
                    theFinallyHandlers.add(theEntry.getHandlerPc());
                }
                HashSet<RegionNode> theNextNodes = new HashSet<RegionNode>(aLabelSoup);
                theNextNodes.removeAll(theInnerNodes);
                HashSet<RegionNode> theNextEntries = new HashSet<RegionNode>();
                for (RegionNode regionNode : theInnerNodes) {
                    for (Object theEdge : regionNode.outgoingEdges().collect(Collectors.toList())) {
                        if (!theNextNodes.contains(((Edge)theEdge).targetNode())) continue;
                        theNextEntries.add((RegionNode)((Edge)theEdge).targetNode());
                    }
                }
                theInnerNodes.remove(aEntry);
                HashSet<RegionNode> theInnerEntries = new HashSet<RegionNode>();
                for (Edge theEdge : aEntry.outgoingEdges().collect(Collectors.toList())) {
                    if (!theInnerNodes.contains(theEdge.targetNode())) continue;
                    theInnerEntries.add((RegionNode)theEdge.targetNode());
                }
                SimpleBlock simpleBlock = new SimpleBlock(theInnerEntries, aEntry, this.reloop(aGraph, theInnerEntries, theInnerNodes));
                HashMap<BytecodeOpcodeAddress, Set> theAssignedHandlers = new HashMap<BytecodeOpcodeAddress, Set>();
                for (BytecodeExceptionTableEntry bytecodeExceptionTableEntry : theSingleHandler.getCatchEntries()) {
                    if (bytecodeExceptionTableEntry.isFinally()) continue;
                    Set theCatchTypes = theAssignedHandlers.computeIfAbsent(bytecodeExceptionTableEntry.getHandlerPc(), k -> new HashSet());
                    theCatchTypes.add(bytecodeExceptionTableEntry.getCatchType().getConstant());
                }
                for (Map.Entry entry : theAssignedHandlers.entrySet()) {
                    HashSet<RegionNode> theEntries = new HashSet<RegionNode>();
                    RegionNode theHandlerStart = aGraph.nodeStartingAt((BytecodeOpcodeAddress)entry.getKey());
                    theEntries.add(theHandlerStart);
                    Set<RegionNode> theTagSoup = theHandlerStart.dominatedNodes();
                    theNextNodes.remove(theHandlerStart);
                    theNextEntries.remove(theHandlerStart);
                    theNextNodes.removeAll(theTagSoup);
                    theNextEntries.removeAll(theTagSoup);
                    for (RegionNode theInner : theTagSoup) {
                        for (Edge theEdge : theInner.outgoingEdges().collect(Collectors.toList())) {
                            if (!theNextNodes.contains(theEdge.targetNode())) continue;
                            theNextEntries.add((RegionNode)theEdge.targetNode());
                        }
                    }
                    TryBlock.CatchBlock theCatchBlock = new TryBlock.CatchBlock((Set)entry.getValue(), this.reloop(aGraph, theEntries, theTagSoup));
                    catchBlocks.add(theCatchBlock);
                }
                if (!theFinallyHandlers.isEmpty()) {
                    if (theFinallyHandlers.size() != 1) {
                        throw new IllegalStateException("More than one finally handler found ! Size = " + theFinallyHandlers.size());
                    }
                    RegionNode theFinallyNode = aGraph.nodeStartingAt((BytecodeOpcodeAddress)new ArrayList(theFinallyHandlers).get(0));
                    HashSet<RegionNode> hashSet = new HashSet<RegionNode>();
                    hashSet.add(theFinallyNode);
                    Set<RegionNode> theDominated = theFinallyNode.dominatedNodes();
                    finallyBlock = this.reloop(aGraph, hashSet, theDominated);
                    theNextEntries.remove(theFinallyNode);
                    theNextNodes.remove(theFinallyNode);
                    theNextNodes.removeAll(theDominated);
                }
                Block theTryNext = theNextNodes.isEmpty() ? null : this.reloop(aGraph, theNextEntries, theNextNodes);
                Collections.reverse(catchBlocks);
                return new TryBlock(aEntryLabels, simpleBlock, theTryNext, catchBlocks, finallyBlock);
            }
        }
        List<Expression> theExpressions = aEntry.getExpressions().toList();
        for (int i = 0; i < theExpressions.size(); ++i) {
            Expression theLast;
            Expression theExpression = theExpressions.get(i);
            if (!(theExpression instanceof IFExpression)) continue;
            IFExpression theIf = (IFExpression)theExpression;
            if (i >= theExpressions.size() - 1 || !((theLast = theExpressions.get(theExpressions.size() - 1)) instanceof GotoExpression)) continue;
            GotoExpression theGoto = (GotoExpression)theLast;
            RegionNode theTrueBranch = aGraph.nodeStartingAt(theIf.getGotoAddress());
            RegionNode theFalseBranch = aGraph.nodeStartingAt(theGoto.jumpTarget());
            if (theTrueBranch.isImmediatelyDominatedBy(aEntry) && theFalseBranch.isImmediatelyDominatedBy(aEntry)) {
                RegionNode theNode;
                Value theCondition = (Value)theIf.incomingDataFlows().get(0);
                HashSet<RegionNode> theNextEntries = new HashSet<RegionNode>();
                HashSet<RegionNode> hashSet = new HashSet<RegionNode>(aLabelSoup);
                Set<RegionNode> theTrueDominated = theTrueBranch.dominatedNodes();
                Set<RegionNode> theFalseDominated = theFalseBranch.dominatedNodes();
                hashSet.removeAll(theTrueDominated);
                hashSet.removeAll(theFalseDominated);
                hashSet.remove(aEntry);
                for (RegionNode theTrue : theTrueDominated) {
                    for (Edge theEdge : theTrue.outgoingEdges().collect(Collectors.toList())) {
                        theNode = (RegionNode)theEdge.targetNode();
                        if (theEdge.edgeType() != ControlFlowEdgeType.forward || !hashSet.contains(theNode)) continue;
                        theNextEntries.add(theNode);
                    }
                }
                for (RegionNode theFalse : theFalseDominated) {
                    for (Edge theEdge : theFalse.outgoingEdges().collect(Collectors.toList())) {
                        theNode = (RegionNode)theEdge.targetNode();
                        if (theEdge.edgeType() != ControlFlowEdgeType.forward || !hashSet.contains(theNode)) continue;
                        theNextEntries.add(theNode);
                    }
                }
                Block block = this.reloop(aGraph, Collections.singleton(theTrueBranch), theTrueDominated);
                Block theFalseBranchBlock = this.reloop(aGraph, Collections.singleton(theFalseBranch), theFalseDominated);
                ExpressionList thePrelude = new ExpressionList();
                for (int j = 0; j < i; ++j) {
                    thePrelude.add(theExpressions.get(j));
                }
                Block theNextBlock = null;
                if (!theNextEntries.isEmpty()) {
                    theNextBlock = this.reloop(aGraph, theNextEntries, hashSet);
                }
                return new IFThenElseBlock(thePrelude, Collections.singleton(aEntry), theCondition, block, theFalseBranchBlock, theNextBlock);
            }
            if (!theTrueBranch.isImmediatelyDominatedBy(aEntry) && !theFalseBranch.isImmediatelyDominatedBy(aEntry)) continue;
        }
        HashSet<RegionNode> theNextEntries = new HashSet<RegionNode>();
        Set<RegionNode> theDominated = aEntry.dominatedNodes();
        for (Edge theEdge : aEntry.outgoingEdges().collect(Collectors.toList())) {
            RegionNode theNode;
            if (theEdge.edgeType() != ControlFlowEdgeType.forward || !theDominated.contains(theNode = (RegionNode)theEdge.targetNode()) || !aLabelSoup.contains(theNode)) continue;
            theNextEntries.add(theNode);
        }
        HashSet<RegionNode> theOtherLabels = new HashSet<RegionNode>(aEntry.dominatedNodes());
        theOtherLabels.remove(aEntry);
        return new SimpleBlock(aEntryLabels, aEntry, this.reloop(aGraph, theNextEntries, theOtherLabels));
    }

    private Set<RegionNode> jumpTargetsOf(Collection<RegionNode> aLabelSoup) {
        HashSet<RegionNode> theResults = new HashSet<RegionNode>();
        for (RegionNode theNode : aLabelSoup) {
            for (Edge theEdge : theNode.outgoingEdges().collect(Collectors.toList())) {
                if (!aLabelSoup.contains(theEdge.targetNode())) continue;
                theResults.add((RegionNode)theEdge.targetNode());
            }
        }
        return theResults;
    }

    private Set<RegionNode> allForwardJumpTargetsOf(Collection<RegionNode> aLabelSoup) {
        HashSet<RegionNode> theResults = new HashSet<RegionNode>();
        for (RegionNode theNode : aLabelSoup) {
            for (Edge theEdge : theNode.outgoingEdges().collect(Collectors.toList())) {
                if (theEdge.edgeType() != ControlFlowEdgeType.forward) continue;
                theResults.add((RegionNode)theEdge.targetNode());
            }
        }
        return theResults;
    }

    public static class MultipleBlock
    extends Block {
        private final Set<Block> handlers;
        private final Block next;

        public MultipleBlock(Set<RegionNode> aEntries, Set<Block> aHandlers, Block aNext) {
            super(aEntries, "M_");
            this.handlers = aHandlers;
            this.next = aNext;
        }

        public Set<Block> handlers() {
            return this.handlers;
        }

        @Override
        public Block next() {
            return this.next;
        }

        @Override
        public boolean containsMultipleBlock() {
            return true;
        }
    }

    public static class LoopBlock
    extends Block {
        private final Block inner;
        private final Block next;

        public LoopBlock(Set<RegionNode> aEntries, Block aInner, Block aNext) {
            super(aEntries, "L_");
            this.inner = aInner;
            this.next = aNext;
        }

        public Block inner() {
            return this.inner;
        }

        @Override
        public Block next() {
            return this.next;
        }

        @Override
        public boolean containsMultipleBlock() {
            if (this.inner.containsMultipleBlock()) {
                return true;
            }
            if (this.next != null) {
                return this.next.containsMultipleBlock();
            }
            return false;
        }
    }

    public static class TryBlock
    extends Block {
        private final Block inner;
        private final Block next;
        private final List<CatchBlock> catchBlocks;
        private final Block finallyBlock;

        public TryBlock(Set<RegionNode> aEntries, Block inner, Block next, List<CatchBlock> catchBlocks, Block finallyBlock) {
            super(aEntries, "T_");
            this.inner = inner;
            this.next = next;
            this.catchBlocks = catchBlocks;
            this.finallyBlock = finallyBlock;
        }

        public Block inner() {
            return this.inner;
        }

        @Override
        public Block next() {
            return this.next;
        }

        @Override
        public boolean containsMultipleBlock() {
            if (this.inner.containsMultipleBlock()) {
                return true;
            }
            for (CatchBlock theCatch : this.catchBlocks) {
                if (!theCatch.handler.containsMultipleBlock()) continue;
                return true;
            }
            if (this.next != null && this.next.containsMultipleBlock()) {
                return true;
            }
            if (this.finallyBlock != null) {
                return this.finallyBlock.containsMultipleBlock();
            }
            return false;
        }

        public List<CatchBlock> getCatchBlocks() {
            return this.catchBlocks;
        }

        public Block getFinallyBlock() {
            return this.finallyBlock;
        }

        public static class CatchBlock {
            private final Set<BytecodeUtf8Constant> caughtExceptions;
            private final Block handler;

            public CatchBlock(Set<BytecodeUtf8Constant> caughtExceptions, Block handler) {
                this.caughtExceptions = caughtExceptions;
                this.handler = handler;
            }

            public Set<BytecodeUtf8Constant> getCaughtExceptions() {
                return this.caughtExceptions;
            }

            public Block getHandler() {
                return this.handler;
            }
        }
    }

    public static class IFThenElseBlock
    extends Block {
        private final ExpressionList prelude;
        private final Value condition;
        private final Block trueBlock;
        private final Block falseBlock;
        private final Block nextBlock;

        public IFThenElseBlock(ExpressionList aPrelude, Set<RegionNode> aEntries, Value condition, Block trueBlock, Block falseBlock, Block nextBlock) {
            super(aEntries, "IF_");
            this.prelude = aPrelude;
            this.condition = condition;
            this.trueBlock = trueBlock;
            this.falseBlock = falseBlock;
            this.nextBlock = nextBlock;
        }

        public Value getCondition() {
            return this.condition;
        }

        public Block getTrueBlock() {
            return this.trueBlock;
        }

        public Block getFalseBlock() {
            return this.falseBlock;
        }

        @Override
        public Block next() {
            return this.nextBlock;
        }

        @Override
        public boolean containsMultipleBlock() {
            if (this.trueBlock != null && this.trueBlock.containsMultipleBlock()) {
                return true;
            }
            if (this.falseBlock != null && this.falseBlock.containsMultipleBlock()) {
                return true;
            }
            if (this.nextBlock != null) {
                return this.nextBlock.containsMultipleBlock();
            }
            return false;
        }

        public ExpressionList getPrelude() {
            return this.prelude;
        }
    }

    public static class SimpleBlock
    extends Block {
        private final RegionNode internalLabel;
        private final Block next;
        private final ExpressionList expressionList;

        public SimpleBlock(Set<RegionNode> aEntries, RegionNode aInternalLabel, Block aNext) {
            super(aEntries, "S_");
            this.internalLabel = aInternalLabel;
            this.next = aNext;
            this.expressionList = aInternalLabel.getExpressions().deepCopy();
        }

        public RegionNode internalLabel() {
            return this.internalLabel;
        }

        public ExpressionList expressions() {
            return this.expressionList;
        }

        @Override
        public Block next() {
            return this.next;
        }

        @Override
        public boolean containsMultipleBlock() {
            if (this.next != null) {
                return this.next.containsMultipleBlock();
            }
            return false;
        }
    }

    public static abstract class Block {
        private final Set<RegionNode> entries;
        private final Label label;
        private int labelRequired;

        protected Block(Set<RegionNode> aEntries, String aLabelPrefix) {
            this.entries = aEntries;
            StringBuilder theBuilder = new StringBuilder();
            for (RegionNode aLabel : aEntries) {
                if (theBuilder.length() > 0) {
                    theBuilder.append("_");
                }
                theBuilder.append(aLabel.getStartAddress().getAddress());
            }
            this.labelRequired = 0;
            this.label = new Label(aLabelPrefix + theBuilder.toString());
        }

        public Label label() {
            return this.label;
        }

        public boolean isLabelRequired() {
            return this.labelRequired > 0;
        }

        public void requireLabel() {
            ++this.labelRequired;
        }

        public List<RegionNode> entries() {
            ArrayList<RegionNode> theResult = new ArrayList<RegionNode>(this.entries);
            theResult.sort(Comparator.comparingInt(o -> o.getStartAddress().getAddress()));
            return theResult;
        }

        public abstract Block next();

        public abstract boolean containsMultipleBlock();
    }
}

